/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.systems.imt2020downlink.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import org.seamcat.model.systems.imt2020downlink.ui.IMT2020Layout;
import org.seamcat.model.systems.imt2020downlink.ui.IMT2020PositionHolder;
import org.seamcat.model.systems.imt2020downlink.ui.IMT2020SystemPanel;
import org.seamcat.model.systems.imt2020downlink.ui.ReferenceCellSelectionPanel;
import org.seamcat.model.systems.imt2020downlink.ui.SystemLayoutPanel;
import org.seamcat.presentation.components.BorderPanel;
import org.seamcat.presentation.components.ScrollingBorderPanel;

public class IMT2020LayoutPanel
extends JPanel {
    private static final ResourceBundle STRINGLIST = ResourceBundle.getBundle("stringlist", Locale.ENGLISH);
    private final ReferenceCellSelectionPanel referenceCellSelectionPanel;
    private final IMT2020SystemPanel systemPanel;
    private final SystemLayoutPanel systemLayoutPanel;

    public IMT2020LayoutPanel(boolean ofdma, IMT2020Layout model) {
        super(new BorderLayout());
        JSplitPane leftSplit = new JSplitPane(0);
        JSplitPane container = new JSplitPane(1);
        Refresher refresher = new Refresher();
        this.systemPanel = new IMT2020SystemPanel(refresher);
        boolean entireEnable = true;
        if (ofdma) {
            entireEnable = false;
        }
        this.systemLayoutPanel = new SystemLayoutPanel(entireEnable, refresher);
        this.referenceCellSelectionPanel = new ReferenceCellSelectionPanel();
        IMT2020PositionHolder uiModel = new IMT2020PositionHolder();
        uiModel.set(model);
        this.systemPanel.setModel(uiModel);
        this.systemLayoutPanel.setModel(uiModel);
        this.referenceCellSelectionPanel.setModel(uiModel);
        leftSplit.add(new ScrollingBorderPanel(this.systemPanel, "System", "System help", "http://confluence.seamcat.org/display/SH/7.5.1+System"));
        leftSplit.setDividerLocation(250);
        leftSplit.add(new ScrollingBorderPanel(this.systemLayoutPanel, "System Layout - reference cell selection", "System layout help", "http://confluence.seamcat.org/pages/viewpage.action?pageId=1409483", STRINGLIST.getString("CDMA_REFERENCE_NOTE")));
        container.add(leftSplit);
        container.setDividerLocation(390);
        container.add(new BorderPanel(this.referenceCellSelectionPanel, "Macro Layout", "Macro Layout help", "http://confluence.seamcat.org/display/SH/7.5.3+System+layout+preview"));
        this.add((Component)container, "Center");
        this.refreshFromModel();
    }

    private void updateModel() {
        this.systemPanel.updateModel();
        this.systemLayoutPanel.updateModel();
    }

    public IMT2020Layout getModel() {
        this.updateModel();
        return this.systemPanel.getModel().get();
    }

    private void refreshFromModel() {
        this.systemPanel.refreshFromModel();
        this.systemLayoutPanel.refreshFromModel();
        this.referenceCellSelectionPanel.refreshFromModel();
    }

    public class Refresher {
        void refresh() {
            IMT2020LayoutPanel.this.refreshFromModel();
        }
    }
}

