/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.systems.imt2020downlink.ui;

import org.seamcat.model.distributions.Distribution;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.plugin.Config;
import org.seamcat.model.systems.cdma.Defaults;
import org.seamcat.model.types.AntennaGain;

public interface IMT2020MacroBaseStation {
    public static final Distribution antennaHeight = Factory.distributionFactory().getConstantDistribution(30.0);
    public static final AzimuthPointing azimuth = AzimuthPointing.X_AXIS;
    public static final Distribution azimuthOffset = Factory.distributionFactory().getConstantDistribution(0.0);
    public static final ElevationPointing elevation = ElevationPointing.HORIZONTAL;
    public static final Distribution elevationOffset = Factory.distributionFactory().getConstantDistribution(-3.0);
    public static final AntennaGain antennaGain = Defaults.defaultBaseStationGain();

    @Config(order=1, name="Antenna height", unit="m", distributions={"CONSTANT", "USER_DEFINED", "UNIFORM", "STAIR", "DISCRETE_UNIFORM"})
    public Distribution antennaHeight();

    @Config(order=2, name="Azimuth pointing reference (i.e. 0 degree) for the BS", renderHint="radio")
    public AzimuthPointing azimuth();

    @Config(order=3, name="Azimuth additional offset", unit="deg", distributions={"CONSTANT", "USER_DEFINED", "UNIFORM", "STAIR", "DISCRETE_UNIFORM", "UNIFORM_POLAR_ANGLE"})
    public Distribution azimuthOffset();

    @Config(order=4, name="Elevation pointing reference (i.e. 0 degree) for the BS", renderHint="radio")
    public ElevationPointing elevation();

    @Config(order=5, name="Elevation additional offset", unit="deg", distributions={"CONSTANT", "USER_DEFINED", "UNIFORM", "STAIR", "DISCRETE_UNIFORM", "UNIFORM_POLAR_ANGLE"})
    public Distribution elevationOffset();

    @Config(order=6, name="antenna", embed=true)
    public AntennaGain antennaGain();

    public static enum ElevationPointing {
        HORIZONTAL("horizontal"),
        TOWARD_MS("towards the MS");

        private String title;

        private ElevationPointing(String title) {
            this.title = title;
        }

        public String toString() {
            return this.title;
        }
    }

    public static enum AzimuthPointing {
        X_AXIS("x-axis"),
        TOWARD_MS("towards the MS");

        private String title;

        private AzimuthPointing(String title) {
            this.title = title;
        }

        public String toString() {
            return this.title;
        }
    }
}

