/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.systems.imt2020downlink.ui;

import org.seamcat.model.distributions.Distribution;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.plugin.Config;
import org.seamcat.model.systems.imt2020downlink.ui.IMT2020MacroBaseStation;
import org.seamcat.model.types.AntennaGain;

public interface IMT2020MicroBaseStation {
    public static final Distribution antennaHeight = Factory.distributionFactory().getConstantDistribution(1.5);
    public static final Distribution azimuthOffset = Factory.distributionFactory().getConstantDistribution(0.0);
    public static final Distribution elevationOffset = Factory.distributionFactory().getConstantDistribution(-3.0);
    public static final int cellClusters = 2;
    public static final int microBSPerCluster = 3;
    public static final double clusterRadius = 2.0;

    @Config(order=1, name="Antenna height", unit="m", distributions={"CONSTANT", "USER_DEFINED", "UNIFORM", "STAIR", "DISCRETE_UNIFORM"})
    public Distribution antennaHeight();

    @Config(order=2, name="Azimuth pointing reference (i.e. 0 degree) for the BS", renderHint="radio")
    public IMT2020MacroBaseStation.AzimuthPointing azimuth();

    @Config(order=3, name="Azimuth additional offset", unit="deg", distributions={"CONSTANT", "USER_DEFINED", "UNIFORM", "STAIR", "DISCRETE_UNIFORM", "UNIFORM_POLAR_ANGLE"})
    public Distribution azimuthOffset();

    @Config(order=4, name="Elevation pointing reference (i.e. 0 degree) for the BS", renderHint="radio")
    public IMT2020MacroBaseStation.ElevationPointing elevation();

    @Config(order=5, name="Elevation additional offset", unit="deg", distributions={"CONSTANT", "USER_DEFINED", "UNIFORM", "STAIR", "DISCRETE_UNIFORM", "UNIFORM_POLAR_ANGLE"})
    public Distribution elevationOffset();

    @Config(order=6, name="Antenna gain", embed=true)
    public AntennaGain antennaGain();

    @Config(order=7, name="Number of micro cell clusters per macro cell sector")
    public int cellClusters();

    @Config(order=8, name="Number of micro BS per cluster")
    public int microBSPerCluster();

    @Config(order=9, name="Cluster radius", unit="km")
    public double clusterRadius();
}

