/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.systems.imt2020uplink;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.seamcat.model.RadioSystem;
import org.seamcat.model.Scenario;
import org.seamcat.model.distributions.UniformDistribution;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.functions.Bounds;
import org.seamcat.model.functions.VectorSpace;
import org.seamcat.model.generic.PathLossCorrelationUI;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.model.plugin.OptionalValue;
import org.seamcat.model.plugin.system.ConsistencyCheckContext;
import org.seamcat.model.plugin.system.Context;
import org.seamcat.model.plugin.system.CorrelationMode;
import org.seamcat.model.plugin.system.Origin;
import org.seamcat.model.plugin.system.SimulationInstance;
import org.seamcat.model.plugin.system.SystemPlugin;
import org.seamcat.model.plugin.system.SystemSpaces;
import org.seamcat.model.plugin.system.optional.AsVictimInterferingLink;
import org.seamcat.model.plugin.system.optional.AsVictimInterferingLinkDefinition;
import org.seamcat.model.plugin.system.optional.CorrelationDefinitions;
import org.seamcat.model.plugin.system.optional.InterferenceNames;
import org.seamcat.model.simulation.consistency.Validator;
import org.seamcat.model.simulation.result.UniqueValueDef;
import org.seamcat.model.simulation.result.VectorDef;
import org.seamcat.model.simulation.result.Victim;
import org.seamcat.model.simulation.result.VictimResultCollector;
import org.seamcat.model.systems.UIToModelConverter;
import org.seamcat.model.systems.cellulargrid.HexagonCells;
import org.seamcat.model.systems.imt2020downlink.ui.IMT2020Layout;
import org.seamcat.model.systems.imt2020downlink.ui.IMT2020MacroBaseStation;
import org.seamcat.model.systems.imt2020downlink.ui.IMT2020Mobile;
import org.seamcat.model.systems.imt2020uplink.simulation.CouplingLossEstimator;
import org.seamcat.model.systems.imt2020uplink.simulation.IMT2020UpLinkSettings;
import org.seamcat.model.systems.imt2020uplink.simulation.IMT2020UpLinkSimulation;
import org.seamcat.model.systems.imt2020uplink.simulation.IMT2020UplinkConsistencyCheck;
import org.seamcat.model.systems.imt2020uplink.simulation.VictimImpl;
import org.seamcat.model.systems.imt2020uplink.ui.IMT2020UpLinkGeneralSettings;
import org.seamcat.model.systems.imt2020uplink.ui.SystemModelIMT2020UpLink;
import org.seamcat.model.systems.ofdma.ReceiverSettings;
import org.seamcat.model.systems.ofdma.TransmitterSettings;
import org.seamcat.model.systems.ofdmauplink.OFDMAUpLinkSystemPlugin;
import org.seamcat.model.types.AntennaGain;
import org.seamcat.model.types.PropagationModel;
import org.seamcat.model.types.Receiver;
import org.seamcat.model.types.Transmitter;
import org.seamcat.model.types.Unit;
import org.seamcat.model.types.result.DoubleResultType;
import org.seamcat.model.types.result.Results;
import org.seamcat.plugin.AntennaGainConfiguration;
import org.seamcat.simulation.cellular.CellularCalculations;
import org.seamcat.simulation.cellular.PathLossCorrelation;
import org.seamcat.simulation.hybrid.HybridSystemPlugin;

public class IMT2020UpLinkSystemPlugin
implements SystemPlugin<SystemModelIMT2020UpLink>,
CorrelationDefinitions,
InterferenceNames,
AsVictimInterferingLink {
    public static final UniqueValueDef SIMULATION_FREQUENCY = Factory.results().single("Frequency", "MHz");
    public static final UniqueValueDef THERMAL_NOISE = Factory.results().single("Thermal noise", "dBm");
    public static final UniqueValueDef THERMAL_NOISE_UE = Factory.results().single("Thermal noise UE", "dBm");
    public static final UniqueValueDef COUPLING_LOSS_PERCENTILE = Factory.results().single("Coupling loss percentile", "");
    public static final UniqueValueDef SUB_CARRIER_RATIO = Factory.results().single("Sub carrier ratio", "Ratio");
    public static final VectorDef initialVictimOutage = Factory.results().value("Non Interfered Bitrate, ref cell", Unit.kbps.name());
    public static final VectorDef interferedBitRateRefCell = Factory.results().value("Interfered Bitrate, ref. cell", "kbps");
    public static final VectorDef SINRSystem = Factory.results().value("SINR, Victim system", "dB");
    public static final VectorDef SINRRefCell = Factory.results().value("SINR, Victim ref. cell", "dB");
    public static final VectorDef AVGAchievedBitRateSystem = Factory.results().value("Avg Non Interfered Bitrate, system", "kbps");
    public static final VectorDef avgInterferedBitRateSystem = Factory.results().value("Avg Interfered Bitrate, system", "kbps");
    private SystemModelIMT2020UpLink ui;
    private RadioSystem victim;
    private RadioSystem interferer;
    private IMT2020UpLinkSettings settings;
    private HybridSystemPlugin.SectorSetup sector;
    private double cellRadius;
    private HybridSystemPlugin.SystemLayout layout;
    private int refSector;
    private int refCellId;
    private double interCellDistance;
    private HybridSystemPlugin.TierSetup tierSetup;
    private PropagationModel propagationModel;

    public IMT2020UpLinkSettings getSettings() {
        return this.settings;
    }

    @Override
    public String title() {
        return "Total sum per BS in reference cell";
    }

    @Override
    public String information() {
        return "Sum of contributions of all external interferer(s) perceived by the BS.";
    }

    @Override
    public String unwantedName() {
        return "iRSS Unwanted (external Interference)";
    }

    @Override
    public String blockingName() {
        return "iRSS Blocking (external Interference)";
    }

    @Override
    public List<AsVictimInterferingLinkDefinition> definitions() {
        ArrayList<AsVictimInterferingLinkDefinition> list = new ArrayList<AsVictimInterferingLinkDefinition>();
        list.add(new AsVictimInterferingLinkDefinition(){

            @Override
            public String getName() {
                return "Path loss correlation";
            }

            @Override
            public String getInformation() {
                return "org.seamcat.model.generic.PathLossCorrelationUI.info";
            }

            @Override
            public Class getUIClass() {
                return PathLossCorrelationUI.class;
            }
        });
        return list;
    }

    @Override
    public void consistencyCheck(ConsistencyCheckContext context, Scenario scenario, Validator validator) {
        IMT2020UplinkConsistencyCheck.checkMacroSystem(scenario, context, validator);
        if (context.getOrigin() == Origin.INTERFERENCE_LINK) {
            IMT2020UplinkConsistencyCheck.checkPathLossCorrelationInterferer(context, validator);
        }
    }

    @Override
    public Bounds getSystemCoverage() {
        double min = 0.0;
        boolean isNot3GPP = this.getSectorSetup() == HybridSystemPlugin.SectorSetup.TriSector3GPP2 || this.getSectorSetup().getSectors() == 1;
        double cellRadius = this.getCellRadius();
        if (isNot3GPP) {
            cellRadius /= Math.sqrt(3.0);
        }
        int numberOfTiers = this.getTierSetup().ordinal();
        double networkRadius = 3.0 * cellRadius * (double)numberOfTiers + 2.0 * cellRadius;
        if (this.isUsingWrapAround()) {
            networkRadius *= 2.0;
        }
        VectorSpace network = VectorSpace.ZERO.addCircle(new Bounds(0.0, networkRadius, true));
        double max = network.getCoverage().getMax();
        return new Bounds(min, max, true);
    }

    @Override
    public VectorSpace getInterferenceLinkSystemCoverage(boolean victim, ConsistencyCheckContext context) {
        boolean isNot3GPP = this.getSectorSetup() == HybridSystemPlugin.SectorSetup.TriSector3GPP2 || this.getSectorSetup().getSectors() == 1;
        double cellRadius = this.getCellRadius();
        if (isNot3GPP) {
            cellRadius /= Math.sqrt(3.0);
        }
        int refCellID = this.getIndexOfReferenceCell();
        int networkLayoutIndex = this.getSystemLayout().ordinal();
        int numberOfTiers = this.getTierSetup().ordinal();
        double networkRadius = 3.0 * cellRadius * (double)numberOfTiers + 2.0 * cellRadius;
        VectorSpace range = VectorSpace.ZERO;
        return range.addCircle(new Bounds(0.0, networkRadius, true));
    }

    @Override
    public Point2D getVictimPosition(VictimResultCollector collector, String correlationPoint) {
        for (Victim victim : collector.getVictims()) {
            if (!(victim instanceof VictimImpl) || !((VictimImpl)victim).isConnectedToReferenceCell()) continue;
            return victim.getLinkResult().rxAntenna().getPosition();
        }
        return Point2D.ORIGIN;
    }

    @Override
    public List<String> getVictimCorrelationPoints() {
        return Collections.singletonList("Victim BS ref.cell");
    }

    @Override
    public List<CorrelationMode> getCorrelationModes() {
        ArrayList<CorrelationMode> modes = new ArrayList<CorrelationMode>();
        modes.add(Factory.correlationModes().getNone());
        modes.add(Factory.correlationModes().getCorrelated());
        return modes;
    }

    @Override
    public boolean allowCoLocation() {
        return false;
    }

    @Override
    public List<String> getInterfererTargetPointNames() {
        return Collections.singletonList("Interfering BS ref.cell");
    }

    @Override
    public void setUI(SystemModelIMT2020UpLink ui) {
        this.ui = ui;
        this.setLayout(ui.positioning().position());
    }

    public void setLayout(IMT2020Layout layout) {
        this.sector = layout.sectorType();
        int tiers = layout.tiers();
        this.tierSetup = tiers == 0 ? HybridSystemPlugin.TierSetup.SingleCell : (tiers == 1 ? HybridSystemPlugin.TierSetup.OneTier : HybridSystemPlugin.TierSetup.TwoTiers);
        this.cellRadius = layout.cellRadius();
        this.refCellId = layout.referenceCellId();
        this.refSector = layout.referenceSector();
        this.layout = layout.layout();
    }

    @Override
    public SystemModelIMT2020UpLink getUI() {
        return this.ui;
    }

    @Override
    public void prepareSimulation(Scenario scenario) {
        IMT2020UpLinkGeneralSettings gen = this.ui.generalSettings().generalSettings();
        this.sector = this.ui.positioning().position().sectorType();
        IMT2020MacroBaseStation bs = this.ui.positioning().macroBS();
        AntennaGain[] antennas = CellularCalculations.createSectorAntennas(this.sector, (AntennaGainConfiguration)bs.antennaGain());
        int tiers = this.ui.positioning().position().tiers();
        this.tierSetup = tiers == 0 ? HybridSystemPlugin.TierSetup.SingleCell : (tiers == 1 ? HybridSystemPlugin.TierSetup.OneTier : HybridSystemPlugin.TierSetup.TwoTiers);
        this.cellRadius = this.ui.positioning().position().cellRadius();
        this.interCellDistance = 0.0;
        this.interCellDistance = this.sector != HybridSystemPlugin.SectorSetup.TriSector3GPP ? this.cellRadius * Mathematics.SQRT3 : this.cellRadius * 3.0;
        PathLossCorrelationUI plUI = this.ui.generalSettings().pathLossCorrelation();
        PathLossCorrelation plCorr = new PathLossCorrelation(plUI.usePathLossCorrelation(), plUI.pathLossVariance(), plUI.correlationFactor());
        this.layout = this.ui.positioning().position().layout();
        this.refSector = this.ui.positioning().position().referenceSector();
        this.refCellId = this.ui.positioning().position().referenceCellId();
        ReceiverSettings rx = this.ui.generalSettings().receiverSettings();
        double bandwidth = gen.bandwidthResourceBlock() * (double)gen.maxSubcarriersMs() / 1000.0;
        Receiver vReceiver = UIToModelConverter.getDmaReceiver(rx.standardDesensitisation(), rx.targetINR(), gen.receiverNoiseFigure(), rx.blockingMask(), bandwidth, Factory.results().convert(this.ui.generalSettings().localEnvironments().receiverEnvironments()), bs.antennaGain(), bs.antennaHeight());
        bandwidth = gen.bandwidthResourceBlock() * (double)gen.maxSubcarriersBs() / 1000.0;
        Receiver iReceiver = UIToModelConverter.getDmaReceiver(rx.standardDesensitisation(), rx.targetINR(), gen.receiverNoiseFigure(), rx.blockingMask(), bandwidth, Factory.results().convert(this.ui.generalSettings().localEnvironments().receiverEnvironments()), bs.antennaGain(), bs.antennaHeight());
        TransmitterSettings tx = this.ui.generalSettings().transmitterSettings();
        bandwidth = gen.bandwidthResourceBlock() * (double)gen.maxSubcarriersMs() / 1000.0;
        IMT2020Mobile ms = this.ui.positioning().mobile();
        Transmitter transmitter = new Transmitter(tx.emissionMask(), tx.emissionFloor().getValue(), tx.emissionFloor().isRelevant(), bandwidth, null, Factory.results().convert(this.ui.generalSettings().localEnvironments().transmitterEnvironments()), ms.antennaGain(), ms.antennaHeight(), 0.0, false);
        this.propagationModel = this.ui.generalSettings().propagationModel();
        this.victim = new RadioSystem(vReceiver, transmitter, this.propagationModel);
        this.interferer = new RadioSystem(iReceiver, transmitter, this.propagationModel);
        this.settings = new IMT2020UpLinkSettings(this.victim, gen, plCorr, this.ui.generalSettings().ofdmaUpLink(), this.ui.generalSettings().ueDistribution(), bs.antennaHeight(), ms.antennaGain(), ms.antennaHeight(), ms.azimuth(), ms.azimuthOffset(), ms.elevation(), ms.elevationOffset(), bs.azimuth(), bs.azimuthOffset(), bs.elevation(), bs.elevationOffset());
        if (antennas.length == 1) {
            this.settings.setBsGain(antennas[0]);
        } else {
            this.settings.setBsGains(antennas);
        }
    }

    @Override
    public RadioSystem getSystem(Context context) {
        if (context.isVictim()) {
            return this.victim;
        }
        return this.interferer;
    }

    @Override
    public void preSimulation(Context context, Results results) {
        UniformDistribution freq;
        double bw;
        double frequency = context.getFrequency().trial();
        results.getSingleValueTypes().add(new DoubleResultType(SIMULATION_FREQUENCY, frequency));
        double noise = CellularCalculations.calculateThermalNoise(this.settings.getSystemBandwidth(), this.settings.getReceiverNoiseFigure());
        results.getSingleValueTypes().add(new DoubleResultType(THERMAL_NOISE, noise));
        noise = CellularCalculations.calculateThermalNoise((double)this.settings.getMaxRBsPrMS() * this.settings.getBandwidthOfAnRB() * 0.001, this.settings.getReceiverNoiseFigure());
        results.getSingleValueTypes().add(new DoubleResultType(THERMAL_NOISE_UE, noise));
        double ratio = (double)this.settings.getMaxRBsPrMS() / (double)this.settings.getMaxRBsPrBS();
        results.getSingleValueTypes().add(new DoubleResultType(SUB_CARRIER_RATIO, ratio));
        if (context.isVictim()) {
            bw = (double)this.settings.getMaxRBsPrBS() * this.settings.getBandwidthOfAnRB() / 1000.0;
            freq = Factory.distributionFactory().getUniformDistribution(frequency - bw / 2.0, frequency + bw / 2.0);
        } else {
            bw = this.interferer.getReceiver().getBandwidth();
            freq = Factory.distributionFactory().getUniformDistribution(frequency - bw / 2.0, frequency + bw / 2.0);
        }
        context.getSystemPlugin().setFrequency(freq);
        double clp = this.getPercentile().isRelevant() ? this.getPercentile().getValue() : CouplingLossEstimator.estimate(this, frequency);
        results.getSingleValueTypes().add(new DoubleResultType(COUPLING_LOSS_PERCENTILE, clp));
    }

    @Override
    public void postSimulation(Context context, Results results) {
        if (context.isVictim()) {
            double refCell = OFDMAUpLinkSystemPlugin.averagePercentage(results.findVector(initialVictimOutage), results.findVector(interferedBitRateRefCell));
            results.getSingleValueTypes().add(new DoubleResultType(Factory.results().single("Average bitrate loss (ref. cell)", "%"), refCell));
            double system = OFDMAUpLinkSystemPlugin.averagePercentage(results.findVector(AVGAchievedBitRateSystem), results.findVector(avgInterferedBitRateSystem));
            results.getSingleValueTypes().add(new DoubleResultType(Factory.results().single("Average bitrate loss (system)", "%"), system));
        }
    }

    @Override
    public SimulationInstance simulationInstance(Context context, SystemSpaces shapes) {
        return new IMT2020UpLinkSimulation(this, shapes);
    }

    public HybridSystemPlugin.SectorSetup getSectorSetup() {
        return this.sector;
    }

    public HybridSystemPlugin.TierSetup getTierSetup() {
        return this.tierSetup;
    }

    public double getCellRadius() {
        return this.cellRadius;
    }

    public HybridSystemPlugin.SystemLayout getSystemLayout() {
        return this.layout;
    }

    public int getIndexOfReferenceCell() {
        return this.refCellId;
    }

    public int getReferenceSector() {
        return this.refSector;
    }

    public double getInterCellDistance() {
        return this.interCellDistance;
    }

    public boolean isUsingWrapAround() {
        return this.ui.positioning().position().generateWrapAround();
    }

    public List<Double> getProbabilities() {
        return this.ui.generalSettings().ueDistribution().probabilities();
    }

    public double getMinimumTransmitPowerOfMS() {
        return this.ui.generalSettings().ofdmaUpLink().getMinimumTransmitPowerOfMS();
    }

    public double getMaximumAllowedTransmitPowerOfMS() {
        return this.ui.generalSettings().ofdmaUpLink().getMaximumAllowedTransmitPowerOfMS();
    }

    public double getBalancingFactor() {
        return this.ui.generalSettings().ofdmaUpLink().getBalancingFactor();
    }

    public OptionalValue<Double> getPercentile() {
        return this.ui.generalSettings().ofdmaUpLink().percentile();
    }

    public double getPowerScalingThreshold() {
        return this.ui.generalSettings().ofdmaUpLink().getPowerScalingThreshold();
    }

    public PropagationModel getPropagationModel() {
        return this.propagationModel;
    }

    public boolean triSector() {
        return this.sector != HybridSystemPlugin.SectorSetup.SingleSector;
    }

    @Override
    public SystemSpaces generateSystemSpaces(SystemSpaces enclosing) {
        return HexagonCells.generate(true, this.getCellRadius(), this.getTierSetup(), this.getSectorSetup(), this.getIndexOfReferenceCell());
    }
}

