/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.systems.imt2020uplink.simulation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.seamcat.model.factory.RandomAccessor;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.plugin.system.SystemSpaces;
import org.seamcat.model.systems.imt2020uplink.IMT2020UpLinkSystemPlugin;
import org.seamcat.model.systems.imt2020uplink.simulation.IMT2020UpLinkSimulation;
import org.seamcat.model.systems.imt2020uplink.simulation.Link;

public class CouplingLossEstimator {
    public static double estimate(IMT2020UpLinkSystemPlugin plugin, double frequency) {
        ArrayList<Double> pathLosses = new ArrayList<Double>();
        return CouplingLossEstimator.estimate(plugin, frequency, pathLosses);
    }

    public static double estimate(IMT2020UpLinkSystemPlugin plugin, double frequency, List<Double> effectivePathLoss) {
        RandomAccessor.fixSeed(RandomAccessor.getRandom().nextLong());
        while (effectivePathLoss.size() < 1000) {
            SystemSpaces spaces = plugin.generateSystemSpaces(null);
            IMT2020UpLinkSimulation simulation = new IMT2020UpLinkSimulation(plugin, spaces);
            List<Link> links = simulation.positionAndConnect(Point2D.ORIGIN, frequency, spaces);
            for (Link active : links) {
                effectivePathLoss.add(active.getEffectivePathloss());
            }
        }
        Collections.sort(effectivePathLoss);
        return CouplingLossEstimator.calculatePowerControlledPathlossLimit(plugin.getPowerScalingThreshold(), effectivePathLoss);
    }

    private static double calculatePowerControlledPathlossLimit(double threshold, List<Double> effectivePathLoss) {
        int floor = (int)Math.floor(threshold / (1.0 / (double)effectivePathLoss.size()));
        return effectivePathLoss.get(floor);
    }
}

