/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.systems.imt2020uplink.simulation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.seamcat.model.factory.RandomAccessor;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.plugin.system.SystemSpaces;
import org.seamcat.model.systems.imt2020uplink.IMT2020UpLinkMicroSystemPlugin;
import org.seamcat.model.systems.imt2020uplink.simulation.IMT2020UpLinkMicroSimulation;
import org.seamcat.model.systems.imt2020uplink.simulation.Link;

public class CouplingLossEstimatorMicro {
    public static double estimate(IMT2020UpLinkMicroSystemPlugin plugin, double frequency) {
        ArrayList<Double> pathLosses = new ArrayList<Double>();
        return CouplingLossEstimatorMicro.estimate(plugin, frequency, pathLosses);
    }

    public static double estimate(IMT2020UpLinkMicroSystemPlugin plugin, double frequency, List<Double> effectivePathLoss) {
        RandomAccessor.fixSeed(RandomAccessor.getRandom().nextLong());
        while (effectivePathLoss.size() < 1000) {
            SystemSpaces spaces = plugin.generateSystemSpaces(null);
            IMT2020UpLinkMicroSimulation simulation = new IMT2020UpLinkMicroSimulation(plugin, spaces);
            List<Link> links = simulation.positionAndConnect(Point2D.ORIGIN, frequency, spaces);
            for (Link active : links) {
                effectivePathLoss.add(active.getEffectivePathloss());
            }
        }
        Collections.sort(effectivePathLoss);
        return CouplingLossEstimatorMicro.calculatePowerControlledPathlossLimit(plugin.getPowerScalingThreshold(), effectivePathLoss);
    }

    private static double calculatePowerControlledPathlossLimit(double threshold, List<Double> effectivePathLoss) {
        int floor = (int)Math.floor(threshold / (1.0 / (double)effectivePathLoss.size()));
        return effectivePathLoss.get(floor);
    }
}

