/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.systems.imt2020uplink.simulation;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.seamcat.model.distributions.GaussianDistribution;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.generic.PathLossCorrelationUI;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.model.simulation.result.EventResult;
import org.seamcat.model.simulation.result.Interferer;
import org.seamcat.model.simulation.result.InterfererResultCollector;
import org.seamcat.model.simulation.result.VectorDef;
import org.seamcat.model.simulation.result.Victim;
import org.seamcat.model.simulation.result.VictimResultCollector;
import org.seamcat.model.systems.imt2020uplink.IMT2020UpLinkSystemPlugin;
import org.seamcat.model.systems.imt2020uplink.simulation.Link;
import org.seamcat.model.systems.imt2020uplink.simulation.MobileStation;
import org.seamcat.model.systems.imt2020uplink.simulation.VictimImpl;
import org.seamcat.simulation.cellular.OFDMADownLinkVictimSystemSimulation;

class IMT2020UpLinkCalculations {
    IMT2020UpLinkCalculations() {
    }

    static List<Link> scalePower(List<Link> activeLinks, double couplingLossPercentile, double thermalNoiseUE) {
        for (Link activeLink : activeLinks) {
            activeLink.getUserTerminal().scalePower(couplingLossPercentile);
        }
        for (Link activeLink : activeLinks) {
            activeLink.getUserTerminal().calculateSINR(thermalNoiseUE);
        }
        return activeLinks;
    }

    static void calculateVictimResults(VictimResultCollector collector) {
        double bitrateAll = 0.0;
        double bitrateRefCell = 0.0;
        HashSet<Integer> uniqueBS = new HashSet<Integer>();
        for (Victim victim : collector.getVictims()) {
            if (!(victim instanceof VictimImpl)) continue;
            VictimImpl victimImpl = (VictimImpl)victim;
            MobileStation ue = victimImpl.getUserTerminal();
            uniqueBS.add(victimImpl.getBaseStationId());
            ue.calculateAchievedBitrate();
            bitrateAll += ue.getAchievedBitrate();
            if (!victimImpl.isConnectedToReferenceCell()) continue;
            bitrateRefCell += ue.getAchievedBitrate();
        }
        collector.add(IMT2020UpLinkSystemPlugin.initialVictimOutage, bitrateRefCell);
        collector.add(IMT2020UpLinkSystemPlugin.AVGAchievedBitRateSystem, bitrateAll / (double)uniqueBS.size());
        LinkedHashMap<VectorDef, List<Double>> vectors = new LinkedHashMap<VectorDef, List<Double>>();
        for (Victim victim : collector.getVictims()) {
            VictimImpl v = (VictimImpl)victim;
            IMT2020UpLinkCalculations.handle(vectors, v);
        }
        for (Map.Entry entry : vectors.entrySet()) {
            collector.add((VectorDef)entry.getKey(), (List)entry.getValue());
        }
    }

    private static void handle(Map<VectorDef, List<Double>> vectors, VictimImpl victim) {
        IMT2020UpLinkCalculations.append(vectors, OFDMADownLinkVictimSystemSimulation.FREQUENCY_ALL, victim.getUEFrequency());
        IMT2020UpLinkCalculations.append(vectors, OFDMADownLinkVictimSystemSimulation.BIT_RATE_ACHIEVED_ALL, victim.getNonInterferedAchievedBitrate());
        IMT2020UpLinkCalculations.append(vectors, OFDMADownLinkVictimSystemSimulation.RECEIVED_POWER_ALL, victim.getReceivePower());
        IMT2020UpLinkCalculations.append(vectors, OFDMADownLinkVictimSystemSimulation.SINR_ACHIEVED_ALL, victim.getNonInterferedAchievedSINR());
        IMT2020UpLinkCalculations.append(vectors, OFDMADownLinkVictimSystemSimulation.PATH_LOSS_ALL, victim.getLinkResult().getTxRxPathLoss());
        IMT2020UpLinkCalculations.append(vectors, OFDMADownLinkVictimSystemSimulation.EFFECTIVE_PATH_LOSS_ALL, victim.getLinkResult().getEffectiveTxRxPathLoss());
        IMT2020UpLinkCalculations.append(vectors, OFDMADownLinkVictimSystemSimulation.CURRENT_TRANSMIT_POWER_ALL, victim.getCurrentTransmitPower());
        if (victim.isConnectedToReferenceCell()) {
            IMT2020UpLinkCalculations.append(vectors, OFDMADownLinkVictimSystemSimulation.FREQUENCY, victim.getUEFrequency());
            IMT2020UpLinkCalculations.append(vectors, OFDMADownLinkVictimSystemSimulation.BIT_RATE_ACHIEVED, victim.getNonInterferedAchievedBitrate());
            IMT2020UpLinkCalculations.append(vectors, OFDMADownLinkVictimSystemSimulation.RECEIVED_POWER, victim.getReceivePower());
            IMT2020UpLinkCalculations.append(vectors, OFDMADownLinkVictimSystemSimulation.SINR_ACHIEVED, victim.getNonInterferedAchievedSINR());
            IMT2020UpLinkCalculations.append(vectors, OFDMADownLinkVictimSystemSimulation.PATH_LOSS, victim.getLinkResult().getTxRxPathLoss());
            IMT2020UpLinkCalculations.append(vectors, OFDMADownLinkVictimSystemSimulation.EFFECTIVE_PATH_LOSS, victim.getLinkResult().getEffectiveTxRxPathLoss());
            IMT2020UpLinkCalculations.append(vectors, OFDMADownLinkVictimSystemSimulation.CURRENT_TRANSMIT_POWER, victim.getCurrentTransmitPower());
        }
    }

    private static void append(Map<VectorDef, List<Double>> vectors, VectorDef def, double value) {
        List<Double> values = vectors.get(def);
        if (values == null) {
            values = new ArrayList<Double>();
            vectors.put(def, values);
        }
        values.add(value);
    }

    static void calculateInterferedVictim(EventResult eventResult) {
        for (InterfererResultCollector col : eventResult.getAllInterferingSystemResults()) {
            for (Interferer interferer : col.getInterferingElements()) {
                PathLossCorrelationUI ui = col.getLink().getCorrelationSettings().getCorrelationConfiguration(PathLossCorrelationUI.class);
                if (!ui.usePathLossCorrelation()) continue;
                GaussianDistribution var = Factory.distributionFactory().getGaussianDistribution(0.0, ui.pathLossVariance());
                double x = var.trial();
                double correlationExternalInterferer = ui.correlationFactor();
                double a_ext = Math.sqrt(Math.abs(correlationExternalInterferer));
                double b_ext = Math.sqrt(1.0 - Math.abs(correlationExternalInterferer));
                double y = var.trial();
                double pathloss = interferer.getLinkResult().getTxRxPathLoss();
                interferer.getLinkResult().setTxRxPathLoss(pathloss += a_ext * x + b_ext * y);
            }
        }
        VictimResultCollector vCollector = eventResult.getVictimResult();
        double sinrSum = 0.0;
        double sinrRefCellSum = 0.0;
        int refCellCount = 0;
        int size = vCollector.getVictims().size();
        double refCellBitrate = 0.0;
        double totalBitrate = 0.0;
        HashSet<Integer> uniqueBS = new HashSet<Integer>();
        for (Victim victim : vCollector.getVictims()) {
            if (!(victim instanceof VictimImpl)) continue;
            VictimImpl vi = (VictimImpl)victim;
            uniqueBS.add(vi.getBaseStationId());
            vi.calculateAchievedSINRWatt();
            double sinr = Mathematics.dB2Linear(vi.getAchievedSINR());
            vi.calculateAchievedBitrate();
            double ach = vi.getAchievedBitrate();
            totalBitrate += ach;
            if (vi.isConnectedToReferenceCell()) {
                sinrRefCellSum += sinr;
                ++refCellCount;
                refCellBitrate += ach;
            }
            sinrSum += sinr;
        }
        double sinrAvg = size == 0 ? 0.0 : sinrSum / (double)size;
        vCollector.add(IMT2020UpLinkSystemPlugin.avgInterferedBitRateSystem, totalBitrate / (double)uniqueBS.size());
        vCollector.add(IMT2020UpLinkSystemPlugin.SINRSystem, Mathematics.linear2dB(sinrAvg));
        double avg = refCellCount == 0 ? 0.0 : sinrRefCellSum / (double)refCellCount;
        vCollector.add(IMT2020UpLinkSystemPlugin.SINRRefCell, Mathematics.linear2dB(avg));
        vCollector.add(IMT2020UpLinkSystemPlugin.interferedBitRateRefCell, refCellBitrate);
    }
}

