/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.systems.imt2020uplink.simulation;

import java.util.ArrayList;
import java.util.List;
import org.seamcat.model.RadioSystem;
import org.seamcat.model.distributions.Distribution;
import org.seamcat.model.functions.Function;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.geometry.PolygonUtil;
import org.seamcat.model.plugin.OptionalValue;
import org.seamcat.model.plugin.system.Space;
import org.seamcat.model.systems.imt2020downlink.ui.IMT2020MacroBaseStation;
import org.seamcat.model.systems.imt2020downlink.ui.IMT2020Mobile;
import org.seamcat.model.systems.imt2020uplink.simulation.BaseStation;
import org.seamcat.model.systems.imt2020uplink.simulation.Link;
import org.seamcat.model.systems.imt2020uplink.simulation.MobileStation;
import org.seamcat.model.systems.imt2020uplink.ui.IMT2020UpLinkGeneralSettings;
import org.seamcat.model.systems.ofdma.OFDMAUEDistribution;
import org.seamcat.model.systems.ofdmauplink.ui.OFDMAUpLinkUI;
import org.seamcat.model.types.AntennaGain;
import org.seamcat.model.types.LocalEnvironment;
import org.seamcat.simulation.cellular.PathLossCorrelation;

public class IMT2020UpLinkSettings {
    private final boolean useUE;
    private final Integer valueUE;
    private final List<Double> probabilities;
    private final double balancingFactor;
    private final double maximumAllowedTransmitPowerOfMS;
    private final double minimumTransmitPowerOfMS;
    private final double powerScalingThreshold;
    private final OptionalValue<Double> percentile;
    private final IMT2020Mobile.AzimuthPointing msAzimuthPointing;
    private final Distribution msAzimuthOffset;
    private final IMT2020Mobile.ElevationPointing msElevationPointing;
    private final Distribution msElevationOffset;
    private final IMT2020MacroBaseStation.AzimuthPointing bsAzimuthPointing;
    private final Distribution bsAzimuthOffset;
    private final IMT2020MacroBaseStation.ElevationPointing bsElevationPointing;
    private PathLossCorrelation pl;
    private final RadioSystem system;
    private double mcl;
    private Function bitRateMapping;
    private double rbBandwidth;
    private double bandwidth;
    private double rnFigure;
    private double hoMargin;
    private int maxMs;
    private int maxBs;
    private final Distribution bsHeight;
    private final AntennaGain msGain;
    private final Distribution msHeight;
    private final Distribution bsElevationOffset;
    private AntennaGain bsGain;
    private AntennaGain[] bsGains;

    public IMT2020UpLinkSettings(RadioSystem system, IMT2020UpLinkGeneralSettings gen, PathLossCorrelation pl, OFDMAUpLinkUI uplink, OFDMAUEDistribution ueDist, Distribution bsHeight, AntennaGain msGain, Distribution msHeight, IMT2020Mobile.AzimuthPointing msAzimuthPointing, Distribution msAzimuthOffset, IMT2020Mobile.ElevationPointing msElevationPointing, Distribution msElevationOffset, IMT2020MacroBaseStation.AzimuthPointing bsAzimuthPointing, Distribution bsAzimuthOffset, IMT2020MacroBaseStation.ElevationPointing bsElevationPointing, Distribution bsElevationOffset) {
        this.system = system;
        this.mcl = gen.minimumCouplingLoss();
        this.pl = pl;
        this.bitRateMapping = gen.bitRateMapping().getFunction();
        this.rbBandwidth = gen.bandwidthResourceBlock();
        this.bandwidth = gen.bandwidth();
        this.rnFigure = gen.receiverNoiseFigure();
        this.hoMargin = gen.handoverMargin();
        this.maxMs = gen.maxSubcarriersMs();
        this.maxBs = gen.maxSubcarriersBs();
        this.useUE = ueDist.numberOfActiveMsPerBs().isRelevant();
        this.valueUE = ueDist.numberOfActiveMsPerBs().getValue();
        this.probabilities = ueDist.probabilities();
        this.balancingFactor = uplink.getBalancingFactor();
        this.maximumAllowedTransmitPowerOfMS = uplink.getMaximumAllowedTransmitPowerOfMS();
        this.minimumTransmitPowerOfMS = uplink.getMinimumTransmitPowerOfMS();
        this.powerScalingThreshold = uplink.getPowerScalingThreshold();
        this.percentile = uplink.percentile();
        this.msAzimuthPointing = msAzimuthPointing;
        this.msAzimuthOffset = msAzimuthOffset;
        this.msElevationPointing = msElevationPointing;
        this.msElevationOffset = msElevationOffset;
        this.bsAzimuthPointing = bsAzimuthPointing;
        this.bsAzimuthOffset = bsAzimuthOffset;
        this.bsElevationPointing = bsElevationPointing;
        this.bsHeight = bsHeight;
        this.msGain = msGain;
        this.msHeight = msHeight;
        this.bsElevationOffset = bsElevationOffset;
    }

    public double getMinimumCouplingLoss() {
        return this.mcl;
    }

    public int getMaxRBsPrBS() {
        return this.maxBs;
    }

    public int getMaxRBsPrMS() {
        return this.maxMs;
    }

    public int getNumberOfResourceBlocksPrBS() {
        if (this.useNumberOfActiveMsPerBs()) {
            return this.getNumberOfActiveMsPerBs();
        }
        return (int)Math.floor((double)this.getMaxRBsPrBS() / (double)this.getMaxRBsPrMS());
    }

    public PathLossCorrelation getPathLossCorrelation() {
        return this.pl;
    }

    public double getHandoverMargin() {
        return this.hoMargin;
    }

    public double getReceiverNoiseFigure() {
        return this.rnFigure;
    }

    public double getSystemBandwidth() {
        return this.bandwidth;
    }

    public double getBandwidthOfAnRB() {
        return this.rbBandwidth;
    }

    public Function getBitRateMapping() {
        return this.bitRateMapping;
    }

    public boolean useNumberOfActiveMsPerBs() {
        return this.useUE;
    }

    public int getNumberOfActiveMsPerBs() {
        return this.valueUE;
    }

    public List<Double> getProbabilities() {
        return this.probabilities;
    }

    public AntennaGain getMobileStationGain() {
        return this.msGain;
    }

    public double calculateFrequency(int resourceBlockNumber, double systemFrequency) {
        double systemBandwidth = this.getSystemBandwidth();
        double resourceBlockBandwidth = this.getBandwidthOfAnRB() * 0.001;
        double diff = systemBandwidth - (double)this.getMaxRBsPrBS() * resourceBlockBandwidth;
        return systemFrequency - systemBandwidth / 2.0 + diff / 2.0 + (double)this.getMaxRBsPrMS() * resourceBlockBandwidth / 2.0 * (double)(resourceBlockNumber * 2 + 1);
    }

    public double getMinimumTransmitPowerOfMS() {
        return this.minimumTransmitPowerOfMS;
    }

    public double getMaximumAllowedTransmitPowerOfMS() {
        return this.maximumAllowedTransmitPowerOfMS;
    }

    public double getBalancingFactor() {
        return this.balancingFactor;
    }

    public OptionalValue<Double> getPercentile() {
        return this.percentile;
    }

    public double getBandwidthOfResourceBlock() {
        return this.rbBandwidth;
    }

    public double getPowerScalingThreshold() {
        return this.powerScalingThreshold;
    }

    public List<Link> positionMSsAndInitialConnectBS(List<BaseStation> baseStations, Point2D systemPosition, double frequency, List<Space> txShapes) {
        ArrayList<Link> activeLinks = new ArrayList<Link>();
        ArrayList<BaseStation> coreBaseStations = new ArrayList<BaseStation>();
        for (BaseStation baseStation : baseStations) {
            if (baseStation.isAWrapAroundBS()) continue;
            coreBaseStations.add(baseStation);
        }
        int K = this.getMaxRBsPrBS() / this.getMaxRBsPrMS();
        int msCount = 0;
        for (int iterations = 0; iterations < 10 * K; ++iterations) {
            for (Space txShape : txShapes) {
                for (int i = 0; i < K; ++i) {
                    Point2D position = PolygonUtil.getRandomPointInside(txShape.getSpace()).add(systemPosition);
                    MobileStation ue = new MobileStation(frequency, position, this, this.system, msCount);
                    ++msCount;
                    ue.linkToBSAndAddToCandidateList(baseStations);
                }
            }
            boolean systemIsLoaded = true;
            for (BaseStation bs : coreBaseStations) {
                boolean bsLoaded = bs.initialConnect(activeLinks);
                systemIsLoaded = systemIsLoaded && bsLoaded;
            }
            if (!systemIsLoaded) continue;
            return activeLinks;
        }
        return activeLinks;
    }

    protected BaseStation createWrapAround(BaseStation corresponding, Point2D offset) {
        return new BaseStation(corresponding, offset);
    }

    protected BaseStation create(String name, Point2D position, boolean isReferenceCell, int id, double frequency) {
        AntennaGain ag = this.bsGains == null ? this.bsGain : this.bsGains[id % 3];
        return new BaseStation(name, position, isReferenceCell, id, frequency, this, this.bsHeight.trial(), ag, this.bsElevationOffset.trial());
    }

    public Distribution getMsHeight() {
        return this.msHeight;
    }

    public void setBsGain(AntennaGain bsGain) {
        this.bsGain = bsGain;
    }

    public void setBsGains(AntennaGain[] bsGains) {
        this.bsGains = bsGains;
    }

    public IMT2020Mobile.AzimuthPointing getMsAzimuthPointing() {
        return this.msAzimuthPointing;
    }

    public IMT2020Mobile.ElevationPointing getMsElevationPointing() {
        return this.msElevationPointing;
    }

    public IMT2020MacroBaseStation.AzimuthPointing getBsAzimuthPointing() {
        return this.bsAzimuthPointing;
    }

    public Distribution getMsAzimuthOffset() {
        return this.msAzimuthOffset;
    }

    public Distribution getMsElevationOffset() {
        return this.msElevationOffset;
    }

    public Distribution getBsAzimuthOffset() {
        return this.bsAzimuthOffset;
    }

    public Distribution getBsElevationOffset() {
        return this.bsElevationOffset;
    }

    public IMT2020MacroBaseStation.ElevationPointing getBsElevationPointing() {
        return this.bsElevationPointing;
    }

    public List<LocalEnvironment> getRxEnvironments() {
        return this.system.getReceiver().getLocalEnvironments();
    }

    public List<LocalEnvironment> getTxEnvironments() {
        return this.system.getTransmitter().getLocalEnvironments();
    }
}

