/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.systems.imt2020uplink.simulation;

import org.seamcat.model.engines.InterferenceSimulationEngine;
import org.seamcat.model.simulation.result.DefaultInterfererImpl;
import org.seamcat.model.systems.imt2020uplink.simulation.Link;

class InterfererImpl
extends DefaultInterfererImpl<InterfererImpl> {
    private final int cellid;
    private final Link connection;

    public InterfererImpl(int linkIndex, Link connection, double mcl) {
        super(linkIndex, connection.getUserTerminal().getAntennaGain(), connection.getLinkResult(), mcl);
        this.cellid = connection.getBaseStation().getBaseStationId();
        if (connection.isWrapAroundLink()) {
            connection.getLinkResult().setValue(InterferenceSimulationEngine.SYSTEM_LINK_TYPE, "Secondary Link");
        }
        this.connection = connection;
    }

    @Override
    public boolean isSameRx(InterfererImpl other) {
        return this.cellid == other.cellid;
    }

    @Override
    public String getRxName() {
        return this.connection.getBaseStation().getName();
    }

    @Override
    public String getTxName() {
        return this.connection.getUserTerminal().getName();
    }
}

