/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.systems.imt2020uplink.simulation;

import java.util.Comparator;
import java.util.List;
import org.apache.log4j.Logger;
import org.seamcat.model.RadioSystem;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.factory.RandomAccessor;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.model.plugin.system.SystemPlugin;
import org.seamcat.model.simulation.result.AntennaResult;
import org.seamcat.model.simulation.result.Direction;
import org.seamcat.model.simulation.result.LinkResult;
import org.seamcat.model.systems.imt2020downlink.ui.IMT2020MacroBaseStation;
import org.seamcat.model.systems.imt2020downlink.ui.IMT2020Mobile;
import org.seamcat.model.systems.imt2020uplink.simulation.BaseStation;
import org.seamcat.model.systems.imt2020uplink.simulation.IMT2020UpLinkSettings;
import org.seamcat.model.systems.imt2020uplink.simulation.MobileStation;

class Link {
    protected static final Logger LOG = Logger.getLogger(Link.class);
    static Comparator<Link> comparator = new Comparator<Link>(){

        @Override
        public int compare(Link l1, Link l2) {
            double l2Result;
            if (l1 == null && l2 == null) {
                return 0;
            }
            if (l1 == null) {
                return -1;
            }
            if (l2 == null) {
                return 1;
            }
            double l1Result = l1.txRxPathLoss - l1.gainSum();
            if (l1Result > (l2Result = l2.txRxPathLoss - l2.gainSum())) {
                return 1;
            }
            if (l1Result < l2Result) {
                return -1;
            }
            return 0;
        }

        @Override
        public boolean equals(Object obj) {
            return false;
        }
    };
    private boolean isWrapAround = false;
    private BaseStation basestation;
    private IMT2020UpLinkSettings settings;
    private RadioSystem system;
    private MobileStation user;
    private double currentReceivePower;
    private double txRxPathLoss;
    private double effectivePathLoss;
    private LinkResult linkResult;
    private Integer resourceBlockNumber;

    public Link(IMT2020UpLinkSettings settings, RadioSystem system, BaseStation BS, MobileStation MS, double frequency, double pathLossOffset) {
        this.settings = settings;
        this.system = system;
        this.initialize(BS, MS, frequency);
        this.setTxRxPathLoss(system.getPropagationModel().evaluate(this.linkResult) + pathLossOffset);
    }

    private void setTxRxPathLoss(double txRxPathLoss) {
        this.txRxPathLoss = txRxPathLoss;
        this.linkResult.setTxRxPathLoss(txRxPathLoss);
        this.effectivePathLoss = Math.max(this.linkResult.getTxRxPathLoss() - this.gainSum(), this.settings.getMinimumCouplingLoss());
        this.linkResult.setEffectiveTxRxPathLoss(this.effectivePathLoss);
    }

    private void initialize(BaseStation BS, MobileStation MS, double frequency) {
        this.linkResult = Factory.results().linkResult(this.system, frequency);
        AntennaResult tx = this.linkResult.txAntenna();
        AntennaResult rx = this.linkResult.rxAntenna();
        if (BS.isAWrapAroundBS()) {
            this.isWrapAround = true;
            this.basestation = BS.getCorresponding();
            this.basestation.setAntennaProperties(rx);
            rx.setPosition(this.basestation.getPosition().add(BS.getOffset()));
        } else {
            this.basestation = BS;
            this.basestation.setAntennaProperties(rx);
        }
        this.user = MS;
        this.user.setAntennaProperties(tx);
        this.linkResult.setTxRxDistance(Mathematics.distance(tx.getPosition(), rx.getPosition()));
        double txRxAzi = Mathematics.convertAngleToConfineToHorizontalDefinedRange(Mathematics.calculateKartesianAngle(rx.getPosition(), tx.getPosition()));
        double rxTxAzi = Mathematics.convertAngleToConfineToHorizontalDefinedRange(Mathematics.calculateKartesianAngle(tx.getPosition(), rx.getPosition()));
        this.linkResult.setTxRxAngle(txRxAzi);
        double txRxEle = Mathematics.calculateElevation(tx, rx);
        double azimuthTrial = Mathematics.convertAngleToConfineToHorizontalDefinedRange(this.settings.getMsAzimuthOffset().trial());
        tx.setRandomPanelOffsetAzimuth(azimuthTrial);
        if (this.settings.getMsAzimuthPointing() == IMT2020Mobile.AzimuthPointing.TOWARD_BS) {
            tx.setAzimuthCompensation(rxTxAzi);
            tx.setAzimuth(0.0);
        } else {
            tx.setAzimuth(rxTxAzi - azimuthTrial);
            tx.setAzimuthCompensation(azimuthTrial);
        }
        double elevationTrial = this.settings.getMsElevationOffset().trial();
        tx.setRandomPanelOffsetElevation(elevationTrial);
        if (this.settings.getMsElevationPointing() == IMT2020Mobile.ElevationPointing.TOWARD_BS) {
            tx.setElevationCompensation(-txRxEle);
            tx.setElevation(0.0);
        } else {
            tx.setElevationCompensation(0.0);
            tx.setElevation(-txRxEle);
        }
        tx.setTilt(0.0);
        azimuthTrial = Mathematics.convertAngleToConfineToHorizontalDefinedRange(this.settings.getBsAzimuthOffset().trial());
        if (this.settings.getBsAzimuthPointing() == IMT2020MacroBaseStation.AzimuthPointing.TOWARD_MS) {
            rx.setAzimuthCompensation(txRxAzi);
            rx.setAzimuth(0.0);
            rx.setRandomPanelOffsetAzimuth(azimuthTrial);
        } else {
            rx.setAzimuth(Mathematics.convertAngleToConfineToHorizontalDefinedRange(txRxAzi - azimuthTrial));
            rx.setAzimuthCompensation(azimuthTrial);
            rx.setRandomPanelOffsetAzimuth(azimuthTrial);
        }
        rx.setRandomPanelOffsetElevation(0.0);
        if (this.settings.getBsElevationPointing() == IMT2020MacroBaseStation.ElevationPointing.TOWARD_MS) {
            rx.setElevation(0.0);
            rx.setElevationCompensation(txRxEle);
        } else {
            rx.setElevation(txRxEle);
            rx.setElevationCompensation(0.0);
            rx.setRandomPanelOffsetElevation(this.basestation.getAntennaTilt());
        }
        rx.setTilt(this.basestation.getAntennaTilt());
        rx.setGain(this.basestation.getAntennaGain().evaluate(this.linkResult, rx));
        tx.setGain(this.user.getAntennaGain().evaluate(this.linkResult, tx));
        this.linkResult.assignLocalEnvironment(this.user.getEnvironments(), Direction.To_TX);
        this.linkResult.assignLocalEnvironment(this.basestation.getEnvironments(), Direction.To_RX);
        this.linkResult.trialTxRxInSameBuilding();
        this.linkResult.setValue(SystemPlugin.BANDWIDTH_CORRECTION, Mathematics.linear2dB((double)this.settings.getMaxRBsPrMS() / (double)this.settings.getMaxRBsPrBS()));
    }

    public IMT2020UpLinkSettings getSettings() {
        return this.settings;
    }

    private double gainSum() {
        return this.linkResult.txAntenna().getGain() + this.linkResult.rxAntenna().getGain();
    }

    public BaseStation getBaseStation() {
        return this.basestation;
    }

    public double getEffectivePathloss() {
        return this.effectivePathLoss;
    }

    public MobileStation getUserTerminal() {
        return this.user;
    }

    public double getTxRxPathLoss() {
        return this.txRxPathLoss;
    }

    public double getDistance() {
        return this.linkResult.getTxRxDistance();
    }

    public LinkResult getLinkResult() {
        return this.linkResult;
    }

    public void calculateCurrentReceivePower() {
        double chPower = this.getUserTerminal().getCurrentTransmitPower();
        this.currentReceivePower = chPower - this.getEffectivePathloss();
    }

    public double getCurrentReceivePower() {
        return this.currentReceivePower;
    }

    public String toString() {
        return "IMT-2020 UpLink: BS #" + this.getBaseStation().getBaseStationId() + " -> Mobile #" + this.getUserTerminal().getUserid() + " PL = " + this.getEffectivePathloss();
    }

    public int getResourceBlockNumber() {
        return this.resourceBlockNumber;
    }

    public void activateLink() {
        this.resourceBlockNumber = this.findResourceBlockNumber();
        this.getUserTerminal().setServingLink(this, this.resourceBlockNumber);
    }

    private int findResourceBlockNumber() {
        if (this.settings.useNumberOfActiveMsPerBs()) {
            int index;
            List<Double> props = this.settings.getProbabilities();
            double pick = RandomAccessor.getRandom().nextDouble() * 100.0;
            double limit = 0.0;
            for (index = 0; index < props.size() - 1 && !(pick < (limit += props.get(index).doubleValue())); ++index) {
            }
            return index;
        }
        return this.getBaseStation().getLinkIndexOfActiveUser(this);
    }

    public void addAsCandidate() {
        if (this.isWrapAround) {
            this.linkResult.rxAntenna().setPosition(this.basestation.getPosition());
        }
        this.basestation.addCandidate(this);
    }

    public boolean isWrapAroundLink() {
        return this.isWrapAround;
    }
}

