/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.systems.imt2020uplink.simulation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.seamcat.model.RadioSystem;
import org.seamcat.model.functions.Function;
import org.seamcat.model.functions.FunctionException;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.model.simulation.result.AntennaResult;
import org.seamcat.model.systems.imt2020uplink.simulation.BaseStation;
import org.seamcat.model.systems.imt2020uplink.simulation.IMT2020UpLinkSettings;
import org.seamcat.model.systems.imt2020uplink.simulation.Link;
import org.seamcat.model.types.AntennaGain;
import org.seamcat.model.types.LocalEnvironment;
import org.seamcat.simulation.cellular.PathLossCorrelation;

class MobileStation {
    private List<Link> links;
    private Link servingLink;
    private double antennaHeight;
    private double frequency;
    private IMT2020UpLinkSettings settings;
    private RadioSystem system;
    private final int userid;
    private Point2D position;
    private AntennaGain antennaGain;
    private double currentTransmitPower;
    private double achievedSINR;
    private double achievedBitrate;
    private double totalInterferenceWatt;

    public double getFrequency() {
        return this.frequency;
    }

    public MobileStation(double frequency, Point2D position, IMT2020UpLinkSettings settings, RadioSystem system, int _userid) {
        this.frequency = frequency;
        this.position = position;
        this.settings = settings;
        this.system = system;
        this.userid = _userid;
        this.antennaHeight = settings.getMsHeight().trial();
        this.antennaGain = settings.getMobileStationGain();
        this.currentTransmitPower = settings.getMaximumAllowedTransmitPowerOfMS();
    }

    public Link getServingLink() {
        return this.servingLink;
    }

    public void setServingLink(Link servingLink, int resourceBlockNumber) {
        this.servingLink = servingLink;
        this.frequency = this.settings.calculateFrequency(resourceBlockNumber, this.frequency);
        servingLink.getLinkResult().setFrequency(this.frequency);
        for (Link link : this.links) {
            if (link == servingLink) continue;
            link.getBaseStation().removeCandidate(link);
            link.getBaseStation().addInActive(link);
        }
    }

    public Point2D getPosition() {
        return this.position;
    }

    public AntennaGain getAntennaGain() {
        return this.antennaGain;
    }

    void setAntennaProperties(AntennaResult ant) {
        ant.setHeight(this.antennaHeight);
        ant.setTilt(0.0);
        ant.setPosition(this.position);
    }

    public void linkToBSAndAddToCandidateList(List<BaseStation> baseStations) {
        ArrayList<Link> links = new ArrayList<Link>();
        PathLossCorrelation correlation = this.settings.getPathLossCorrelation();
        double correlationInterSite = correlation.getCorrelationFactor();
        double a_inter = Math.sqrt(Math.abs(correlationInterSite));
        double b_inter = Math.sqrt(1.0 - Math.abs(correlationInterSite));
        double x = correlation.trial();
        for (BaseStation baseStation : baseStations) {
            double y = correlation.trial();
            double pathLossOffset = 0.0;
            if (correlation.isUsingPathLossCorrelation()) {
                pathLossOffset = a_inter * x + b_inter * y;
            }
            Link link = new Link(this.settings, this.system, baseStation, this, this.frequency, pathLossOffset);
            links.add(link);
        }
        Collections.sort(links, Link.comparator);
        ((Link)links.get(0)).addAsCandidate();
        if (links.size() > 1) {
            int index = 1;
            double lowestLink = ((Link)links.get(0)).getEffectivePathloss();
            double nextLink = ((Link)links.get(index)).getEffectivePathloss();
            while (lowestLink + this.settings.getHandoverMargin() > nextLink) {
                ((Link)links.get(index)).addAsCandidate();
                if (++index >= links.size()) break;
                nextLink = ((Link)links.get(index)).getEffectivePathloss();
            }
        }
        this.links = new ArrayList<Link>();
        for (Link link : links) {
            if (link.getBaseStation().isAWrapAroundBS()) continue;
            this.links.add(link);
        }
    }

    public int getUserid() {
        return this.userid;
    }

    void scalePower(double pathloss_limit) {
        double minTxpower = this.settings.getMinimumTransmitPowerOfMS();
        double maxTxpower = this.settings.getMaximumAllowedTransmitPowerOfMS();
        double rMin_linear = Mathematics.fromdBm2Watt(minTxpower) / Mathematics.fromdBm2Watt(maxTxpower);
        double pathloss = this.servingLink.getEffectivePathloss();
        double test_ratio_linear = Mathematics.fromdBm2Watt(pathloss) / Mathematics.fromdBm2Watt(pathloss_limit);
        double p_watt = Mathematics.fromdBm2Watt(this.settings.getMaximumAllowedTransmitPowerOfMS()) * Math.min(1.0, Math.max(rMin_linear, Math.pow(test_ratio_linear, this.settings.getBalancingFactor())));
        this.currentTransmitPower = Mathematics.fromWatt2dBm(p_watt);
        this.servingLink.calculateCurrentReceivePower();
    }

    public double getCurrentTransmitPower() {
        return this.currentTransmitPower;
    }

    public void calculateSINR(double thermalNoiseUE) {
        double rPowerWatt = Mathematics.fromdBm2Watt(this.servingLink.getCurrentReceivePower());
        this.totalInterferenceWatt = this.servingLink.getBaseStation().calculateTotalInterference_Watt(this.servingLink) + Mathematics.fromdBm2Watt(thermalNoiseUE);
        this.achievedSINR = Mathematics.linear2dB(rPowerWatt / this.totalInterferenceWatt);
    }

    public double getAchievedSINR() {
        return this.achievedSINR;
    }

    double getTotalInterferenceWatt() {
        return this.totalInterferenceWatt;
    }

    public void calculateAchievedBitrate() {
        double maxAch = this.getMaxAchievableBitRate(this.achievedSINR);
        int requestedSubCarriers = this.settings.getMaxRBsPrMS();
        this.achievedBitrate = (double)requestedSubCarriers * (maxAch / (double)this.settings.getMaxRBsPrBS());
    }

    public double getAchievedBitrate() {
        return this.achievedBitrate;
    }

    double getMaxAchievableBitRate(double sinr) {
        Function function = this.settings.getBitRateMapping();
        double value = 0.0;
        if (sinr < function.getBounds().getMin()) {
            value = function.evaluateMin();
        } else if (sinr > function.getBounds().getMax()) {
            value = function.evaluateMax();
        } else {
            try {
                value = function.evaluate(sinr);
            }
            catch (FunctionException ex) {
                throw new RuntimeException(ex);
            }
        }
        return this.settings.getBandwidthOfAnRB() * (double)this.settings.getMaxRBsPrMS() * value;
    }

    public String toString() {
        return "MS#" + this.userid + " " + this.getPosition();
    }

    public List<LocalEnvironment> getEnvironments() {
        return this.settings.getTxEnvironments();
    }

    public String getName() {
        return "MS " + (this.userid + 1);
    }
}

