/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.systems.ofdma;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import org.seamcat.model.distributions.Distribution;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.model.systems.ofdma.OFDMAUpLinkGeneralSettings;
import org.seamcat.presentation.DialogHelper;
import org.seamcat.presentation.EscapeDialog;
import org.seamcat.presentation.MainWindow;
import org.seamcat.presentation.components.NavigateButtonPanel;

public class FrequencySchedulingDialog
extends EscapeDialog {
    private final Distribution frequency;
    private final OFDMAUpLinkGeneralSettings settings;
    private double frequencyBase;
    private double msFrequencyBandwidth;
    private final List<Double> frequencyProbabilities;

    public FrequencySchedulingDialog(Distribution frequency, OFDMAUpLinkGeneralSettings settings, int size) {
        super((Frame)MainWindow.getInstance(), true);
        this.frequency = frequency;
        this.settings = settings;
        this.frequencyProbabilities = new ArrayList<Double>();
        double avg = 100.0 / (double)size;
        for (int i = 0; i < size; ++i) {
            this.frequencyProbabilities.add(avg);
        }
        this.initialize();
    }

    public FrequencySchedulingDialog(Distribution frequency, OFDMAUpLinkGeneralSettings settings, List<Double> frequencyProbabilities) {
        super((Frame)MainWindow.getInstance(), true);
        this.frequency = frequency;
        this.settings = settings;
        this.frequencyProbabilities = frequencyProbabilities;
        this.initialize();
    }

    private void calculateFrequencyBands() {
        this.frequencyBase = this.frequency.getBounds().getMin() - this.settings.bandwidth() / 2.0 + (this.settings.bandwidth() - (double)this.settings.maxSubcarriersBs() * this.settings.bandwidthResourceBlock() / 1000.0) / 2.0;
        this.msFrequencyBandwidth = (double)this.settings.maxSubcarriersMs() * this.settings.bandwidthResourceBlock() / 2000.0;
    }

    private void initialize() {
        this.calculateFrequencyBands();
        final int size = this.frequencyProbabilities.size();
        JTable table = new JTable();
        final DefaultTableModel model = new DefaultTableModel(){

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                if (columnIndex == 0) {
                    return String.class;
                }
                return Double.class;
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return column == 1;
            }

            @Override
            public String getColumnName(int column) {
                if (column == 0) {
                    return "Frequency";
                }
                return "Probability";
            }

            @Override
            public Object getValueAt(int row, int column) {
                int num = row * 2 + 1;
                if (column == 0) {
                    if (num == 1) {
                        return "MS Frequency 1: " + FrequencySchedulingDialog.this.frequencyBase + " + " + FrequencySchedulingDialog.this.msFrequencyBandwidth + " = " + (FrequencySchedulingDialog.this.frequencyBase + FrequencySchedulingDialog.this.msFrequencyBandwidth);
                    }
                    return "MS Frequency " + (row + 1) + ": " + FrequencySchedulingDialog.this.frequencyBase + " + " + num + "*" + FrequencySchedulingDialog.this.msFrequencyBandwidth + " = " + (FrequencySchedulingDialog.this.frequencyBase + (double)num * FrequencySchedulingDialog.this.msFrequencyBandwidth);
                }
                return super.getValueAt(row, column);
            }

            @Override
            public int getColumnCount() {
                return 2;
            }

            @Override
            public int getRowCount() {
                return size;
            }
        };
        for (int i = 0; i < size; ++i) {
            model.setValueAt(this.frequencyProbabilities.get(i), i, 1);
        }
        table.setFillsViewportHeight(true);
        JPanel main = new JPanel(new BorderLayout());
        JScrollPane scrollPane = new JScrollPane(table);
        scrollPane.setHorizontalScrollBarPolicy(30);
        main.add((Component)scrollPane, "Center");
        JButton jButton = new JButton("Reset probabilities");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                double avg = 100.0 / (double)size;
                for (int i = 0; i < FrequencySchedulingDialog.this.frequencyProbabilities.size(); ++i) {
                    model.setValueAt(avg, i, 1);
                    FrequencySchedulingDialog.this.frequencyProbabilities.set(i, avg);
                    model.fireTableDataChanged();
                }
            }
        });
        main.add((Component)jButton, "South");
        table.setModel(model);
        table.getColumnModel().getColumn(0).setPreferredWidth(250);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)main, "Center");
        this.getContentPane().add((Component)new NavigateButtonPanel(this, false){

            @Override
            public void btnOkActionPerformed() {
                int i;
                double sum = 0.0;
                for (i = 0; i < FrequencySchedulingDialog.this.frequencyProbabilities.size(); ++i) {
                    sum += ((Double)model.getValueAt(i, 1)).doubleValue();
                }
                if (!Mathematics.equals(100.0, sum, 0.01)) {
                    DialogHelper.mustSumTo100(sum);
                    return;
                }
                for (i = 0; i < size; ++i) {
                    FrequencySchedulingDialog.this.frequencyProbabilities.set(i, (Double)model.getValueAt(i, 1));
                }
                super.btnOkActionPerformed();
            }
        }, "South");
        this.setTitle("Adjust Frequency Scheduling");
        JDialog.setDefaultLookAndFeelDecorated(true);
        this.pack();
        this.setLocationRelativeTo(MainWindow.getInstance());
    }

    public List<Double> getFrequencyProbabilities() {
        return this.frequencyProbabilities;
    }
}

