/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.systems.ofdma;

import org.seamcat.model.functions.BitRateMapping;
import org.seamcat.model.generic.Defaults;
import org.seamcat.model.plugin.Config;

public interface OFDMAGeneralSettings {
    public static final int maxSubcarriersBs = 51;
    public static final int maxSubcarriersMs = 17;
    public static final double handoverMargin = 3.1;
    public static final double minimumCouplingLoss = 70.0;
    public static final double bandwidth = 10.0;
    public static final double receiverNoiseFigure = 8.0;
    public static final double bandwidthResourceBlock = 180.0;
    public static final BitRateMapping bitRateMapping = Defaults.defaultOFDMABitRateMapping();

    @Config(order=1, name="Max. RBs per BS", toolTip="Maximum resource blocks per base station")
    public int maxSubcarriersBs();

    @Config(order=2, name="Number of RBs per MS", toolTip="Number of resource blocks per mobile station")
    public int maxSubcarriersMs();

    @Config(order=3, name="Handover margin", unit="dB")
    public double handoverMargin();

    @Config(order=4, name="Minimum coupling loss", unit="dB")
    public double minimumCouplingLoss();

    @Config(order=5, name="System bandwidth", unit="MHz")
    public double bandwidth();

    @Config(order=6, name="Receiver noise figure", unit="dB")
    public double receiverNoiseFigure();

    @Config(order=7, name="Bandwidth of a RB", unit="kHz", toolTip="Bandwidth of a resource block")
    public double bandwidthResourceBlock();

    @Config(order=8, name="Bitrate mapping", yAxis="Bit rate (bps/Hz)", xAxis="SINR (dB)")
    public BitRateMapping bitRateMapping();
}

