/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.systems.ofdma;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import javax.swing.JPanel;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.plugin.OptionalValue;
import org.seamcat.model.plugin.eventprocessing.LongTask;
import org.seamcat.model.plugin.system.ContexedSystemPlugin;
import org.seamcat.model.plugin.system.CustomPanelBuilder;
import org.seamcat.model.plugin.system.ModelEditor;
import org.seamcat.model.plugin.system.PanelModelEditor;
import org.seamcat.model.systems.ofdma.OFDMAUpLinkGeneralTab;
import org.seamcat.model.systems.ofdma.OFDMAUpLinkUI;
import org.seamcat.model.systems.ofdma.SystemModelOFDMAUpLink;
import org.seamcat.presentation.MainWindow;
import org.seamcat.presentation.display.VectorDialog;
import org.seamcat.presentation.genericgui.LongTaskSwingExecutor;
import org.seamcat.presentation.genericgui.item.CalculatedValueItem;
import org.seamcat.presentation.genericgui.panelbuilder.GenericPanelEditor;
import org.seamcat.simulation.hybrid.HybridOFDMAUpLinkPlugin;
import org.seamcat.simulation.result.ContextImpl;
import org.seamcat.simulation.result.ResultsImpl;

public class OFDMAUpLinkCustomBuilder
implements CustomPanelBuilder<OFDMAUpLinkUI, SystemModelOFDMAUpLink> {
    private static final DecimalFormat df = new DecimalFormat("#.###");
    private double[] values;

    @Override
    public PanelModelEditor<OFDMAUpLinkUI> build(OFDMAUpLinkUI model, final ModelEditor<SystemModelOFDMAUpLink> modelEditor) {
        final GenericPanelEditor<OFDMAUpLinkUI> editor = new GenericPanelEditor<OFDMAUpLinkUI>(MainWindow.getInstance(), OFDMAUpLinkUI.class, model);
        final CalculatedValueItem item = editor.getCalculatedValues().get(0);
        item.setPreviewText("CDF");
        item.getPreviewButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OFDMAUpLinkCustomBuilder.this.showCDF();
            }
        });
        item.getEvaluateButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LongTaskSwingExecutor.execute(new LongTask<Double>(){

                    @Override
                    public Double process() throws Exception {
                        SystemModelOFDMAUpLink sys = (SystemModelOFDMAUpLink)modelEditor.getModel();
                        SystemModelOFDMAUpLink prototype = Factory.prototype(SystemModelOFDMAUpLink.class, sys);
                        OFDMAUpLinkGeneralTab tab = Factory.prototype(OFDMAUpLinkGeneralTab.class, sys.generalSettings());
                        OFDMAUpLinkUI up = Factory.prototype(OFDMAUpLinkUI.class, sys.generalSettings().ofdmaUpLink());
                        Factory.when(up.percentile()).thenReturn(Factory.results().optional(false, 0.0));
                        Factory.when(tab.ofdmaUpLink()).thenReturn(Factory.build(up));
                        Factory.when(prototype.generalSettings()).thenReturn(Factory.build(tab));
                        HybridOFDMAUpLinkPlugin plugin = new HybridOFDMAUpLinkPlugin();
                        plugin.setUI(Factory.build(prototype));
                        ContextImpl context = new ContextImpl();
                        ContexedSystemPlugin cSP = new ContexedSystemPlugin(plugin, context, null);
                        cSP.setFrequency(plugin.getUI().general().frequency());
                        context.setSystemPlugin(cSP);
                        plugin.prepareSimulation(null);
                        ResultsImpl pre = new ResultsImpl("seamcatResult", "PreSimulation");
                        plugin.preSimulation(context, pre);
                        OFDMAUpLinkCustomBuilder.access$102(OFDMAUpLinkCustomBuilder.this, plugin.getCalculatedCLValues(context));
                        double couplingLossPercentile = plugin.getCouplingLossPercentile(context);
                        item.setResult(df.format(couplingLossPercentile));
                        item.showPreview();
                        return couplingLossPercentile;
                    }

                    @Override
                    public void done(Double result) {
                        OFDMAUpLinkUI prototype = Factory.prototype(OFDMAUpLinkUI.class, ((SystemModelOFDMAUpLink)modelEditor.getModel()).generalSettings().ofdmaUpLink());
                        OptionalValue<Double> current = ((SystemModelOFDMAUpLink)modelEditor.getModel()).generalSettings().ofdmaUpLink().percentile();
                        Factory.when(prototype.percentile()).thenReturn(Factory.results().optional(current.isRelevant(), (double)Math.round(result * 1000.0) / 1000.0));
                        editor.setModel(Factory.build(prototype));
                    }
                });
            }
        });
        return new PanelModelEditor<OFDMAUpLinkUI>(){

            @Override
            public JPanel getPanel() {
                return editor;
            }

            @Override
            public OFDMAUpLinkUI getModel() {
                return (OFDMAUpLinkUI)editor.getModel();
            }
        };
    }

    private void showCDF() {
        if (this.values == null) {
            return;
        }
        new VectorDialog(this.values, "Sorted samples of the coupling loss", "dB", "samples");
    }

    static /* synthetic */ double[] access$102(OFDMAUpLinkCustomBuilder x0, double[] x1) {
        x0.values = x1;
        return x1;
    }
}

