/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.systems.ofdmadownlink;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.seamcat.model.RadioSystem;
import org.seamcat.model.Scenario;
import org.seamcat.model.distributions.Distribution;
import org.seamcat.model.distributions.UniformDistribution;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.functions.BitRateMapping;
import org.seamcat.model.functions.Bounds;
import org.seamcat.model.functions.Function;
import org.seamcat.model.functions.VectorSpace;
import org.seamcat.model.generic.PathLossCorrelationUI;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.model.plugin.system.ConsistencyCheckContext;
import org.seamcat.model.plugin.system.Context;
import org.seamcat.model.plugin.system.CorrelationMode;
import org.seamcat.model.plugin.system.SimulationInstance;
import org.seamcat.model.plugin.system.SystemPlugin;
import org.seamcat.model.plugin.system.SystemSpaces;
import org.seamcat.model.plugin.system.optional.CorrelationDefinitions;
import org.seamcat.model.plugin.system.optional.InterferenceNames;
import org.seamcat.model.simulation.consistency.Validator;
import org.seamcat.model.simulation.result.UniqueValueDef;
import org.seamcat.model.simulation.result.VectorDef;
import org.seamcat.model.simulation.result.Victim;
import org.seamcat.model.simulation.result.VictimResultCollector;
import org.seamcat.model.systems.UIToModelConverter;
import org.seamcat.model.systems.cellulargrid.HexagonCells;
import org.seamcat.model.systems.ofdma.ReceiverSettings;
import org.seamcat.model.systems.ofdmadownlink.simulation.SimulationImpl;
import org.seamcat.model.systems.ofdmadownlink.simulation.VictimImpl;
import org.seamcat.model.systems.ofdmadownlink.ui.GeneralSettings;
import org.seamcat.model.systems.ofdmadownlink.ui.SystemModelOFDMADownLink;
import org.seamcat.model.systems.ofdmadownlink.ui.TransmitterUI;
import org.seamcat.model.types.AntennaGain;
import org.seamcat.model.types.Receiver;
import org.seamcat.model.types.Transmitter;
import org.seamcat.model.types.Unit;
import org.seamcat.model.types.result.DoubleResultType;
import org.seamcat.model.types.result.Results;
import org.seamcat.plugin.AntennaGainConfiguration;
import org.seamcat.simulation.cellular.CellularCalculations;
import org.seamcat.simulation.cellular.PathLossCorrelation;
import org.seamcat.simulation.hybrid.HybridSystemPlugin;

public class OFDMADownLinkSystemPlugin
implements SystemPlugin<SystemModelOFDMADownLink>,
CorrelationDefinitions,
InterferenceNames {
    public static final UniqueValueDef SIMULATION_FREQUENCY = Factory.results().single("Frequency", "MHz");
    public static final UniqueValueDef THERMAL_NOISE = Factory.results().single("Thermal noise", "dBm");
    public static final UniqueValueDef SUB_CARRIER_RATIO = Factory.results().single("Sub carrier ratio", "Ratio");
    public static final UniqueValueDef THERMAL_NOISE_UE = Factory.results().single("Thermal noise UE", "dBm");
    public static final UniqueValueDef AVGBitrateLossRefCell = Factory.results().single("Average bitrate loss (ref. cell)", "%");
    public static final UniqueValueDef AVGBitrateLossSystem = Factory.results().single("Average bitrate loss (system)", "%");
    public static final VectorDef AVGAchievedBitRateSystem = Factory.results().value("Avg Non Interfered Bitrate, system", "kbps");
    public static final VectorDef AchievedBitRateRefCell = Factory.results().value("Non Interfered Bitrate, ref cell", Unit.kbps.name());
    public static final VectorDef AVGInterferedBitRateSystem = Factory.results().value("Avg Interfered Bitrate, system", "kbps");
    public static final VectorDef InterferedBitRateRefCell = Factory.results().value("Interfered Bitrate, ref. cell", "kbps");
    public static final VectorDef SINR_SYSTEM = Factory.results().value("SINR, Victim system", "dB");
    public static final VectorDef SINR_REFCELL = Factory.results().value("SINR, Reference cell", "dB");
    private SystemModelOFDMADownLink ui;
    private RadioSystem system;
    private PathLossCorrelation pl;
    private double mcl;
    private HybridSystemPlugin.SectorSetup sector;
    private boolean wrap;
    private double cellRadius;
    private HybridSystemPlugin.SystemLayout layout;
    private BitRateMapping bitRateMapping;
    private double txPower;
    private double rbBandwidth;
    private double bandwidth;
    private double rnFigure;
    private double hoMargin;
    private Distribution msGain;
    private Distribution msHeight;
    private int maxMs;
    private int maxBs;
    private Distribution bsTilt;
    private int refSector;
    private int refCellId;
    private double interCellDistance;
    private AntennaGainConfiguration[] antennas;
    private HybridSystemPlugin.TierSetup tierSetup;

    @Override
    public void consistencyCheck(ConsistencyCheckContext context, Scenario scenario, Validator validator) {
    }

    @Override
    public Bounds getSystemCoverage() {
        double min = 0.0;
        boolean isNot3GPP = this.getSectorSetup() == HybridSystemPlugin.SectorSetup.TriSector3GPP2 || this.getSectorSetup().getSectors() == 1;
        double cellRadius = this.getCellRadius();
        if (isNot3GPP) {
            cellRadius /= Math.sqrt(3.0);
        }
        int numberOfTiers = this.getTierSetup().ordinal();
        double networkRadius = 3.0 * cellRadius * (double)numberOfTiers + 2.0 * cellRadius;
        if (this.isUsingWrapAround()) {
            networkRadius *= 2.0;
        }
        VectorSpace network = VectorSpace.ZERO.addCircle(new Bounds(0.0, networkRadius, true));
        double max = network.getCoverage().getMax();
        return new Bounds(min, max, true);
    }

    @Override
    public VectorSpace getInterferenceLinkSystemCoverage(boolean victim, ConsistencyCheckContext context) {
        boolean isNot3GPP = this.getSectorSetup() == HybridSystemPlugin.SectorSetup.TriSector3GPP2 || this.getSectorSetup().getSectors() == 1;
        double cellRadius = this.getCellRadius();
        if (isNot3GPP) {
            cellRadius /= Math.sqrt(3.0);
        }
        int numberOfTiers = this.getTierSetup().ordinal();
        double networkRadius = 3.0 * cellRadius * (double)numberOfTiers + 2.0 * cellRadius;
        VectorSpace range = VectorSpace.ZERO;
        return range.addCircle(new Bounds(0.0, networkRadius, true));
    }

    @Override
    public void setUI(SystemModelOFDMADownLink ui) {
        this.ui = ui;
    }

    @Override
    public SystemModelOFDMADownLink getUI() {
        return this.ui;
    }

    @Override
    public void prepareSimulation(Scenario scenario) {
        this.sector = this.ui.positioning().position().sectorType();
        this.antennas = CellularCalculations.createSectorAntennas(this.sector, (AntennaGainConfiguration)this.ui.positioning().baseStation().antennaGain());
        int tiers = this.ui.positioning().position().tiers();
        this.tierSetup = tiers == 0 ? HybridSystemPlugin.TierSetup.SingleCell : (tiers == 1 ? HybridSystemPlugin.TierSetup.OneTier : HybridSystemPlugin.TierSetup.TwoTiers);
        this.cellRadius = this.ui.positioning().position().cellRadius();
        this.interCellDistance = 0.0;
        this.interCellDistance = this.sector != HybridSystemPlugin.SectorSetup.TriSector3GPP ? this.cellRadius * Mathematics.SQRT3 : this.cellRadius * 3.0;
        GeneralSettings gen = this.ui.generalSettings().generalSettings();
        ReceiverSettings rx = this.ui.generalSettings().receiverSettings();
        Receiver receiver = UIToModelConverter.getDmaReceiver(rx.standardDesensitisation(), rx.targetINR(), gen.receiverNoiseFigure(), rx.blockingMask(), gen.bandwidthResourceBlock() * (double)gen.maxSubcarriersMs() / 1000.0, Factory.results().convert(this.ui.generalSettings().localEnvironments().receiverEnvironments()), Factory.antennaGainFactory().getPeakGainAntenna(this.ui.positioning().mobile().antennaGain().trial()), this.ui.positioning().mobile().antennaHeight());
        TransmitterUI tx = this.ui.generalSettings().transmitterSettings();
        Transmitter transmitter = new Transmitter(tx.emissionMask(), tx.emissionFloor().getValue(), tx.emissionFloor().isRelevant(), gen.bandwidthResourceBlock() * (double)gen.maxSubcarriersBs() / 1000.0, null, Factory.results().convert(this.ui.generalSettings().localEnvironments().transmitterEnvironments()), this.ui.positioning().baseStation().antennaGain(), this.ui.positioning().baseStation().antennaHeight(), 0.0, false);
        PathLossCorrelationUI plUI = this.ui.generalSettings().pathLossCorrelation();
        this.system = new RadioSystem(receiver, transmitter, this.ui.generalSettings().propagationModel());
        this.pl = new PathLossCorrelation(plUI.usePathLossCorrelation(), plUI.pathLossVariance(), plUI.correlationFactor());
        this.mcl = gen.minimumCouplingLoss();
        this.wrap = this.ui.positioning().position().generateWrapAround();
        this.layout = this.ui.positioning().position().layout();
        this.bitRateMapping = gen.bitRateMapping();
        this.txPower = tx.bsMaximumTransmitPower();
        this.rbBandwidth = gen.bandwidthResourceBlock();
        this.bandwidth = gen.bandwidth();
        this.rnFigure = gen.receiverNoiseFigure();
        this.hoMargin = gen.handoverMargin();
        this.msGain = this.ui.positioning().mobile().antennaGain();
        this.msHeight = this.ui.positioning().mobile().antennaHeight();
        this.maxMs = gen.maxSubcarriersMs();
        this.maxBs = gen.maxSubcarriersBs();
        this.bsTilt = this.ui.positioning().baseStation().antennaTilt();
        this.refSector = this.ui.positioning().position().referenceSector();
        this.refCellId = this.ui.positioning().position().referenceCellId();
    }

    @Override
    public RadioSystem getSystem(Context context) {
        return this.system;
    }

    @Override
    public void preSimulation(Context context, Results results) {
        double frequency = context.getFrequency().trial();
        results.getSingleValueTypes().add(new DoubleResultType(SIMULATION_FREQUENCY, frequency));
        double noise = CellularCalculations.calculateThermalNoise(this.getSystemBandwidth(), this.getReceiverNoiseFigure());
        results.getSingleValueTypes().add(new DoubleResultType(THERMAL_NOISE, noise));
        noise = CellularCalculations.calculateThermalNoise((double)this.getMaxRBsPrMS() * this.getBandwidthOfAnRB() * 0.001, this.getReceiverNoiseFigure());
        results.getSingleValueTypes().add(new DoubleResultType(THERMAL_NOISE_UE, noise));
        double ratio = (double)this.getMaxRBsPrMS() / (double)this.getMaxRBsPrBS();
        results.getSingleValueTypes().add(new DoubleResultType(SUB_CARRIER_RATIO, ratio));
        double bw = this.system.getTransmitter().getBandwidth();
        UniformDistribution freq = Factory.distributionFactory().getUniformDistribution(frequency - bw / 2.0, frequency + bw / 2.0);
        context.getSystemPlugin().setFrequency(freq);
    }

    @Override
    public void postSimulation(Context context, Results results) {
        if (context.isVictim()) {
            double avgBitRateLossRefCell = Mathematics.calculateAvgPercentage(results.findVector(AchievedBitRateRefCell), results.findVector(InterferedBitRateRefCell));
            results.getSingleValueTypes().add(new DoubleResultType(AVGBitrateLossRefCell, avgBitRateLossRefCell));
            double avgBitRateLossSystem = Mathematics.calculateAvgPercentage(results.findVector(AVGAchievedBitRateSystem), results.findVector(AVGInterferedBitRateSystem));
            results.getSingleValueTypes().add(new DoubleResultType(AVGBitrateLossSystem, avgBitRateLossSystem));
        }
    }

    @Override
    public SimulationInstance simulationInstance(Context context, SystemSpaces shapes) {
        return new SimulationImpl(this);
    }

    @Override
    public List<String> getVictimCorrelationPoints() {
        return Collections.singletonList("Victim BS ref.cell");
    }

    @Override
    public Point2D getVictimPosition(VictimResultCollector collector, String correlationPoint) {
        for (Victim victim : collector.getVictims()) {
            if (!(victim instanceof VictimImpl) || !((VictimImpl)victim).isConnectedToReferenceCell()) continue;
            return victim.getLinkResult().txAntenna().getPosition();
        }
        return Point2D.ORIGIN;
    }

    @Override
    public List<String> getInterfererTargetPointNames() {
        return Collections.singletonList("Interfering BS ref.cell");
    }

    @Override
    public List<CorrelationMode> getCorrelationModes() {
        ArrayList<CorrelationMode> modes = new ArrayList<CorrelationMode>();
        modes.add(Factory.correlationModes().getNone());
        modes.add(Factory.correlationModes().getCorrelated());
        return modes;
    }

    @Override
    public boolean allowCoLocation() {
        return false;
    }

    @Override
    public String title() {
        return "Average over the UEs in reference cell";
    }

    @Override
    public String information() {
        return "<html>Sum of contributions of all external interferer(s) perceived by each UE in the reference cell, <br>averaged over the number of UEs in the reference cell.</html>";
    }

    @Override
    public String unwantedName() {
        return "iRSS Unwanted (external Interference)";
    }

    @Override
    public String blockingName() {
        return "iRSS Blocking (external Interference)";
    }

    public double getMinimumCouplingLoss() {
        return this.mcl;
    }

    public HybridSystemPlugin.SectorSetup getSectorSetup() {
        return this.sector;
    }

    public double getInterCellDistance() {
        return this.interCellDistance;
    }

    public boolean isUsingWrapAround() {
        return this.wrap;
    }

    public AntennaGain[] getAntennas() {
        return this.antennas;
    }

    public HybridSystemPlugin.TierSetup getTierSetup() {
        return this.tierSetup;
    }

    public double getCellRadius() {
        return this.cellRadius;
    }

    public HybridSystemPlugin.SystemLayout getSystemLayout() {
        return this.layout;
    }

    public int getIndexOfReferenceCell() {
        return this.refCellId;
    }

    public int getReferenceSector() {
        return this.refSector;
    }

    public Distribution getBaseStationTilt() {
        return this.bsTilt;
    }

    public int getMaxRBsPrBS() {
        return this.maxBs;
    }

    public int getMaxRBsPrMS() {
        return this.maxMs;
    }

    public Distribution getMobileStationHeight() {
        return this.msHeight;
    }

    public Distribution getMobileStationGain() {
        return this.msGain;
    }

    public PathLossCorrelation getPathLossCorrelation() {
        return this.pl;
    }

    public double getHandoverMargin() {
        return this.hoMargin;
    }

    public double getReceiverNoiseFigure() {
        return this.rnFigure;
    }

    public double getSystemBandwidth() {
        return this.bandwidth;
    }

    public double getBandwidthOfAnRB() {
        return this.rbBandwidth;
    }

    public double getBSMaxTransmitPower() {
        return this.txPower;
    }

    public Function getBitRateMapping() {
        return this.bitRateMapping.getFunction();
    }

    public double calculateFrequency(int resourceBlockNumber, double systemFrequency) {
        double systemBandwidth = this.getSystemBandwidth();
        double resourceBlockBandwidth = this.getBandwidthOfAnRB() * 0.001;
        double diff = systemBandwidth - (double)this.getMaxRBsPrBS() * resourceBlockBandwidth;
        return systemFrequency - systemBandwidth / 2.0 + diff / 2.0 + (double)this.getMaxRBsPrMS() * resourceBlockBandwidth / 2.0 * (double)(resourceBlockNumber * 2 + 1);
    }

    @Override
    public SystemSpaces generateSystemSpaces(SystemSpaces enclosing) {
        return HexagonCells.generate(false, this.getCellRadius(), this.getTierSetup(), this.getSectorSetup(), this.getIndexOfReferenceCell());
    }
}

