/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.systems.ofdmadownlink.simulation;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.seamcat.model.factory.RandomAccessor;
import org.seamcat.model.factory.SeamcatRandom;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.model.simulation.result.AntennaResult;
import org.seamcat.model.systems.ofdmadownlink.OFDMADownLinkSystemPlugin;
import org.seamcat.model.systems.ofdmadownlink.simulation.Link;
import org.seamcat.model.types.AntennaGain;
import org.seamcat.simulation.cellular.GridPositionCalculator;

class BaseStation {
    protected static final Logger LOG = Logger.getLogger(BaseStation.class);
    private List<Link> candidateConnections;
    private List<Link> activeConnections;
    private OFDMADownLinkSystemPlugin system;
    private Point2D position;
    private Point2D[] geometry = new Point2D[6];
    private double antennaHeight;
    private double antennaTilt;
    private double frequency;
    private int sectorId;
    private int cellId;
    private int subCarriersInUse = 0;
    private final SeamcatRandom random;
    private final boolean referenceCell;

    public double getFrequency() {
        return this.frequency;
    }

    public BaseStation(double frequency, Point2D position, OFDMADownLinkSystemPlugin system, int _cellid, double antHeight, double antennaTilt, int sectorId, boolean referenceCell) {
        this.system = system;
        this.frequency = frequency;
        this.position = position;
        GridPositionCalculator.calculateHexagon(position, system.getCellRadius(), this.geometry);
        this.antennaHeight = antHeight;
        this.antennaTilt = antennaTilt;
        this.sectorId = sectorId;
        this.cellId = _cellid;
        this.candidateConnections = new ArrayList<Link>();
        this.activeConnections = new ArrayList<Link>();
        this.random = RandomAccessor.getRandom();
        this.referenceCell = referenceCell;
    }

    public int getCellid() {
        return this.cellId;
    }

    public Point2D getPosition() {
        return this.position;
    }

    void setAntennaProperties(AntennaResult ant) {
        ant.setHeight(this.antennaHeight);
        ant.setTilt(this.antennaTilt);
        ant.setPosition(this.position);
    }

    public AntennaGain getAntennaGain() {
        AntennaGain[] antennas = this.system.getAntennas();
        if (antennas.length == 1) {
            return antennas[0];
        }
        return antennas[this.sectorId];
    }

    public void addCandidate(Link candidate) {
        this.candidateConnections.add(candidate);
    }

    public void removeCandidate(Link link) {
        this.candidateConnections.remove(link);
    }

    public boolean inside(Point2D point) {
        return GridPositionCalculator.isInside(point, this.geometry);
    }

    public boolean initialConnect(List<Link> activeLinks) {
        boolean candidatesAvailable;
        int sum = this.getSubCarriersInUse();
        double loadFactor = Math.rint(sum) / Math.rint(this.system.getMaxRBsPrBS());
        boolean underLoaded = loadFactor < 1.0;
        boolean bl = candidatesAvailable = this.candidateConnections.size() > 0;
        while (underLoaded && candidatesAvailable) {
            Link candidate = this.fetchRandomCandidate();
            int temp = this.system.getMaxRBsPrMS();
            if (sum + temp <= this.system.getMaxRBsPrBS()) {
                sum += temp;
                double ueFrequency = this.system.calculateFrequency(this.activeConnections.size(), this.frequency);
                this.activeConnections.add(candidate);
                candidate.getUserTerminal().setServingLink(candidate, ueFrequency);
                activeLinks.add(candidate);
            }
            candidatesAvailable = this.candidateConnections.size() > 0;
            loadFactor = Math.rint(sum) / Math.rint(this.system.getMaxRBsPrBS());
            underLoaded = loadFactor < 1.0 && this.system.getMaxRBsPrMS() <= this.system.getMaxRBsPrBS() - sum;
        }
        this.setSubCarriersInUse(sum);
        return !underLoaded;
    }

    private Link fetchRandomCandidate() {
        int i = this.random.nextInt(this.candidateConnections.size());
        return this.candidateConnections.remove(i);
    }

    public int getSubCarriersInUse() {
        return this.subCarriersInUse;
    }

    public void setSubCarriersInUse(int subCarriersInUse) {
        this.subCarriersInUse = subCarriersInUse;
    }

    public double calculateCurrentTransmitPower_Watt() {
        return this.getMaximumTransmitPower_Watt() * (double)this.getSubCarriersInUse() / (double)this.system.getMaxRBsPrBS();
    }

    public double getMaximumTransmitPower_Watt() {
        return Mathematics.fromdBm2Watt(this.system.getBSMaxTransmitPower());
    }

    public boolean isReferenceCell() {
        return this.referenceCell;
    }
}

