/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.systems.ofdmadownlink.simulation;

import java.util.Arrays;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.simulation.result.AntennaResult;
import org.seamcat.model.systems.ofdmadownlink.OFDMADownLinkSystemPlugin;
import org.seamcat.model.systems.ofdmadownlink.simulation.BaseStation;
import org.seamcat.model.systems.ofdmadownlink.simulation.Link;
import org.seamcat.simulation.cellular.PathLossCorrelation;

class MobileStation {
    private Link[] links;
    private Link servingLink;
    private OFDMADownLinkSystemPlugin system;
    private double antennaHeight;
    private double frequency;
    private final int userid;
    private Point2D position;
    private double antennaGain;

    public double getFrequency() {
        return this.frequency;
    }

    public MobileStation(double frequency, OFDMADownLinkSystemPlugin system, int _userid, double antGain, double antHeight) {
        this.frequency = frequency;
        this.userid = _userid;
        this.position = Point2D.ORIGIN;
        this.antennaHeight = antHeight;
        this.antennaGain = antGain;
        this.system = system;
    }

    public Link[] getAllLinks() {
        return this.links;
    }

    public Link getServingLink() {
        return this.servingLink;
    }

    public void setServingLink(Link servingLink, double frequency) {
        this.servingLink = servingLink;
        this.frequency = frequency;
        servingLink.getLinkResult().setFrequency(frequency);
        for (Link link : this.links) {
            if (link == servingLink) continue;
            link.getBaseStation().removeCandidate(link);
        }
    }

    private void sortLinks() {
        Arrays.sort(this.links, Link.comparator);
    }

    public Point2D getPosition() {
        return this.position;
    }

    public double getAntennaGain() {
        return this.antennaGain;
    }

    void setAntennaProperties(AntennaResult ant) {
        ant.setHeight(this.antennaHeight);
        ant.setTilt(0.0);
        ant.setPosition(this.position);
    }

    public void setPosition(Point2D position) {
        this.position = position;
    }

    public void linkToBSAndAddToCandidateList(BaseStation[][] cells) {
        this.links = new Link[cells.length * cells[0].length];
        int linkid = 0;
        PathLossCorrelation correlation = this.system.getPathLossCorrelation();
        double correlationInterSite = correlation.getCorrelationFactor();
        double a_inter = Math.sqrt(Math.abs(correlationInterSite));
        double b_inter = Math.sqrt(1.0 - Math.abs(correlationInterSite));
        double x = correlation.trial();
        for (int i = 0; i < cells.length; ++i) {
            int j = 0;
            while (j < cells[i].length) {
                double y = correlation.trial();
                double pathLossOffset = 0.0;
                if (correlation.isUsingPathLossCorrelation()) {
                    pathLossOffset = a_inter * x + b_inter * y;
                }
                this.links[linkid] = new Link(this.system, cells[i][j], this, this.frequency, pathLossOffset);
                ++j;
                ++linkid;
            }
        }
        this.sortLinks();
        this.links[0].getBaseStation().addCandidate(this.links[0]);
        if (this.links.length > 1) {
            int index = 1;
            double lowestLink = this.links[0].getEffectivePathloss();
            double nextLink = this.links[index].getEffectivePathloss();
            while (lowestLink + this.system.getHandoverMargin() > nextLink) {
                this.links[index].getBaseStation().addCandidate(this.links[index]);
                if (++index < this.links.length) {
                    nextLink = this.links[index].getEffectivePathloss();
                    continue;
                }
                return;
            }
        }
    }

    public int getUserid() {
        return this.userid;
    }
}

