/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.systems.ofdmauplink.simulation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.seamcat.model.RadioSystem;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.systems.ofdmauplink.OFDMAUpLinkSystemPlugin;
import org.seamcat.model.systems.ofdmauplink.simulation.Link;
import org.seamcat.model.systems.ofdmauplink.simulation.OFDMAUpLinkSimulation;

public class CouplingLossEstimator {
    public static double estimate(OFDMAUpLinkSystemPlugin plugin, RadioSystem system, double frequency) {
        ArrayList<Double> effectivePathLoss = new ArrayList<Double>();
        return CouplingLossEstimator.estimate(plugin, system, frequency, effectivePathLoss);
    }

    public static double estimate(OFDMAUpLinkSystemPlugin plugin, RadioSystem system, double frequency, List<Double> effectivePathLoss) {
        while (effectivePathLoss.size() < 1000) {
            OFDMAUpLinkSimulation simulation = new OFDMAUpLinkSimulation(plugin, system);
            List<Link> links = simulation.positionAndConnect(Point2D.ORIGIN, frequency);
            for (Link active : links) {
                effectivePathLoss.add(active.getEffectivePathloss());
            }
        }
        Collections.sort(effectivePathLoss);
        return CouplingLossEstimator.calculatePowerControlledPathlossLimit(plugin.getPowerScalingThreshold(), effectivePathLoss);
    }

    private static double calculatePowerControlledPathlossLimit(double threshold, List<Double> effectivePathLoss) {
        int floor = (int)Math.floor(threshold / (1.0 / (double)effectivePathLoss.size()));
        return effectivePathLoss.get(floor);
    }
}

