/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.systems.ofdmauplink.simulation;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.seamcat.model.RadioSystem;
import org.seamcat.model.distributions.Distribution;
import org.seamcat.model.distributions.GaussianDistribution;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.generic.PathLossCorrelationUI;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.model.plugin.system.SimulationInstance;
import org.seamcat.model.simulation.result.EventResult;
import org.seamcat.model.simulation.result.Interferer;
import org.seamcat.model.simulation.result.InterfererResultCollector;
import org.seamcat.model.simulation.result.LinkResult;
import org.seamcat.model.simulation.result.VectorDef;
import org.seamcat.model.simulation.result.Victim;
import org.seamcat.model.simulation.result.VictimResultCollector;
import org.seamcat.model.systems.ofdmadownlink.OFDMADownLinkSystemPlugin;
import org.seamcat.model.systems.ofdmauplink.OFDMAUpLinkSystemPlugin;
import org.seamcat.model.systems.ofdmauplink.simulation.BaseStation;
import org.seamcat.model.systems.ofdmauplink.simulation.InterfererImpl;
import org.seamcat.model.systems.ofdmauplink.simulation.Link;
import org.seamcat.model.systems.ofdmauplink.simulation.MobileStation;
import org.seamcat.model.systems.ofdmauplink.simulation.VictimImpl;
import org.seamcat.model.types.InterferenceLink;
import org.seamcat.model.types.result.Results;
import org.seamcat.simulation.cellular.GridPositionCalculator;
import org.seamcat.simulation.cellular.OFDMADownLinkVictimSystemSimulation;
import org.seamcat.simulation.hybrid.HybridSystemPlugin;

public class OFDMAUpLinkSimulation
implements SimulationInstance {
    private Distribution userAngle = Factory.distributionFactory().getUniformPolarAngleDistribution(360.0);
    private Distribution userLocation = Factory.distributionFactory().getUniformPolarDistanceDistribution(1.0);
    private OFDMAUpLinkSystemPlugin plugin;
    private RadioSystem system;
    private BaseStation[][] cells;
    private int numberOfBs;

    public OFDMAUpLinkSimulation(OFDMAUpLinkSystemPlugin plugin, RadioSystem system) {
        this.plugin = plugin;
        this.system = system;
    }

    @Override
    public void victimSimulation(VictimResultCollector collector) {
        Results pre = collector.getPreSimulationResults();
        double frequency = pre.findDoubleValue(OFDMADownLinkSystemPlugin.SIMULATION_FREQUENCY);
        double couplingLossPercentile = pre.findDoubleValue(OFDMAUpLinkSystemPlugin.COUPLING_LOSS_PERCENTILE);
        double thermalNoiseUE = pre.findDoubleValue(OFDMADownLinkSystemPlugin.THERMAL_NOISE_UE);
        List<Link> activeConnections = this.scalePower(this.positionAndConnect(Point2D.ORIGIN, frequency), couplingLossPercentile, thermalNoiseUE);
        double bitrateAll = 0.0;
        double bitrateRefCell = 0.0;
        for (Link active : activeConnections) {
            VictimImpl victimImpl = new VictimImpl(active);
            collector.add(victimImpl);
            MobileStation ue = active.getUserTerminal();
            ue.calculateAchievedBitrate();
            bitrateAll += ue.getAchievedBitrate();
            if (!victimImpl.isConnectedToReferenceCell()) continue;
            bitrateRefCell += ue.getAchievedBitrate();
        }
        collector.add(OFDMAUpLinkSystemPlugin.initialVictimOutage, bitrateRefCell);
        collector.add(OFDMAUpLinkSystemPlugin.AVGAchievedBitRateSystem, bitrateAll / (double)this.numberOfBS());
        LinkedHashMap<VectorDef, List<Double>> vectors = new LinkedHashMap<VectorDef, List<Double>>();
        for (Victim victim : collector.getVictims()) {
            VictimImpl v = (VictimImpl)victim;
            this.handle(vectors, v);
        }
        for (Map.Entry entry : vectors.entrySet()) {
            collector.add((VectorDef)entry.getKey(), (List)entry.getValue());
        }
    }

    private void handle(Map<VectorDef, List<Double>> vectors, VictimImpl victim) {
        this.append(vectors, OFDMADownLinkVictimSystemSimulation.FREQUENCY_ALL, victim.getUEFrequency());
        this.append(vectors, OFDMADownLinkVictimSystemSimulation.BIT_RATE_ACHIEVED_ALL, victim.getNonInterferedAchievedBitrate());
        this.append(vectors, OFDMADownLinkVictimSystemSimulation.RECEIVED_POWER_ALL, victim.getReceivePower());
        this.append(vectors, OFDMADownLinkVictimSystemSimulation.SINR_ACHIEVED_ALL, victim.getNonInterferedAchievedSINR());
        this.append(vectors, OFDMADownLinkVictimSystemSimulation.PATH_LOSS_ALL, victim.getLinkResult().getTxRxPathLoss());
        this.append(vectors, OFDMADownLinkVictimSystemSimulation.EFFECTIVE_PATH_LOSS_ALL, victim.getLinkResult().getEffectiveTxRxPathLoss());
        this.append(vectors, OFDMADownLinkVictimSystemSimulation.CURRENT_TRANSMIT_POWER_ALL, victim.getCurrentTransmitPower());
        if (victim.isConnectedToReferenceCell()) {
            this.append(vectors, OFDMADownLinkVictimSystemSimulation.FREQUENCY, victim.getUEFrequency());
            this.append(vectors, OFDMADownLinkVictimSystemSimulation.BIT_RATE_ACHIEVED, victim.getNonInterferedAchievedBitrate());
            this.append(vectors, OFDMADownLinkVictimSystemSimulation.RECEIVED_POWER, victim.getReceivePower());
            this.append(vectors, OFDMADownLinkVictimSystemSimulation.SINR_ACHIEVED, victim.getNonInterferedAchievedSINR());
            this.append(vectors, OFDMADownLinkVictimSystemSimulation.PATH_LOSS, victim.getLinkResult().getTxRxPathLoss());
            this.append(vectors, OFDMADownLinkVictimSystemSimulation.EFFECTIVE_PATH_LOSS, victim.getLinkResult().getEffectiveTxRxPathLoss());
            this.append(vectors, OFDMADownLinkVictimSystemSimulation.CURRENT_TRANSMIT_POWER, victim.getCurrentTransmitPower());
        }
    }

    private void append(Map<VectorDef, List<Double>> vectors, VectorDef def, double value) {
        List<Double> values = vectors.get(def);
        if (values == null) {
            values = new ArrayList<Double>();
            vectors.put(def, values);
        }
        values.add(value);
    }

    @Override
    public void interferingSystemSimulation(EventResult eventResult, InterferenceLink link, Point2D position) {
        InterfererResultCollector collector = eventResult.getInterferingSystemResult(link);
        Results pre = collector.getPreSimulationResults();
        double frequency = pre.findDoubleValue(OFDMADownLinkSystemPlugin.SIMULATION_FREQUENCY);
        double couplingLossPercentile = pre.findDoubleValue(OFDMAUpLinkSystemPlugin.COUPLING_LOSS_PERCENTILE);
        double thermalNoiseUE = pre.findDoubleValue(OFDMADownLinkSystemPlugin.THERMAL_NOISE_UE);
        List<Link> activeConnections = this.scalePower(this.positionAndConnect(position, frequency), couplingLossPercentile, thermalNoiseUE);
        for (Link active : activeConnections) {
            double mcl = link.getCorrelationSettings().getMinimumCouplingLoss().trial();
            collector.add(new InterfererImpl(link.linkIndex(), active, mcl));
        }
    }

    @Override
    public void interferingSystemSimulation(EventResult eventResult, InterferenceLink link, Point2D position, LinkResult positionFromCoLocation) {
    }

    @Override
    public void interferedVictimSimulation(EventResult eventResult) {
        for (InterfererResultCollector col : eventResult.getAllInterferingSystemResults()) {
            for (Interferer interferer : col.getInterferingElements()) {
                PathLossCorrelationUI ui = col.getLink().getCorrelationSettings().getCorrelationConfiguration(PathLossCorrelationUI.class);
                if (!ui.usePathLossCorrelation()) continue;
                GaussianDistribution var = Factory.distributionFactory().getGaussianDistribution(0.0, ui.pathLossVariance());
                double x = var.trial();
                double correlationExternalInterferer = ui.correlationFactor();
                double a_ext = Math.sqrt(Math.abs(correlationExternalInterferer));
                double b_ext = Math.sqrt(1.0 - Math.abs(correlationExternalInterferer));
                double y = var.trial();
                double pathloss = interferer.getLinkResult().getTxRxPathLoss();
                interferer.getLinkResult().setTxRxPathLoss(pathloss += a_ext * x + b_ext * y);
            }
        }
        VictimResultCollector vCollector = eventResult.getVictimResult();
        double sinrSum = 0.0;
        double sinrRefCellSum = 0.0;
        int refCellCount = 0;
        int size = vCollector.getVictims().size();
        double refCellBitrate = 0.0;
        double totalBitrate = 0.0;
        for (Victim victim : vCollector.getVictims()) {
            VictimImpl vi = (VictimImpl)victim;
            vi.calculateAchievedSINRWatt();
            double sinr = Mathematics.dB2Linear(vi.getAchievedSINR());
            vi.calculateAchievedBitrate();
            double ach = vi.getAchievedBitrate();
            totalBitrate += ach;
            if (vi.isConnectedToReferenceCell()) {
                sinrRefCellSum += sinr;
                ++refCellCount;
                refCellBitrate += ach;
            }
            sinrSum += sinr;
        }
        double sinrAvg = size == 0 ? 0.0 : sinrSum / (double)size;
        vCollector.add(OFDMAUpLinkSystemPlugin.avgInterferedBitRateSystem, totalBitrate / (double)this.numberOfBS());
        vCollector.add(OFDMAUpLinkSystemPlugin.SINRSystem, Mathematics.linear2dB(sinrAvg));
        double avg = refCellCount == 0 ? 0.0 : sinrRefCellSum / (double)refCellCount;
        vCollector.add(OFDMAUpLinkSystemPlugin.SINRRefCell, Mathematics.linear2dB(avg));
        vCollector.add(OFDMAUpLinkSystemPlugin.interferedBitRateRefCell, refCellBitrate);
    }

    @Override
    public List<Victim> getResultingVictims(VictimResultCollector vCollector) {
        ArrayList<Victim> victims = new ArrayList<Victim>();
        for (Victim victim : vCollector.getVictims()) {
            VictimImpl v = (VictimImpl)victim;
            if (!v.isConnectedToReferenceCell()) continue;
            victims.add(v);
        }
        return victims;
    }

    @Override
    public void postEvent(EventResult eventResult) {
    }

    public List<Link> positionAndConnect(Point2D position, double frequency) {
        this.generateBaseStations(position, frequency);
        return this.positionMSsAndInitialConnectBS(position, frequency);
    }

    private List<Link> scalePower(List<Link> activeLinks, double couplingLossPercentile, double thermalNoiseUE) {
        for (Link activeLink : activeLinks) {
            activeLink.getUserTerminal().scalePower(couplingLossPercentile);
        }
        for (Link activeLink : activeLinks) {
            activeLink.getUserTerminal().calculateSINR(thermalNoiseUE);
        }
        return activeLinks;
    }

    private void generateBaseStations(Point2D systemCenter, double frequency) {
        int cellsPrSite = this.plugin.getSectorSetup().getSectors();
        this.cells = new BaseStation[this.plugin.getTierSetup().getCellSites()][cellsPrSite];
        this.numberOfBs = this.plugin.getTierSetup().getCellSites() * cellsPrSite;
        double d = this.plugin.getInterCellDistance();
        for (int j = 0; j < this.cells.length; ++j) {
            for (int i = 0; i < this.cells[0].length; ++i) {
                Point2D position = this.plugin.getSectorSetup() != HybridSystemPlugin.SectorSetup.TriSector3GPP ? GridPositionCalculator.ppg2(j, systemCenter, d) : GridPositionCalculator.standard(j, systemCenter, d);
                int cellId = i + cellsPrSite * j;
                boolean referenceCell = j == this.plugin.getIndexOfReferenceCell() && i == this.plugin.getReferenceSector();
                this.cells[j][i] = new BaseStation(frequency, position, this.plugin, this.system, cellId, i, referenceCell);
            }
        }
    }

    private int numberOfBS() {
        return this.numberOfBs;
    }

    private List<Link> positionMSsAndInitialConnectBS(Point2D systemPosition, double frequency) {
        ArrayList<Link> activeLinks = new ArrayList<Link>();
        int K = this.plugin.getMaxRBsPrBS() / this.plugin.getMaxRBsPrMS();
        for (int v = 0; v < 10 * K; ++v) {
            this.generateMobileStations(v, systemPosition, frequency);
            boolean systemIsLoaded = true;
            for (BaseStation[] cell : this.cells) {
                for (int i = 0; i < this.cells[0].length; ++i) {
                    BaseStation bs = cell[i];
                    systemIsLoaded = systemIsLoaded && bs.initialConnect(activeLinks);
                }
            }
            if (!systemIsLoaded) continue;
            return activeLinks;
        }
        return activeLinks;
    }

    private void generateMobileStations(int count, Point2D systemPosition, double frequency) {
        int bsCount = this.numberOfBS();
        int K = this.plugin.getNumberOfActiveMsPerBs();
        int offset = K * bsCount * count;
        int stop = K * bsCount;
        for (int i = 0; i < stop; ++i) {
            MobileStation ms = new MobileStation(frequency, this.plugin, this.system, i + offset);
            this.positionUser(ms, systemPosition);
            ms.linkToBSAndAddToCandidateList(this.cells);
        }
    }

    private void positionUser(MobileStation user, Point2D systemPosition) {
        double userAng = this.userAngle.trial();
        boolean singleHexagon = this.plugin.getSectorSetup() != HybridSystemPlugin.SectorSetup.TriSector3GPP;
        double tierOffset = singleHexagon ? 0.5 : 1.0;
        double userDist = ((double)this.plugin.getTierSetup().getTiers() + tierOffset) * this.plugin.getInterCellDistance() * this.userLocation.trial();
        double x = userDist * Mathematics.cosD(userAng);
        double y = userDist * Mathematics.sinD(userAng);
        user.setPosition(systemPosition.add(x, y));
        for (int i = 0; i < this.cells.length; ++i) {
            BaseStation[] cell = this.cells[i];
            Point2D position = user.getPosition();
            if (!(singleHexagon ? cell[0].inside(position) : cell[0].inside(position) || cell[1].inside(position) || cell[2].inside(position))) continue;
            return;
        }
        this.positionUser(user, systemPosition);
    }
}

