/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.systems.ofdmauplink.ui;

import org.seamcat.function.DiscreteFunction;
import org.seamcat.model.RadioSystem;
import org.seamcat.model.Scenario;
import org.seamcat.model.distributions.Distribution;
import org.seamcat.model.functions.Bounds;
import org.seamcat.model.functions.Function;
import org.seamcat.model.functions.MaskFunction;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.model.plugin.OptionalValue;
import org.seamcat.model.scenariocheck.InterferingLinkCheck;
import org.seamcat.model.simulation.consistency.Validator;
import org.seamcat.model.systems.ofdmauplink.OFDMAUpLinkSystemPlugin;
import org.seamcat.model.types.InterferenceLink;
import org.seamcat.model.types.PropagationModel;
import org.seamcat.plugin.PropagationModelConfiguration;

public class ConsistencyCheck {
    public static void checkVictim(Scenario scenario, OFDMAUpLinkSystemPlugin plugin, RadioSystem victim, Validator validator) {
        int usRB;
        int bsRB;
        boolean variationSelected;
        PropagationModel pm;
        ConsistencyCheck.validateCapacity(plugin, validator);
        ConsistencyCheck.checkCouplingLossPercentile(plugin, victim, validator);
        Bounds bounds = scenario.getVictim().getFrequency().getBounds();
        double rFreqVrMin = bounds.getMin();
        double rFreqVrMax = bounds.getMax();
        Function function = victim.getReceiver().getBlockingMask().getFunction();
        if (!function.isConstant()) {
            DiscreteFunction func = (DiscreteFunction)function;
            double min = func.getBounds().getMin();
            double max = func.getBounds().getMax();
            for (InterferenceLink link : scenario.getInterferenceLinks()) {
                Distribution freq = link.getFrequency();
                Bounds itbounds = freq.getBounds();
                if (!itbounds.isBounded()) continue;
                String name = link.getInterferer().getName();
                if (rFreqVrMin == rFreqVrMax && itbounds.getMax() == itbounds.getMin()) {
                    if (rFreqVrMax - itbounds.getMax() == 0.0) {
                        if (max < itbounds.getMax() - rFreqVrMax) {
                            validator.error("Blocking response upper limit (" + InterferingLinkCheck.fAndU(max) + ") does not match the interfering transmitter frequency (" + InterferingLinkCheck.fAndU(itbounds.getMax()) + ")<br> of Interfering Link [" + name + "] and the victim receiver frequency (" + InterferingLinkCheck.fAndU(rFreqVrMin) + ")");
                        }
                        if (min > rFreqVrMax - itbounds.getMin()) {
                            validator.error("Blocking response lower limit (" + InterferingLinkCheck.fAndU(min) + ") does not match the interfering transmitter frequency (" + InterferingLinkCheck.fAndU(itbounds.getMax()) + ")<br> of Interfering Link [" + name + "] and the victim receiver frequency (" + InterferingLinkCheck.fAndU(rFreqVrMin) + ")");
                        }
                    }
                    if (rFreqVrMax - itbounds.getMax() < 0.0 && max < itbounds.getMax() - rFreqVrMax) {
                        validator.error("Blocking response upper limit (" + InterferingLinkCheck.fAndU(max) + ") does not match the interfering transmitter frequency (" + InterferingLinkCheck.fAndU(itbounds.getMax()) + ")<br> of Interfering Link [" + name + "] and the victim receiver frequency (" + InterferingLinkCheck.fAndU(rFreqVrMin) + ")");
                    }
                    if (!(rFreqVrMax - itbounds.getMax() > 0.0) || !(min > itbounds.getMin() - rFreqVrMax)) continue;
                    validator.error("Blocking response lower limit (" + InterferingLinkCheck.fAndU(min) + ") does not match the interfering transmitter frequency (" + InterferingLinkCheck.fAndU(itbounds.getMax()) + ")<br> of Interfering Link [" + name + "] and the victim receiver frequency (" + InterferingLinkCheck.fAndU(rFreqVrMin) + ")");
                    continue;
                }
                if (rFreqVrMin - itbounds.getMin() < 0.0 && rFreqVrMax - itbounds.getMin() < 0.0 && max < itbounds.getMax() - rFreqVrMin) {
                    validator.error("Blocking response upper limit (" + InterferingLinkCheck.fAndU(max) + ") does not match the interfering transmitter frequency (" + InterferingLinkCheck.fAndU(itbounds.getMax()) + ")<br> of Interfering Link [" + name + "] and the victim receiver frequency (" + InterferingLinkCheck.fAndU(rFreqVrMin) + ")");
                }
                if (rFreqVrMin - itbounds.getMin() < 0.0 && rFreqVrMax - itbounds.getMin() >= 0.0 && rFreqVrMax - itbounds.getMax() < 0.0) {
                    if (max < itbounds.getMax() - rFreqVrMin) {
                        validator.error("Blocking response upper limit (" + InterferingLinkCheck.fAndU(max) + ") does not match the interfering transmitter frequency (" + InterferingLinkCheck.fAndU(itbounds.getMax()) + ")<br> of Interfering Link [" + name + "] and the victim receiver frequency (" + InterferingLinkCheck.fAndU(rFreqVrMin) + ")");
                    }
                    if (min > itbounds.getMin() - rFreqVrMax) {
                        validator.error("Blocking response lower limit (" + InterferingLinkCheck.fAndU(min) + ") does not match the interfering transmitter frequency (" + InterferingLinkCheck.fAndU(itbounds.getMin()) + ")<br> of Interfering Link [" + name + "] and the victim receiver frequency (" + InterferingLinkCheck.fAndU(rFreqVrMax) + ")");
                    }
                }
                if (rFreqVrMin - itbounds.getMin() >= 0.0 && rFreqVrMax - itbounds.getMax() <= 0.0) {
                    if (max < itbounds.getMax() - rFreqVrMin) {
                        validator.error("Blocking response upper limit (" + InterferingLinkCheck.fAndU(max) + ") does not match the interfering transmitter frequency (" + InterferingLinkCheck.fAndU(itbounds.getMax()) + ")<br> of Interfering Link [" + name + "] and the victim receiver frequency (" + InterferingLinkCheck.fAndU(rFreqVrMin) + ")");
                    }
                    if (min > itbounds.getMin() - rFreqVrMax) {
                        validator.error("Blocking response lower limit (" + InterferingLinkCheck.fAndU(min) + ") does not match the interfering transmitter frequency (" + InterferingLinkCheck.fAndU(itbounds.getMin()) + ")<br> of Interfering Link [" + name + "] and the victim receiver frequency (" + InterferingLinkCheck.fAndU(rFreqVrMax) + ")");
                    }
                }
                if (rFreqVrMin - itbounds.getMin() > 0.0 && rFreqVrMin - itbounds.getMax() <= 0.0 && rFreqVrMax - itbounds.getMax() > 0.0) {
                    if (max < itbounds.getMax() - rFreqVrMin) {
                        validator.error("Blocking response upper limit (" + InterferingLinkCheck.fAndU(max) + ") does not match the interfering transmitter frequency (" + InterferingLinkCheck.fAndU(itbounds.getMax()) + ")<br> of Interfering Link [" + name + "] and the victim receiver frequency (" + InterferingLinkCheck.fAndU(rFreqVrMin) + ")");
                    }
                    if (min > itbounds.getMin() - rFreqVrMax) {
                        validator.error("Blocking response lower limit (" + InterferingLinkCheck.fAndU(min) + ") does not match the interfering transmitter frequency (" + InterferingLinkCheck.fAndU(itbounds.getMin()) + ")<br> of Interfering Link [" + name + "] and the victim receiver frequency (" + InterferingLinkCheck.fAndU(rFreqVrMax) + ")");
                    }
                }
                if (!(rFreqVrMin - itbounds.getMax() > 0.0) || !(rFreqVrMax - itbounds.getMax() > 0.0) || !(min > itbounds.getMin() - rFreqVrMax)) continue;
                validator.error("Blocking response lower limit (" + InterferingLinkCheck.fAndU(min) + ") does not match the interfering transmitter frequency (" + InterferingLinkCheck.fAndU(itbounds.getMin()) + ")<br> of Interfering Link [" + name + "] and the victim receiver frequency (" + InterferingLinkCheck.fAndU(rFreqVrMax) + ")");
            }
        }
        if (plugin.getPathLossCorrelation().isUsingPathLossCorrelation() && (pm = victim.getPropagationModel()) instanceof PropagationModelConfiguration && (variationSelected = ((PropagationModelConfiguration)pm).isVariationSelected())) {
            validator.error("Victim System has both pathloss correlation and internal variation selected. This is not supported.");
        }
        if ((bsRB = plugin.getMaxRBsPrBS()) % (usRB = plugin.getMaxRBsPrMS()) != 0) {
            validator.error("<br/>You have selected a maximum of " + bsRB + " resourceblocks per basestation and " + usRB + " resourceblocks per user. This will result in a not fully loaded system.<br />With your current settings the system can not be loaded more than " + Mathematics.round(100.0 - (double)(bsRB / usRB) / ((double)bsRB * 1.0) * 100.0) + "%");
        }
        Function maskUsed = victim.getReceiver().getBlockingMask().getFunction();
        double referenceAtZero = maskUsed.evaluate(0.0);
        double bw = 0.0;
        if (!maskUsed.isConstant()) {
            for (double f = 0.0; f < maskUsed.getBounds().getMax(); f += 0.001) {
                if (!(Math.abs(referenceAtZero - maskUsed.evaluate(f)) > 3.0)) continue;
                bw = f;
                break;
            }
            int rBandwidthToRB = (int)(2.0 * bw * 1000.0 / plugin.getBandwidthOfResourceBlock());
            int tRBtolerance = (int)(0.2 * (double)usRB);
            if (Math.abs(usRB - rBandwidthToRB) > tRBtolerance) {
                validator.error("<HtMl><br/>The bandwidth of the Blocking mask (" + Math.rint(2.0 * bw * 1000.0) / 1000.0 + " MHz) conflicts with the number of RBs (" + usRB + ") allocated to the UEs.<br/><em style='color: maroon; font-weight: bold';>It is highly recommended to use a mask which complies with the number of RBs of the UEs </em>");
            }
        }
    }

    public static void checkInterferer(OFDMAUpLinkSystemPlugin plugin, RadioSystem cs, Validator validator) {
        boolean variationSelected;
        PropagationModel pm;
        ConsistencyCheck.validateCapacity(plugin, validator);
        ConsistencyCheck.checkCouplingLossPercentile(plugin, cs, validator);
        if (plugin.getPathLossCorrelation().isUsingPathLossCorrelation() && (pm = cs.getPropagationModel()) instanceof PropagationModelConfiguration && (variationSelected = pm.isVariationSelected())) {
            validator.error("Interfering System has both pathloss correlation and internal variation selected. This is not supported.");
        }
        int usRB = plugin.getMaxRBsPrMS();
        int bsRB = plugin.getMaxRBsPrBS();
        if (bsRB % usRB != 0) {
            validator.error("<br/>You have selected a maximum of " + bsRB + " resourceblocks per basestation and " + usRB + " resourceblocks per user. This will result in a not fully loaded system.<br />With your current settings the system can not be loaded more than " + Mathematics.round(100.0 - (double)(bsRB / usRB) / ((double)bsRB * 1.0) * 100.0) + "%");
        }
        MaskFunction emissionMask = cs.getTransmitter().getEmissionsMask().getEmissionMask();
        double referencePower = emissionMask.evaluate(0.0);
        double bw = 0.0;
        for (double f = 0.0; f < emissionMask.getBounds().getMax(); f += 0.1) {
            if (!(Math.abs(referencePower - emissionMask.evaluate(f)) > 23.0)) continue;
            bw = f;
            break;
        }
        int rBandwidthToRB = (int)(2.0 * bw * 1000.0 / plugin.getBandwidthOfResourceBlock());
        int tRBtolerance = (int)(0.2 * (double)usRB);
        if (Math.abs(rBandwidthToRB - usRB) > tRBtolerance) {
            validator.error("<HtMl>The bandwidth of the UE emission mask (" + Math.rint(2.0 * bw * 1000.0) / 1000.0 + " MHz) conflicts with the number of RBs (" + usRB + ") allocated to the UEs.<br/><em style='color: maroon; font-weight: bold';>It is highly recommended to use a mask which complies with the number of RBs of the UEs </em>");
        }
    }

    private static void checkCouplingLossPercentile(OFDMAUpLinkSystemPlugin cs, RadioSystem system, Validator validator) {
        OptionalValue<Double> percentile = cs.getPercentile();
        if (percentile.isRelevant()) {
            if (percentile.getValue() < cs.getMinimumCouplingLoss()) {
                validator.error("Coupling loss percentile out of range: it cannot be lower than the specified value for the Minimum Coupling Loss' (" + cs.getMinimumCouplingLoss() + " dB)");
            }
            double B = system.getTransmitter().getBandwidth();
            double UE_max_tx_power = cs.getMaximumAllowedTransmitPowerOfMS();
            double k = 1.38E-23;
            double T2 = 293.0;
            double NF = cs.getReceiverNoiseFigure();
            double Thermal_noise = 10.0 * Math.log10(k * T2) + 30.0 + 10.0 * Math.log10(B) + 60.0;
            double Noise_floor = Thermal_noise + NF;
            double SINR_minimum = -10.0;
            double CL_xile_upper_limit = UE_max_tx_power - (Noise_floor + SINR_minimum);
            if (percentile.getValue() > CL_xile_upper_limit) {
                validator.error("Coupling loss percentile out of range: it cannot be larger than: " + CL_xile_upper_limit + " dB.<br>This is: [Maximum power of the MS (dBm)  \u2013 (Noise Floor for the used bandwith by the MS (dBm) + minimum SINR value from the bitrate mapping table (dB)]");
            }
        }
    }

    private static void validateCapacity(OFDMAUpLinkSystemPlugin plugin, Validator validator) {
        if (plugin.useNumberOfActiveMsPerBs()) {
            int num = plugin.getNumberOfActiveMsPerBs();
            int max = (int)Math.floor((double)plugin.getMaxRBsPrBS() / (double)plugin.getMaxRBsPrMS());
            if (num < 1 || num > max) {
                validator.error("Number of active MS per BS must be in the range of [1;" + max + "]");
            }
            if (max != plugin.getProbabilities().size()) {
                validator.error("The frequency scheduling probabilities does not match the full capacity of the system (" + max + "). This means the frequency probabilities will be reset when simulation starts.");
            }
        }
    }
}

