/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.systems.ofdmauplink.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import org.seamcat.model.RadioSystem;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.plugin.OptionalValue;
import org.seamcat.model.plugin.eventprocessing.LongTask;
import org.seamcat.model.plugin.system.CustomPanelBuilder;
import org.seamcat.model.plugin.system.ModelEditor;
import org.seamcat.model.plugin.system.PanelModelEditor;
import org.seamcat.model.systems.ofdmauplink.OFDMAUpLinkSystemPlugin;
import org.seamcat.model.systems.ofdmauplink.simulation.CouplingLossEstimator;
import org.seamcat.model.systems.ofdmauplink.ui.OFDMAUpLinkUI;
import org.seamcat.model.systems.ofdmauplink.ui.SystemModelOFDMAUpLink;
import org.seamcat.presentation.MainWindow;
import org.seamcat.presentation.display.VectorDialog;
import org.seamcat.presentation.genericgui.LongTaskSwingExecutor;
import org.seamcat.presentation.genericgui.item.CalculatedValueItem;
import org.seamcat.presentation.genericgui.panelbuilder.GenericPanelEditor;
import org.seamcat.simulation.result.ContextImpl;

public class CouplingLossEstimationUI
implements CustomPanelBuilder<OFDMAUpLinkUI, SystemModelOFDMAUpLink> {
    private static final DecimalFormat df = new DecimalFormat("#.###");
    private List<Double> samples = new ArrayList<Double>();

    @Override
    public PanelModelEditor<OFDMAUpLinkUI> build(OFDMAUpLinkUI model, final ModelEditor<SystemModelOFDMAUpLink> modelEditor) {
        final GenericPanelEditor<OFDMAUpLinkUI> editor = new GenericPanelEditor<OFDMAUpLinkUI>(MainWindow.getInstance(), OFDMAUpLinkUI.class, model);
        final CalculatedValueItem item = editor.getCalculatedValues().get(0);
        item.setPreviewText("CDF");
        item.getPreviewButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CouplingLossEstimationUI.this.showCDF();
            }
        });
        item.getEvaluateButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LongTaskSwingExecutor.execute(new LongTask<Double>(){

                    @Override
                    public Double process() throws Exception {
                        CouplingLossEstimationUI.this.samples.clear();
                        double frequency = ((SystemModelOFDMAUpLink)modelEditor.getModel()).general().frequency().trial();
                        OFDMAUpLinkSystemPlugin plugin = new OFDMAUpLinkSystemPlugin();
                        plugin.setUI((SystemModelOFDMAUpLink)modelEditor.getModel());
                        plugin.prepareSimulation(null);
                        RadioSystem system = plugin.getSystem(new ContextImpl());
                        double couplingLossPercentile = CouplingLossEstimator.estimate(plugin, system, frequency, CouplingLossEstimationUI.this.samples);
                        item.setResult(df.format(couplingLossPercentile));
                        item.showPreview();
                        return couplingLossPercentile;
                    }

                    @Override
                    public void done(Double result) {
                        OFDMAUpLinkUI prototype = Factory.prototype(OFDMAUpLinkUI.class, ((SystemModelOFDMAUpLink)modelEditor.getModel()).generalSettings().ofdmaUpLink());
                        OptionalValue<Double> current = ((SystemModelOFDMAUpLink)modelEditor.getModel()).generalSettings().ofdmaUpLink().percentile();
                        Factory.when(prototype.percentile()).thenReturn(Factory.results().optional(current.isRelevant(), (double)Math.round(result * 1000.0) / 1000.0));
                        editor.setModel(Factory.build(prototype));
                    }
                });
            }
        });
        return new PanelModelEditor<OFDMAUpLinkUI>(){

            @Override
            public JPanel getPanel() {
                return editor;
            }

            @Override
            public OFDMAUpLinkUI getModel() {
                return (OFDMAUpLinkUI)editor.getModel();
            }
        };
    }

    private void showCDF() {
        if (this.samples.isEmpty()) {
            return;
        }
        double[] data = new double[this.samples.size()];
        for (int i = 0; i < this.samples.size(); ++i) {
            data[i] = this.samples.get(i);
        }
        new VectorDialog(data, "Sorted samples of the coupling loss", "dB", "samples");
    }
}

