/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.types;

import org.seamcat.model.distributions.Distribution;

public interface LocalEnvironment {
    public double getProbability();

    public Environment getEnvironment();

    public boolean isUsingClutter();

    public OutdoorClutterMode getOutdoorModel();

    public Distribution getPercentageOfLocations();

    public ClutterEnvironment getLocalClutter();

    public boolean isUserDefined();

    public double getHeight();

    public double getWidth();

    public boolean isUsingBEL();

    public double getWallLoss();

    public double getWallLossStdDev();

    public Distribution getProbabilityExceedingNBEL();

    public double getBuildingTypePercentage();

    public static enum OutdoorClutterMode {
        SPECIFIC("Site specific clutter model according to P.1812-4"),
        GENERAL("Site-general clutter model for terrestrial paths"),
        EARTH_TO_SPACE("Site-general clutter model for Earth-to-space paths");

        private String title;

        private OutdoorClutterMode(String title) {
            this.title = title;
        }

        public String toString() {
            return this.title;
        }
    }

    public static enum ClutterEnvironment {
        WATER("Water/Sea", 10.0, 2),
        OPEN("Open/Rural", 10.0, 2),
        SUBURBAN("Suburban", 10.0, 1),
        URBAN("Urban/Trees/Forest", 15.0, 1),
        DENSE_URBAN("Dense Urban", 20.0, 1);

        private String name;
        private int eqnum;
        private double R;

        private ClutterEnvironment(String name, double R, int eqnum) {
            this.name = name;
            this.eqnum = eqnum;
            this.R = R;
        }

        public String toString() {
            return this.name;
        }

        public int eqnum() {
            return this.eqnum;
        }

        public double R() {
            return this.R;
        }
    }

    public static enum Environment {
        Indoor,
        Outdoor;

    }
}

