/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.types;

import java.util.List;
import org.seamcat.model.distributions.Distribution;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.functions.BlockingMask;
import org.seamcat.model.functions.Function;
import org.seamcat.model.simulation.result.UniqueValueDef;
import org.seamcat.model.types.AntennaGain;
import org.seamcat.model.types.LocalEnvironment;

public final class Receiver {
    public static final UniqueValueDef BLOCKING_MASK_INTEGRAL = Factory.results().function("Blocking mask integral", "MHz", "dB");
    public static final UniqueValueDef INTERMODULATION_REJECTION = Factory.results().function("Intermodulation rejection", "MHz", "dB");
    private BlockingMask blockingMask;
    private final double bandwidth;
    private List<LocalEnvironment> environments;
    private AntennaGain antennaGain;
    private Distribution height;
    private Function pseudoBlockingMask;
    private final boolean isUsingIntermodulation;
    private final Function intermodulation;
    private final double intermodThreshold;
    private final boolean isUsingOverloading;
    private final Function filter;
    private final Function overloading;

    public Receiver(BlockingMask blockingMask, double bandwidth, List<LocalEnvironment> environments, AntennaGain antennaGain, Distribution height, Function pseudoBlockingMask, boolean isUsingOverloading, Function overloading, boolean isUsingIntermodulation, Function intermodulation, double intermodThreshold, Function filter) {
        this.pseudoBlockingMask = pseudoBlockingMask;
        this.blockingMask = blockingMask;
        this.bandwidth = bandwidth;
        this.environments = environments;
        this.antennaGain = antennaGain;
        this.height = height;
        this.isUsingOverloading = isUsingOverloading;
        this.overloading = overloading;
        this.filter = filter;
        this.isUsingIntermodulation = isUsingIntermodulation;
        this.intermodulation = intermodulation;
        this.intermodThreshold = intermodThreshold;
    }

    public Receiver(BlockingMask blockingMask, double bandwidth, List<LocalEnvironment> environments, AntennaGain antennaGain, Distribution height, Function pseudoBlockingMask) {
        this(blockingMask, bandwidth, environments, antennaGain, height, pseudoBlockingMask, false, null, false, null, 0.0, null);
    }

    public BlockingMask getBlockingMask() {
        return this.blockingMask;
    }

    public double getBandwidth() {
        return this.bandwidth;
    }

    public List<LocalEnvironment> getLocalEnvironments() {
        return this.environments;
    }

    public AntennaGain getAntennaGain() {
        return this.antennaGain;
    }

    public Distribution getHeight() {
        return this.height;
    }

    public Function getPseudoBlockingMask() {
        return this.pseudoBlockingMask;
    }

    public boolean isUsingOverloading() {
        return this.isUsingOverloading;
    }

    public Function getOverloadingMask() {
        return this.overloading;
    }

    public Function getReceiverFilter() {
        return this.filter;
    }

    public boolean isIntermodulationRejectionOption() {
        return this.isUsingIntermodulation;
    }

    public Function getIntermodulationRejection() {
        return this.intermodulation;
    }

    public double intermodulationThreshold() {
        return this.intermodThreshold;
    }
}

