/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.objectutils;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.seamcat.model.factory.ProxyHelper;
import org.seamcat.model.factory.SeamcatInvocationHandler;
import org.seamcat.model.plugin.system.SystemPlugin;
import org.seamcat.model.types.Description;
import org.seamcat.objectutils.ArrayEquals;
import org.seamcat.objectutils.IterablesEquals;
import org.seamcat.objectutils.MapEquals;

public class DeepEquals {
    private static final Logger LOG = Logger.getLogger(DeepEquals.class);
    private static final Set<Class<?>> basicTypes = new HashSet();
    private Set<Pair> compared;

    public static boolean equals(Object a, Object b) {
        return new DeepEquals().compare(a, b);
    }

    public boolean compare(Object a, Object b) {
        this.compared = new HashSet<Pair>();
        return this.deepCompare(a, b);
    }

    protected boolean deepCompare(Object a, Object b) {
        if (a == null && b != null || a != null && b == null) {
            return false;
        }
        if (a == null) {
            return true;
        }
        if (a instanceof Description && b instanceof Description) {
            return ((Description)a).name().equals(((Description)b).name()) && ((Description)a).description().equals(((Description)b).description());
        }
        if (a instanceof SystemPlugin && b instanceof SystemPlugin) {
            Object uiA = ((SystemPlugin)a).getUI();
            Object uiB = ((SystemPlugin)b).getUI();
            return this.deepCompare(uiA, uiB);
        }
        if (a instanceof Proxy && b instanceof Proxy) {
            SeamcatInvocationHandler ihA = ProxyHelper.getHandler(a);
            SeamcatInvocationHandler ihB = ProxyHelper.getHandler(b);
            return this.deepCompare(ihA.getValues(), ihB.getValues());
        }
        if (a.getClass() != b.getClass()) {
            return false;
        }
        if (a == b) {
            return true;
        }
        if (DeepEquals.basicType(a)) {
            return a.equals(b);
        }
        if (Iterable.class.isAssignableFrom(a.getClass())) {
            if (this.needCompare(a, b)) {
                return new IterablesEquals(this, ((Iterable)a).iterator(), ((Iterable)b).iterator()).equals();
            }
        } else if (Map.class.isAssignableFrom(a.getClass())) {
            if (this.needCompare(a, b)) {
                return new MapEquals(this, (Map)a, (Map)b).mapEquals();
            }
        } else if (a.getClass().isArray() && this.needCompare(a, b)) {
            return new ArrayEquals(this, a, b).equals();
        }
        if (this.needCompare(a, b)) {
            return this.classCompare(a.getClass(), a, b);
        }
        return true;
    }

    protected boolean classCompare(Class<?> clazz, Object a, Object b) {
        for (Field field : clazz.getDeclaredFields()) {
            if (Modifier.isTransient(field.getModifiers())) continue;
            field.setAccessible(true);
            try {
                Object aField = field.get(a);
                Object bField = field.get(b);
                if (this.deepCompare(aField, bField)) continue;
                return false;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        if (clazz.getSuperclass() == null) {
            return true;
        }
        return this.classCompare(clazz.getSuperclass(), a, b);
    }

    private boolean needCompare(Object a, Object b) {
        Pair pair = new Pair(a, b);
        if (!this.compared.contains(pair)) {
            this.compared.add(pair);
            return true;
        }
        return false;
    }

    private static boolean basicType(Object a) {
        return basicTypes.contains(a.getClass());
    }

    static {
        basicTypes.add(Double.class);
        basicTypes.add(String.class);
        basicTypes.add(Integer.class);
        basicTypes.add(Float.class);
        basicTypes.add(Boolean.class);
        basicTypes.add(Long.class);
    }

    class Pair {
        private Object a;
        private Object b;

        public Pair(Object a, Object b) {
            this.a = a;
            this.b = b;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof Pair)) {
                return false;
            }
            Pair p = (Pair)o;
            return p.hashCode() == this.hashCode();
        }

        public int hashCode() {
            int ib;
            int ia = System.identityHashCode(this.a);
            if (ia < (ib = System.identityHashCode(this.b))) {
                return ia * 31 + ib * 37;
            }
            return ib * 31 + ia * 37;
        }
    }
}

