/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.objectutils;

import java.util.ArrayList;
import java.util.List;
import org.seamcat.model.InterferenceLinkElement;
import org.seamcat.model.Workspace;
import org.seamcat.model.distributions.Distribution;
import org.seamcat.model.factory.ProxyHelper;
import org.seamcat.model.plugin.system.SystemPlugin;
import org.seamcat.model.simulation.result.SimulationResult;
import org.seamcat.model.workspace.InterferenceLinkUI;
import org.seamcat.objectutils.DeepEquals;
import org.seamcat.plugin.EventProcessingConfiguration;
import org.seamcat.simulation.result.SimulationResultImpl;

public class WorkspaceCloneHelper {
    public static Workspace clone(Workspace workspace) {
        Workspace clone = new Workspace();
        clone.setName(workspace.getName());
        clone.setSimulationControl(workspace.getSimulationControl());
        clone.setVictimSystemId(workspace.getVictimSystemId());
        clone.setVictimFrequency(workspace.getVictimFrequency());
        ArrayList<SystemPlugin> syss = new ArrayList<SystemPlugin>();
        for (SystemPlugin element : workspace.getSystemPlugins()) {
            SystemPlugin copy = ProxyHelper.cloneSystemPluginKeepIds(element);
            syss.add(copy);
        }
        clone.setSystemPlugins(syss);
        ArrayList<InterferenceLinkElement> ilUIs = new ArrayList<InterferenceLinkElement>();
        for (InterferenceLinkElement element : workspace.getInterferenceLinkUIs()) {
            ilUIs.add(new InterferenceLinkElement(element.getId(), element.getInterferingSystemId(), element.getName(), ProxyHelper.deepCloneComposite(InterferenceLinkUI.class, element.getSettings())));
        }
        clone.setInterferenceLinkUIs(ilUIs);
        clone.getInterferingLinkFrequency().addAll(workspace.getInterferingLinkFrequency());
        clone.setEventProcessingList(new ArrayList<EventProcessingConfiguration>(workspace.getEventProcessingList()));
        return clone;
    }

    public static SimulationResult clone(SimulationResultImpl simulationResult) {
        return simulationResult.copy();
    }

    public static boolean equals(SimulationResult original, SimulationResult clone) {
        boolean equals = DeepEquals.equals(original, clone);
        return equals;
    }

    public static boolean equals(Workspace original, Workspace clone) {
        int i;
        if (original == null || clone == null) {
            return false;
        }
        boolean equals = original.getVictimSystemId().equals(clone.getVictimSystemId());
        if (!equals) {
            return false;
        }
        equals = original.getName().equals(clone.getName());
        if (!equals) {
            return false;
        }
        boolean bl = equals = original.getSystemPlugins().size() == clone.getSystemPlugins().size();
        if (!equals) {
            return false;
        }
        for (i = 0; i < original.getSystemPlugins().size(); ++i) {
            equals = WorkspaceCloneHelper.systemPlugin(original.getSystemPlugins().get(i), clone.getSystemPlugins().get(i));
            if (equals) continue;
            return false;
        }
        boolean bl2 = equals = original.getInterferenceLinkUIs().size() == clone.getInterferenceLinkUIs().size();
        if (!equals) {
            return false;
        }
        for (i = 0; i < original.getInterferenceLinkUIs().size(); ++i) {
            equals = DeepEquals.equals(original.getInterferenceLinkUIs().get(i).getSettings(), clone.getInterferenceLinkUIs().get(i).getSettings());
            if (equals) continue;
            return false;
        }
        equals = DeepEquals.equals(original.getVictimFrequency(), clone.getVictimFrequency());
        if (!equals) {
            return false;
        }
        boolean bl3 = equals = original.getInterferingLinkFrequency().size() == clone.getInterferingLinkFrequency().size();
        if (!equals) {
            return false;
        }
        for (i = 0; i < original.getInterferingLinkFrequency().size(); ++i) {
            Distribution cloneDist;
            Distribution orig = original.getInterferingLinkFrequency().get(i);
            equals = DeepEquals.equals(orig, cloneDist = clone.getInterferingLinkFrequency().get(i));
            if (equals) continue;
            return false;
        }
        equals = DeepEquals.equals(original.getSimulationControl(), clone.getSimulationControl());
        if (!equals) {
            return false;
        }
        return WorkspaceCloneHelper.equalsEPP(original.getEventProcessingList(), clone.getEventProcessingList());
    }

    private static boolean systemPlugin(SystemPlugin a, SystemPlugin b) {
        return DeepEquals.equals(a, b);
    }

    private static boolean equalsEPP(List<EventProcessingConfiguration> original, List<EventProcessingConfiguration> clone) {
        if (original.size() != clone.size()) {
            return false;
        }
        for (int i = 0; i < original.size(); ++i) {
            EventProcessingConfiguration origEPP = original.get(i);
            EventProcessingConfiguration cloneEPP = clone.get(i);
            if (DeepEquals.equals(origEPP.getModel(), cloneEPP.getModel())) continue;
            return false;
        }
        return true;
    }
}

