/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.ofdma;

import org.seamcat.dmasystems.AbstractDmaLink;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.ofdma.DownlinkOfdmaSystem;
import org.seamcat.ofdma.OfdmaDownlink;
import org.seamcat.ofdma.OfdmaMobile;
import org.seamcat.ofdma.OfdmaSystem;

public class DownlinkOfdmaMobile
extends OfdmaMobile {
    protected DownlinkOfdmaSystem system;
    private double interferencePower;
    private double cache;

    public DownlinkOfdmaMobile(Point2D point, DownlinkOfdmaSystem _system, int _userid, double antGain, double antHeight) {
        super(point, _system, _userid, antGain, antHeight);
        this.setUpLinkMode(false);
        this.system = _system;
    }

    protected OfdmaDownlink[] generateLinksArray() {
        return new OfdmaDownlink[this.getSystem().getNumberOfBaseStations()];
    }

    @Override
    public double calculateSINR() {
        this.setReceivedPowerWatt(this.servingLink.calculateCurrentReceivePower_Watt());
        this.interferencePower = this.calculateTotalInterference_Watt();
        this.setTotalInterference(this.interferencePower);
        this.setSINRAchieved(Mathematics.linear2dB(this.getReceivedPowerWatt() / this.interferencePower));
        return this.getSINRAchieved();
    }

    private double calculateTotalInterference_Watt() {
        double I_thermal_dBm = this.getSystem().getPreSimulation().findDoubleValue(OfdmaSystem.THERMAL_NOISE_UE);
        double sum_Watt = this.cache;
        if (this.cache == 0.0) {
            for (AbstractDmaLink link : this.links) {
                double inter_dBm = link.calculateCurrentReceivePower_dBm();
                sum_Watt += Mathematics.fromdBm2Watt(inter_dBm);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Sum interference: " + Mathematics.fromWatt2dBm(sum_Watt) + " inter_dBm: " + inter_dBm);
            }
            this.cache = sum_Watt;
        }
        sum_Watt -= Mathematics.fromdBm2Watt(this.servingLink.calculateCurrentReceivePower_dBm());
        if (LOG.isDebugEnabled()) {
            LOG.debug("InterSystemInterference: " + Mathematics.fromWatt2dBm(sum_Watt));
        }
        this.setInterSystemInterference(Mathematics.fromWatt2dBm(sum_Watt));
        double res = Mathematics.fromdBm2Watt(I_thermal_dBm) + sum_Watt;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Total External interference (dBm): " + Mathematics.fromWatt2dBm(res));
        }
        return res;
    }

    public double getInterferencePower() {
        return Mathematics.linear2dB(this.interferencePower);
    }
}

