/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.ofdma;

import org.seamcat.dmasystems.AbstractDmaLink;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.model.plugin.system.SystemPlugin;
import org.seamcat.model.simulation.result.LinkResult;
import org.seamcat.ofdma.DownlinkOfdmaMobile;
import org.seamcat.ofdma.OfdmaBaseStation;
import org.seamcat.ofdma.OfdmaMobile;
import org.seamcat.ofdma.OfdmaSystem;

public class OfdmaDownlink
extends AbstractDmaLink {
    protected OfdmaSystem system;

    public OfdmaDownlink(OfdmaBaseStation base, OfdmaMobile mobile, OfdmaSystem system) {
        super(false, base, mobile, system.getFrequency());
        this.system = system;
    }

    @Override
    public OfdmaBaseStation getBaseStation() {
        return (OfdmaBaseStation)super.getBaseStation();
    }

    @Override
    public double calculateCurrentReceivePower_dBm() {
        double eff = this.getEffectivePathloss();
        double userSubCarriers = this.system.getOFDMASettings().getNumberOfSubCarriersPerMobileStation();
        double basestationSubCarriers = this.getBaseStation().getSubCarriersInUse();
        double fraction = userSubCarriers / basestationSubCarriers;
        double power_W = this.getBaseStation().calculateCurrentTransmitPower_Watt();
        double adjustedPower_W = power_W * fraction;
        double chPower = Mathematics.fromWatt2dBm(adjustedPower_W);
        this.totalReceivedPower = chPower - eff;
        return this.totalReceivedPower;
    }

    @Override
    public void activateLink() {
        this.getUserTerminal().setServingLink(this);
        this.getMobileStation().initializeInActiveConnections(this);
        this.system.getActiveUsers().add(this.getMobileStation());
    }

    public String toString() {
        return "Ofdma Downlink between BS #" + this.getBaseStation().getCellid() + " and Mobile #" + this.getUserTerminal().getUserId() + " PL = " + this.getEffectivePathloss();
    }

    public DownlinkOfdmaMobile getMobileStation() {
        return (DownlinkOfdmaMobile)this.getUserTerminal();
    }

    @Override
    public OfdmaMobile getUserTerminal() {
        return (OfdmaMobile)super.getUserTerminal();
    }

    @Override
    public LinkResult asLinkResult() {
        LinkResult linkResult = super.asLinkResult();
        linkResult.setValue(SystemPlugin.BANDWIDTH_CORRECTION, Mathematics.linear2dB((double)this.system.getOFDMASettings().getNumberOfSubCarriersPerMobileStation() / (double)this.system.getOFDMASettings().getMaxSubCarriersPerBaseStation()));
        return linkResult;
    }
}

