/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.ofdma;

import org.seamcat.dmasystems.AbstractDmaLink;
import org.seamcat.dmasystems.AbstractDmaMobile;
import org.seamcat.model.functions.Function;
import org.seamcat.model.functions.FunctionException;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.ofdma.OfdmaBaseStation;
import org.seamcat.ofdma.OfdmaDownlink;
import org.seamcat.ofdma.OfdmaSystem;
import org.seamcat.ofdma.OfdmaUplink;
import org.seamcat.simulation.cellular.PathLossCorrelation;
import org.seamcat.simulation.cellular.ofdma.OFDMASettings;

public abstract class OfdmaMobile
extends AbstractDmaMobile {
    protected OfdmaSystem system;

    public OfdmaMobile(Point2D point, OfdmaSystem _system, int _userid, double antGain, double antHeight) {
        super(point, _system, _userid, antGain, antHeight);
        this.system = _system;
        this.setCurrentTransmitPowerIndBm(24.0);
    }

    public double calculateAchievedBitrate() {
        double sinr = this.calculateSINR();
        double maxAch = this.getMaxAchievableBitRate(sinr);
        int requestedSubCarriers = this.system.getOFDMASettings().getNumberOfSubCarriersPerMobileStation();
        this.setBitRateAchieved((double)requestedSubCarriers * (maxAch / (double)this.system.getOFDMASettings().getMaxSubCarriersPerBaseStation()));
        return this.getBitRateAchieved();
    }

    public abstract double calculateSINR();

    protected double getMaxAchievableBitRate(double sinrAchieved) {
        OFDMASettings settings = this.system.getOFDMASettings();
        Function function = settings.getBitrateMapping();
        double value = 0.0;
        if (sinrAchieved < function.getBounds().getMin()) {
            value = function.evaluateMin();
        } else if (sinrAchieved > function.getBounds().getMax()) {
            value = function.evaluateMax();
        } else {
            try {
                value = function.evaluate(sinrAchieved);
            }
            catch (FunctionException ex) {
                throw new RuntimeException(ex);
            }
        }
        return settings.getBandwidthOfResourceBlock() * (double)settings.getNumberOfSubCarriersPerMobileStation() * value;
    }

    @Override
    public void selectActiveList(double handoverMargin) {
        if (this.activeList.size() != 0) {
            throw new IllegalStateException("Active List selection should only be performed once!");
        }
        this.links[0].getBaseStation().intializeConnection(this.links[0]);
        this.addToActiveList(this.links[0]);
        if (this.links.length > 1) {
            int index = 1;
            double lowestLink = this.links[0].getEffectivePathloss();
            double nextLink = this.links[index].getEffectivePathloss();
            while (lowestLink + handoverMargin > nextLink) {
                if (index == 1) {
                    this.addToActiveList(this.links[1]);
                }
                this.links[index].getBaseStation().intializeConnection(this.links[index]);
                this.setInSoftHandover(true);
                if (++index < this.links.length) {
                    nextLink = this.links[index].getEffectivePathloss();
                    continue;
                }
                return;
            }
        } else {
            this.setInSoftHandover(false);
        }
    }

    public void initializeInActiveConnections(AbstractDmaLink activeLink) {
        for (AbstractDmaLink link : this.links) {
            if (link == activeLink) continue;
            link.connectToInActiveBaseStation();
        }
    }

    public int getLinkIndex() {
        if (this.servingLink != null) {
            return ((OfdmaBaseStation)this.servingLink.getBaseStation()).getLinkIndexOfActiveUser(this.servingLink);
        }
        return -1;
    }

    @Override
    public double getFrequency() {
        return this.system.calculateFrequency(this.getLinkIndex());
    }

    public double getBandwidth() {
        return (double)this.system.getOFDMASettings().getNumberOfSubCarriersPerMobileStation() * this.system.getResourceBlockSizeInMHz();
    }

    @Override
    public void generateLinksToBaseStations() {
        OfdmaBaseStation[][] cells = (OfdmaBaseStation[][])this.getSystem().getBaseStationArray();
        int linkid = 0;
        PathLossCorrelation correlation = this.system.getOFDMASettings().getPathLossCorrelation();
        double correlationInterSite = correlation.getCorrelationFactor();
        double a_inter = Math.sqrt(Math.abs(correlationInterSite));
        double b_inter = Math.sqrt(1.0 - Math.abs(correlationInterSite));
        double x = correlation.trial();
        for (OfdmaBaseStation[] cell : cells) {
            int j = 0;
            while (j < cell.length) {
                double y = correlation.trial();
                this.links[linkid] = this.isUpLinkMode() ? new OfdmaUplink(cell[j], this, this.system) : new OfdmaDownlink(cell[j], this, this.system);
                if (this.system.getOFDMASettings().getPathLossCorrelation().isUsingPathLossCorrelation()) {
                    this.links[linkid].determinePathLoss(this.system.getRadioSystem().getPropagationModel());
                    double pathloss = this.links[linkid].getTxRxPathLoss();
                    this.links[linkid].setTxRxPathLoss(pathloss += a_inter * x + b_inter * y);
                } else {
                    this.links[linkid].determinePathLoss(this.system.getRadioSystem().getPropagationModel());
                }
                ++j;
                ++linkid;
            }
        }
    }

    public String toString() {
        return "Mobile #" + this.getUserId() + " Achived SINR: " + this.getSINRAchieved();
    }

    public String getName() {
        return "MS " + this.getUserId();
    }
}

