/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.ofdma;

import org.seamcat.dmasystems.AbstractDmaBaseStation;
import org.seamcat.dmasystems.AbstractDmaSystem;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.generic.Defaults;
import org.seamcat.model.simulation.result.UniqueValueDef;
import org.seamcat.model.types.result.DoubleResultType;
import org.seamcat.ofdma.OfdmaBaseStation;
import org.seamcat.ofdma.OfdmaMobile;
import org.seamcat.simulation.cellular.CellularCalculations;
import org.seamcat.simulation.cellular.ofdma.OFDMASettings;

public abstract class OfdmaSystem<GenericMobileType extends OfdmaMobile>
extends AbstractDmaSystem<GenericMobileType> {
    public static final UniqueValueDef SUB_CARRIER_RATIO = Factory.results().single("Sub carrier ratio", "Ratio");
    public static final UniqueValueDef THERMAL_NOISE_UE = Factory.results().single("Thermal noise UE", "dBm");

    protected OfdmaSystem(AbstractDmaSystem<?> system) {
        super(system);
        this.getPlugin().setCDMASettings(null);
        if (system instanceof OfdmaSystem) {
            OfdmaSystem of = (OfdmaSystem)system;
            this.getPlugin().setOFDMASettings(of.getOFDMASettings());
        } else {
            this.getPlugin().setUsersPerCell(20);
            this.getPlugin().setHandoverMargin(3.0);
            this.getPlugin().setBandwidth(10.0);
        }
        if (this.getOFDMASettings() == null) {
            this.getPlugin().setOFDMASettings(new OFDMASettings(Defaults.defaultOFDMABitRateMapping()));
        }
    }

    public OFDMASettings getOFDMASettings() {
        return this.getPlugin().getOFDMASettings();
    }

    @Override
    public void calculateThermalNoise() {
        super.calculateThermalNoise();
        if (!this.getPreSimulation().hasSingleValue(THERMAL_NOISE_UE)) {
            int requestedSubCarriers = this.getOFDMASettings().getNumberOfSubCarriersPerMobileStation();
            double noise = CellularCalculations.calculateThermalNoise((double)requestedSubCarriers * this.getResourceBlockSizeInMHz(), this.getPlugin().getReceiverNoiseFigure());
            this.getPreSimulation().getSingleValueTypes().add(new DoubleResultType(THERMAL_NOISE_UE, noise));
        }
    }

    @Override
    public double getReferenceCellMeasurement() {
        return ((OfdmaBaseStation)this.referenceCell).calculateAggregateBitrateAchieved();
    }

    protected boolean initiateConnections() {
        boolean systemIsLoaded = true;
        for (AbstractDmaBaseStation base : this.getAllBaseStations()) {
            systemIsLoaded = systemIsLoaded && ((OfdmaBaseStation)base).initialConnect();
        }
        return systemIsLoaded;
    }

    protected abstract void simulateLinkSpecifics();

    @Override
    protected void generateAndPositionMobiles() {
        int max = (int)Math.floor((double)this.getOFDMASettings().getMaxSubCarriersPerBaseStation() / (double)this.getOFDMASettings().getNumberOfSubCarriersPerMobileStation());
        if (this.getOFDMASettings().getUpLinkSettings() != null && this.getOFDMASettings().getUpLinkSettings().isUseNumberOfActiveMsPerBs()) {
            max = this.getOFDMASettings().getUpLinkSettings().getNumberOfActiveMsPerBs();
        }
        int stop = max * this.getNumberOfBaseStations();
        for (int i = 0; i < stop; ++i) {
            this.generateInitializedMobile();
        }
    }

    @Override
    public void performPreSimulationTasks(double frequency) {
        super.performPreSimulationTasks(frequency);
        if (!this.getPreSimulation().hasSingleValue(SUB_CARRIER_RATIO)) {
            double ratio = (double)this.getOFDMASettings().getNumberOfSubCarriersPerMobileStation() / (double)this.getOFDMASettings().getMaxSubCarriersPerBaseStation();
            this.getPreSimulation().getSingleValueTypes().add(new DoubleResultType(SUB_CARRIER_RATIO, ratio));
        }
    }

    @Override
    public void simulate() {
        do {
            if (LOG.isDebugEnabled()) {
                LOG.debug(" Generating And Positioning mobiles: " + this.toString());
                LOG.debug(" System Description: OFDMA system");
                LOG.debug(" System Minimum coupling loss: " + this.getPlugin().getMinimumCouplingLoss() + " dBm");
            }
            this.generateAndPositionMobiles();
        } while (!this.initiateConnections());
        LOG.debug("calculateThermalNoise()");
        this.calculateThermalNoise();
        this.simulateLinkSpecifics();
    }

    public double getResourceBlockSizeInMHz() {
        return this.getOFDMASettings().getBandwidthOfResourceBlock() * 0.001;
    }

    public double calculateAverageAchievedBitrate() {
        double sum = 0.0;
        for (AbstractDmaBaseStation base : this.getAllBaseStations()) {
            sum += ((OfdmaBaseStation)base).calculateAggregateBitrateAchieved();
        }
        return sum / (double)this.getNumberOfBaseStations();
    }

    public double calculateFrequency(int linkIndex) {
        double systemBandwidth = this.getPlugin().getBandwidth();
        double systemFrequency = this.getFrequency();
        double numberOfSubCarrierPerMobile = this.getOFDMASettings().getNumberOfSubCarriersPerMobileStation();
        double numberOfSubCarriersPerBaseStation = this.getOFDMASettings().getMaxSubCarriersPerBaseStation();
        double resourceBlockBandwidth = this.getResourceBlockSizeInMHz();
        double diff = systemBandwidth - numberOfSubCarriersPerBaseStation * resourceBlockBandwidth;
        return systemFrequency - systemBandwidth / 2.0 + diff / 2.0 + numberOfSubCarrierPerMobile * resourceBlockBandwidth / 2.0 * (double)(linkIndex * 2 + 1);
    }
}

