/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.ofdma;

import java.util.List;
import org.seamcat.dmasystems.AbstractDmaLink;
import org.seamcat.model.factory.RandomAccessor;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.model.plugin.system.SystemPlugin;
import org.seamcat.model.simulation.result.LinkResult;
import org.seamcat.ofdma.OfdmaBaseStation;
import org.seamcat.ofdma.OfdmaMobile;
import org.seamcat.ofdma.OfdmaSystem;
import org.seamcat.ofdma.UplinkOfdmaBaseStation;

public class OfdmaUplink
extends AbstractDmaLink {
    protected OfdmaSystem system;
    private Integer resourceBlockNumber = null;

    public OfdmaUplink(OfdmaBaseStation _cell, OfdmaMobile _user, OfdmaSystem system) {
        super(true, _cell, _user, system.getFrequency());
        this.system = system;
    }

    @Override
    public double calculateCurrentReceivePower_dBm() {
        double chPower = this.getUserTerminal().getCurrentTransmitPowerIndBm();
        this.totalReceivedPower = chPower - this.getEffectivePathloss();
        return this.totalReceivedPower;
    }

    @Override
    public void activateLink() {
        this.getUserTerminal().setServingLink(this);
        this.system.getActiveUsers().add(this.getUserTerminal());
        this.getUserTerminal().initializeInActiveConnections(this);
        this.resourceBlockNumber = this.findResourceBlockNumber();
    }

    private int findResourceBlockNumber() {
        if (this.system.getOFDMASettings().getUpLinkSettings().isUseNumberOfActiveMsPerBs()) {
            int index;
            List<Double> props = this.system.getOFDMASettings().getUpLinkSettings().getFrequencyScheduling();
            double pick = RandomAccessor.getRandom().nextDouble() * 100.0;
            double limit = 0.0;
            for (index = 0; index < props.size() - 1 && !(pick < (limit += props.get(index).doubleValue())); ++index) {
            }
            return index;
        }
        return this.getUserTerminal().getLinkIndex();
    }

    public String toString() {
        return "OfdmaUplink between BS " + this.getBaseStation().getCellid() + " and Mobile " + this.getUserTerminal().getUserId();
    }

    @Override
    public UplinkOfdmaBaseStation getBaseStation() {
        return (UplinkOfdmaBaseStation)super.getBaseStation();
    }

    @Override
    public OfdmaMobile getUserTerminal() {
        return (OfdmaMobile)super.getUserTerminal();
    }

    public double calculateFrequency() {
        return this.system.calculateFrequency(this.resourceBlockNumber);
    }

    @Override
    public LinkResult asLinkResult() {
        LinkResult linkResult = super.asLinkResult();
        linkResult.setValue(SystemPlugin.BANDWIDTH_CORRECTION, Mathematics.linear2dB((double)this.system.getOFDMASettings().getNumberOfSubCarriersPerMobileStation() / (double)this.system.getOFDMASettings().getMaxSubCarriersPerBaseStation()));
        return linkResult;
    }

    public int getResourceBlockNumber() {
        return this.resourceBlockNumber;
    }
}

