/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.ofdma;

import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.ofdma.OfdmaMobile;
import org.seamcat.ofdma.OfdmaUplink;
import org.seamcat.ofdma.UplinkOfdmaSystem;

public class UplinkOfdmaMobile
extends OfdmaMobile {
    protected UplinkOfdmaSystem system;

    public UplinkOfdmaMobile(Point2D point, UplinkOfdmaSystem _system, int _userid, double antGain, double antHeight) {
        super(point, _system, _userid, antGain, antHeight);
        this.system = _system;
        this.setUpLinkMode(true);
    }

    @Override
    public double calculateSINR() {
        this.setReceivedPowerWatt(this.servingLink.calculateCurrentReceivePower_Watt());
        OfdmaUplink serving = (OfdmaUplink)this.servingLink;
        this.setTotalInterference(serving.getBaseStation().calculateTotalInterference_Watt(serving));
        this.setSINRAchieved(Mathematics.linear2dB(this.getReceivedPowerWatt() / this.getTotalInterference()));
        return this.getSINRAchieved();
    }

    protected OfdmaUplink[] generateLinksArray() {
        return new OfdmaUplink[this.getSystem().getNumberOfBaseStations()];
    }

    @Override
    public double getFrequency() {
        if (this.servingLink == null) {
            return this.getSystem().getFrequency();
        }
        if (this.system.getOFDMASettings().getUpLinkSettings().isUseNumberOfActiveMsPerBs()) {
            return ((OfdmaUplink)this.servingLink).calculateFrequency();
        }
        return this.system.calculateFrequency(this.getLinkIndex());
    }
}

