/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.persistence.impl;

import java.util.ArrayList;
import java.util.List;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.functions.BlockingMask;
import org.seamcat.model.functions.Function;
import org.seamcat.model.functions.IntermodulationRejectionMask;
import org.seamcat.model.functions.MaskFunction;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.types.Description;
import org.seamcat.model.types.result.DescriptionImpl;
import org.seamcat.persistence.Marshaller;
import org.seamcat.persistence.Processor;
import org.seamcat.persistence.UnMarshaller;

public class FunctionMarshaller {
    public static void marshall(Marshaller marshaller, BlockingMask model, boolean inList) {
        if (!inList) {
            marshaller.beginElement("blockingMask");
        }
        marshaller.attribute("reference", model.description().name());
        marshaller.attribute("description", model.description().description());
        marshaller.beginElement("function");
        FunctionMarshaller.marshall(marshaller, model.getFunction());
        marshaller.endElement("function");
        if (!inList) {
            marshaller.endElement("blockingMask");
        }
    }

    public static void marshall(Marshaller marshaller, IntermodulationRejectionMask model) {
        marshaller.attribute("reference", model.description().name());
        marshaller.attribute("description", model.description().description());
        marshaller.beginElement("function");
        FunctionMarshaller.marshall(marshaller, model.getFunction());
        marshaller.endElement("function");
    }

    public static void marshall(Marshaller marshaller, Function function) {
        if (function.isConstant()) {
            marshaller.beginElement("ConstantFunction");
            marshaller.attribute("value", Double.toString(function.getConstant()));
            marshaller.endElement("ConstantFunction");
        } else {
            marshaller.beginElement("discretefunction");
            for (Point2D p : function.getPoints()) {
                marshaller.beginElement("point2d");
                marshaller.attribute("x", String.valueOf(p.getX()));
                marshaller.attribute("y", String.valueOf(p.getY()));
                marshaller.endElement("point2d");
            }
            marshaller.endElement("discretefunction");
        }
    }

    public static void marshall(Marshaller marshaller, MaskFunction mask) {
        List<Point2D> points = mask.getPoints();
        for (Point2D point : points) {
            marshaller.beginElement("point3d");
            marshaller.attribute("x", Double.toString(point.getX()));
            marshaller.attribute("y", Double.toString(point.getY()));
            marshaller.attribute("z", Double.toString(mask.getMask(point)));
            marshaller.endElement("point3d");
        }
    }

    public static Function unMarshallFunction(final UnMarshaller unMarshaller) {
        boolean fElement = unMarshaller.peekNextElement("function");
        if (fElement) {
            unMarshaller.checkBeginElement("function");
        }
        Function function = null;
        if (unMarshaller.peekNextElement("ConstantFunction")) {
            unMarshaller.checkBeginElement("ConstantFunction");
            double constantValue = Double.parseDouble(unMarshaller.attribute("value"));
            function = Factory.functionFactory().constantFunction(constantValue);
            unMarshaller.checkEndElement("ConstantFunction");
        } else if (unMarshaller.peekNextElement("discretefunction")) {
            unMarshaller.checkBeginElement("discretefunction");
            final ArrayList<Point2D> _points = new ArrayList<Point2D>();
            unMarshaller.processSequence("point2d", new Processor(){

                @Override
                public void process() {
                    _points.add(FunctionMarshaller.point(unMarshaller));
                }
            });
            unMarshaller.checkEndElement("discretefunction");
            function = Factory.functionFactory().discreteFunction(_points);
        }
        if (fElement) {
            unMarshaller.checkEndElement("function");
        }
        if (function == null) {
            throw new RuntimeException("Cound not find function");
        }
        return function;
    }

    public static MaskFunction unMarshall(final UnMarshaller unMarshaller) {
        boolean withDiscreteElement = false;
        if (unMarshaller.peekNextElement("discretefunction")) {
            unMarshaller.checkBeginElement("discretefunction");
            withDiscreteElement = true;
        }
        final ArrayList<Point2D> points = new ArrayList<Point2D>();
        final ArrayList<Double> mask = new ArrayList<Double>();
        unMarshaller.processSequence("point3d", new Processor(){

            @Override
            public void process() {
                double xv = Double.parseDouble(unMarshaller.attribute("x"));
                double yv = Double.parseDouble(unMarshaller.attribute("y"));
                double zv = Double.parseDouble(unMarshaller.attribute("z"));
                points.add(new Point2D(xv, yv));
                mask.add(zv);
            }
        });
        if (withDiscreteElement) {
            unMarshaller.checkEndElement("discretefunction");
        }
        return Factory.functionFactory().maskFunction(points, mask);
    }

    public static BlockingMask unMarshallBlockingMask(UnMarshaller unMarshaller) {
        String reference = unMarshaller.attribute("reference");
        String description = unMarshaller.attribute("description");
        Function f = FunctionMarshaller.unMarshallFunction(unMarshaller);
        DescriptionImpl desc = new DescriptionImpl(reference, description);
        if (f.isConstant()) {
            return Factory.functionFactory().blockingMask(f.getConstant(), (Description)desc);
        }
        return Factory.functionFactory().blockingMask(f.getPoints(), (Description)desc);
    }

    public static Function copy(Function function) {
        if (function == null) {
            return null;
        }
        if (function.isConstant()) {
            return Factory.functionFactory().constantFunction(function.getConstant());
        }
        ArrayList<Point2D> points = new ArrayList<Point2D>();
        for (Point2D point : function.getPoints()) {
            points.add(point);
        }
        return Factory.functionFactory().discreteFunction(points);
    }

    public static Point2D point(UnMarshaller unMarshaller) {
        double x = Double.parseDouble(unMarshaller.attribute("x"));
        double y = Double.parseDouble(unMarshaller.attribute("y"));
        return new Point2D(x, y);
    }
}

