/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.persistence.impl;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import org.seamcat.persistence.Processor;
import org.seamcat.persistence.UnMarshaller;
import org.seamcat.persistence.impl.AttributeAccessor;
import org.seamcat.persistence.impl.ElementProcessor;
import org.seamcat.persistence.impl.UnmarshallingException;
import org.seamcat.persistence.impl.XmlEventStream;

public class UnMarshallerStream
implements UnMarshaller {
    private XmlEventStream stream;
    private AttributeAccessor accessor;

    public UnMarshallerStream(XmlEventStream stream) {
        this.stream = stream;
    }

    @Override
    public void checkBeginElement(String name) {
        try {
            StartElement startElement = this.stream.checkAndSkipStartElement(name);
            this.accessor = new AttributeAccessor(startElement);
        }
        catch (XMLStreamException e) {
            throw new UnmarshallingException(e);
        }
    }

    @Override
    public String attribute(String name) {
        if (this.accessor != null) {
            return this.accessor.value(name);
        }
        throw new RuntimeException("Outside element. Can't read attribute: " + name);
    }

    @Override
    public void checkEndElement(String name) {
        try {
            this.stream.checkAndSkipEndElement(name);
            this.accessor = null;
        }
        catch (XMLStreamException e) {
            throw new UnmarshallingException(e);
        }
    }

    @Override
    public void processSequence(final String name, final Processor processor) {
        try {
            this.stream.processElementSequence(name, new ElementProcessor(){

                @Override
                public void process(XmlEventStream eventStream) throws XMLStreamException {
                    UnMarshallerStream.this.checkBeginElement(name);
                    processor.process();
                    UnMarshallerStream.this.checkEndElement(name);
                }
            });
        }
        catch (XMLStreamException e) {
            throw new UnmarshallingException(e);
        }
    }

    @Override
    public void processOptionalWrappedElementSequence(String containerName, final String childName, final Processor processor) {
        try {
            this.stream.processOptionalWrappedElementSequence(containerName, childName, new ElementProcessor(){

                @Override
                public void process(XmlEventStream eventStream) throws XMLStreamException {
                    UnMarshallerStream.this.checkBeginElement(childName);
                    processor.process();
                    UnMarshallerStream.this.checkEndElement(childName);
                }
            });
        }
        catch (XMLStreamException e) {
            throw new UnmarshallingException(e);
        }
    }

    @Override
    public void processWrappedElementSequence(String containerName, final String childName, final Processor processor) {
        try {
            this.stream.processWrappedElementSequence(containerName, childName, new ElementProcessor(){

                @Override
                public void process(XmlEventStream eventStream) throws XMLStreamException {
                    UnMarshallerStream.this.checkBeginElement(childName);
                    processor.process();
                    UnMarshallerStream.this.checkEndElement(childName);
                }
            });
        }
        catch (XMLStreamException e) {
            throw new UnmarshallingException(e);
        }
    }

    @Override
    public void processOptionalElement(final String name, final Processor processor) {
        try {
            this.stream.processOptionalElement(name, new ElementProcessor(){

                @Override
                public void process(XmlEventStream eventStream) throws XMLStreamException {
                    UnMarshallerStream.this.checkBeginElement(name);
                    processor.process();
                    UnMarshallerStream.this.checkEndElement(name);
                }
            });
        }
        catch (XMLStreamException e) {
            throw new UnmarshallingException(e);
        }
    }

    @Override
    public boolean peekNextElement(String name) {
        try {
            return this.stream.peekNextElement(name);
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public void consumeUntilEndElement(String name) {
        try {
            this.stream.consumeUntilEndElement(name);
        }
        catch (XMLStreamException e) {
            throw new UnmarshallingException(e);
        }
    }

    @Override
    public void cancel() {
        this.stream.cancel();
    }

    @Override
    public void close() {
        this.stream.close();
    }
}

