/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.persistence.impl;

import java.util.Stack;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.seamcat.persistence.impl.ElementProcessor;

public class XmlEventStream {
    XMLEventReader eventReader;
    private boolean cancelled = false;

    public XmlEventStream(XMLEventReader eventReader) {
        this.eventReader = eventReader;
    }

    public StartElement checkAndSkipStartElement(String elementName) throws XMLStreamException {
        this.skipNonElementEvents();
        XMLEvent event = this.eventReader.peek();
        if (event != null && event.isStartElement() && event.asStartElement().getName().getLocalPart().equals(elementName)) {
            this.eventReader.nextEvent();
            return event.asStartElement();
        }
        throw new XMLStreamException("Expected start element: " + elementName + ", but found " + event, event.getLocation());
    }

    public void consumeUntilEndElement(String name) throws XMLStreamException {
        Stack<String> elements = new Stack<String>();
        while (true) {
            this.skipNonElementEvents();
            XMLEvent event = this.eventReader.peek();
            if (event == null) {
                return;
            }
            if (event.isEndElement()) {
                if (elements.isEmpty()) {
                    if (!event.asEndElement().getName().getLocalPart().equals(name)) continue;
                    return;
                }
                this.checkAndSkipEndElement((String)elements.pop());
                continue;
            }
            if (!event.isStartElement()) continue;
            elements.push(event.asStartElement().getName().getLocalPart());
            this.eventReader.nextEvent();
        }
    }

    public EndElement checkAndSkipEndElement(String elementName) throws XMLStreamException {
        this.skipNonElementEvents();
        XMLEvent event = this.eventReader.peek();
        if (event != null && event.isEndElement() && event.asEndElement().getName().getLocalPart().equals(elementName)) {
            this.eventReader.nextEvent();
            return event.asEndElement();
        }
        throw new XMLStreamException("Expected end element: " + elementName + ", but found " + event, event.getLocation());
    }

    public void processElementSequence(String childElementName, ElementProcessor processor) throws XMLStreamException {
        this.skipNonElementEvents();
        XMLEvent event = this.eventReader.peek();
        while (event != null && event.isStartElement() && event.asStartElement().getName().getLocalPart().equals(childElementName)) {
            this.cancelCheck();
            processor.process(this);
            this.skipNonElementEvents();
            event = this.eventReader.peek();
        }
    }

    private void skipNonElementEvents() throws XMLStreamException {
        while (this.eventReader.hasNext() && !this.eventReader.peek().isStartElement() && !this.eventReader.peek().isEndElement()) {
            this.eventReader.nextEvent();
        }
    }

    public void processOptionalWrappedElementSequence(String containerElementName, String childElementName, ElementProcessor processor) throws XMLStreamException {
        if (this.peekNextElement(containerElementName)) {
            this.checkAndSkipStartElement(containerElementName);
            this.processElementSequence(childElementName, processor);
            this.checkAndSkipEndElement(containerElementName);
        }
    }

    public void processWrappedElementSequence(String containerElementName, String childElementName, ElementProcessor processor) throws XMLStreamException {
        this.checkAndSkipStartElement(containerElementName);
        this.processElementSequence(childElementName, processor);
        this.checkAndSkipEndElement(containerElementName);
    }

    public void processOptionalElement(String elementName, ElementProcessor processor) throws XMLStreamException {
        this.skipNonElementEvents();
        XMLEvent event = this.eventReader.peek();
        if (event != null && event.isStartElement() && event.asStartElement().getName().getLocalPart().equals(elementName)) {
            processor.process(this);
        }
    }

    public void close() {
        try {
            this.eventReader.close();
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    public void cancel() {
        this.cancelled = true;
    }

    private void cancelCheck() {
        if (this.cancelled) {
            throw new Cancelled();
        }
    }

    public boolean peekNextElement(String name) throws XMLStreamException {
        this.skipNonElementEvents();
        XMLEvent event = this.eventReader.peek();
        return event != null && event.isStartElement() && event.asStartElement().getName().getLocalPart().equals(name);
    }

    public class Cancelled
    extends RuntimeException {
    }
}

