/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.plugin;

import org.seamcat.exception.SimulationInvalidException;
import org.seamcat.model.MutableLibraryItem;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.plugin.Plugin;
import org.seamcat.model.plugin.antenna.AntennaGainPlugin;
import org.seamcat.model.plugin.system.ConsistencyCheckContext;
import org.seamcat.model.simulation.consistency.ValidationResult;
import org.seamcat.model.simulation.result.AntennaResult;
import org.seamcat.model.simulation.result.LinkResult;
import org.seamcat.model.types.AntennaGain;
import org.seamcat.model.types.Configuration;
import org.seamcat.plugin.Locker;
import org.seamcat.plugin.PluginCheckUtil;

public class AntennaGainConfiguration<T>
extends MutableLibraryItem
implements AntennaGain<T> {
    private final Configuration<AntennaGainPlugin<T>, T> configuration;
    private double peakGain;
    private String notes;
    private double azimuthOffset = 0.0;

    AntennaGainConfiguration(Configuration<AntennaGainPlugin<T>, T> configuration) {
        this.configuration = configuration;
        this.peakGain = configuration.optionalProperty("peakGain", 0.0);
        this.setDescription(configuration.description());
        this.notes = "";
    }

    @Override
    public Plugin<T> getPlugin() {
        return this.configuration.getPlugin();
    }

    @Override
    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    @Override
    public T getModel() {
        return this.configuration.getModel();
    }

    @Override
    public Class<T> getModelClass() {
        return this.configuration.getModelClass();
    }

    @Override
    public Class<? extends AntennaGainPlugin<T>> getPluginClass() {
        return this.configuration.getPluginClass();
    }

    @Override
    public ValidationResult consistencyCheck(ConsistencyCheckContext context) {
        return PluginCheckUtil.check(context, this.getPlugin(), this.getModel());
    }

    public AntennaGainConfiguration<T> copy() {
        return (AntennaGainConfiguration)Factory.antennaGainFactory().getByClass(this.getPluginClass(), this.getModel(), this.peakGain, this.description().name(), this.notes);
    }

    @Override
    public <T1> T1 optionalProperty(String name, T1 defaultValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double evaluate(LinkResult context, AntennaResult directionResult) {
        double originalAzimuth = directionResult.getAzimuth();
        double originalElevation = directionResult.getElevation();
        double translated = originalAzimuth - this.azimuthOffset;
        if (translated < 0.0) {
            translated += 360.0;
        }
        if (translated > 360.0) {
            translated -= 360.0;
        }
        directionResult.setAzimuth(translated);
        Locker locker = new Locker(directionResult);
        try {
            double d = this.configuration.getPlugin().evaluate(context, directionResult, this.peakGain(), this.getModel());
            return d;
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw new SimulationInvalidException("Antenna gain " + this.getPlugin().description().name() + " failed.", e);
        }
        finally {
            locker.unlock();
            directionResult.setAzimuth(originalAzimuth);
            directionResult.setElevation(originalElevation);
        }
    }

    @Override
    public double peakGain() {
        return this.peakGain;
    }

    public AntennaGainConfiguration<T> setPeakGain(double peakGain) {
        this.peakGain = peakGain;
        return this;
    }

    void setAzimuthOffset(double azimuthOffset) {
        this.azimuthOffset = azimuthOffset;
    }
}

