/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.plugin;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.seamcat.model.plugin.Plugin;
import org.seamcat.model.plugin.system.SystemPlugin;
import org.seamcat.plugin.JarConfigurationModel;
import org.seamcat.plugin.JarFiles;
import org.seamcat.plugin.PluginClass;

public class BuiltInPlugins
extends JarConfigurationModel {
    public static final String BUILTIN = "BUILT-IN";
    private Map<String, PluginClass> builtInPluginClasses = new LinkedHashMap<String, PluginClass>();
    private Map<String, Class<? extends SystemPlugin>> builtInSystemPluginClasses = new LinkedHashMap<String, Class<? extends SystemPlugin>>();

    public static void initialize(List<Class<? extends Plugin>> builtInPlugins, List<Class<? extends SystemPlugin>> builtInSystemPlugins) {
        JarFiles.addJarConfiguration(new BuiltInPlugins(builtInPlugins, builtInSystemPlugins));
    }

    private void put(Class clazz) {
        this.builtInPluginClasses.put(clazz.getName(), new PluginClass(clazz));
    }

    private BuiltInPlugins(List<Class<? extends Plugin>> builtInPlugins, List<Class<? extends SystemPlugin>> builtInSystemPlugins) {
        this.setHash(BUILTIN);
        for (Class<? extends Plugin> clazz : builtInPlugins) {
            this.put(clazz);
        }
        for (Class<Object> clazz : builtInSystemPlugins) {
            this.builtInSystemPluginClasses.put(clazz.getName(), clazz);
        }
    }

    @Override
    public List<PluginClass> getPluginClasses() {
        return new ArrayList<PluginClass>(this.builtInPluginClasses.values());
    }

    @Override
    public List<Class<? extends SystemPlugin>> getSystemPlugins() {
        return new ArrayList<Class<? extends SystemPlugin>>(this.builtInSystemPluginClasses.values());
    }

    @Override
    public PluginClass getPluginClass(String classname) {
        return this.builtInPluginClasses.get(classname);
    }

    @Override
    public Class<? extends SystemPlugin> getSystemPluginClass(String classname) {
        return this.builtInSystemPluginClasses.get(classname);
    }

    @Override
    public Class<?> loadClass(String classname) {
        try {
            return Class.forName(classname);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Could not load class: " + classname, e);
        }
    }

    public String toString() {
        return BUILTIN;
    }
}

