/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.plugin;

import java.lang.reflect.ParameterizedType;
import java.util.Map;
import org.seamcat.model.factory.DefaultValueCache;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.plugin.Plugin;
import org.seamcat.model.plugin.system.ConsistencyCheckContext;
import org.seamcat.model.simulation.consistency.ValidationResult;
import org.seamcat.model.types.Configuration;
import org.seamcat.model.types.Description;
import org.seamcat.model.types.result.DescriptionImpl;

public class ConfigurationImpl<P extends Plugin<Model>, Model>
implements Configuration<Plugin<Model>, Model> {
    private P plugin;
    private Class<? extends P> pluginClass;
    private Model model;
    private Class<Model> clazz;
    private Description description;
    private String notes;

    public ConfigurationImpl(Class<? extends P> pluginClass, Model model) {
        this.plugin = (Plugin)ConfigurationImpl.classInstance(pluginClass);
        this.pluginClass = pluginClass;
        this.description = this.plugin.description();
        if (this.description == null) {
            this.description = new DescriptionImpl("No description", "");
        }
        this.clazz = (Class)((ParameterizedType)pluginClass.getGenericInterfaces()[0]).getActualTypeArguments()[0];
        this.model = model == null ? Factory.instance(this.clazz) : model;
        this.notes = "";
    }

    @Override
    public Plugin<Model> getPlugin() {
        return this.plugin;
    }

    @Override
    public String getNotes() {
        return this.notes;
    }

    @Override
    public Model getModel() {
        return this.model;
    }

    @Override
    public Class<Model> getModelClass() {
        return this.clazz;
    }

    @Override
    public Class<? extends Plugin<Model>> getPluginClass() {
        return this.pluginClass;
    }

    @Override
    public ValidationResult consistencyCheck(ConsistencyCheckContext context) {
        throw new RuntimeException("No implementation in raw configuration");
    }

    @Override
    public Configuration<Plugin<Model>, Model> copy() {
        return null;
    }

    @Override
    public <T> T optionalProperty(String name, T defaultValue) {
        Map<String, Object> values = DefaultValueCache.optionalProperty(this.clazz);
        if (values != null && values.containsKey(name)) {
            return (T)values.get(name);
        }
        return defaultValue;
    }

    @Override
    public Description description() {
        return this.description;
    }

    private static <T> T classInstance(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Error instantiating plugin", e);
        }
    }
}

