/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.plugin;

import java.util.Collections;
import java.util.List;
import org.seamcat.model.MutableLibraryItem;
import org.seamcat.model.Scenario;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.plugin.Plugin;
import org.seamcat.model.plugin.eventprocessing.EventProcessingPlugin;
import org.seamcat.model.plugin.eventprocessing.PostProcessingTab;
import org.seamcat.model.plugin.eventprocessing.PostProcessingUI;
import org.seamcat.model.plugin.system.ConsistencyCheckContext;
import org.seamcat.model.simulation.consistency.ValidationResult;
import org.seamcat.model.simulation.result.Collector;
import org.seamcat.model.simulation.result.EventResult;
import org.seamcat.model.types.Configuration;
import org.seamcat.model.types.EventProcessing;
import org.seamcat.plugin.Locker;
import org.seamcat.plugin.PluginCheckUtil;

public class EventProcessingConfiguration<T>
extends MutableLibraryItem
implements EventProcessing<T>,
PostProcessingTab {
    private final Configuration<EventProcessingPlugin<T>, T> configuration;
    private String id;
    private String notes;

    EventProcessingConfiguration(Configuration<EventProcessingPlugin<T>, T> configuration) {
        this.configuration = configuration;
        this.setDescription(configuration.description());
        this.notes = "";
    }

    public EventProcessingConfiguration<T> copy() {
        return (EventProcessingConfiguration)Factory.eventProcessors().getByClass(this.getPluginClass(), this.getModel(), this.id, this.description().name(), this.notes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void evaluate(Scenario scenario, EventResult result, Collector collector) {
        Locker locker = new Locker(result);
        try {
            this.getPlugin().evaluate(scenario, result, this.getModel(), collector);
        }
        finally {
            locker.unlock();
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public EventProcessingPlugin<T> getPlugin() {
        return this.configuration.getPlugin();
    }

    @Override
    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    @Override
    public T getModel() {
        return this.configuration.getModel();
    }

    @Override
    public Class<T> getModelClass() {
        return this.configuration.getModelClass();
    }

    @Override
    public Class<? extends EventProcessingPlugin<T>> getPluginClass() {
        return this.configuration.getPluginClass();
    }

    @Override
    public ValidationResult consistencyCheck(ConsistencyCheckContext context) {
        return PluginCheckUtil.check(context, this.getPlugin(), this.getModel());
    }

    @Override
    public <T1> T1 optionalProperty(String name, T1 defaultValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Class<? extends PostProcessingUI>> tabs() {
        Plugin plugin = this.getPlugin();
        if (plugin instanceof PostProcessingTab) {
            try {
                List<Class<? extends PostProcessingUI>> tabs = ((PostProcessingTab)((Object)plugin)).tabs();
                if (tabs != null) {
                    return tabs;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Collections.emptyList();
    }
}

