/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.plugin;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.log4j.Logger;
import org.seamcat.model.plugin.Plugin;
import org.seamcat.model.plugin.system.SystemPlugin;
import org.seamcat.model.types.Description;
import org.seamcat.model.types.LibraryItem;
import org.seamcat.model.types.result.DescriptionImpl;
import org.seamcat.plugin.PluginClass;
import org.seamcat.plugin.PluginClassLoader;
import org.seamcat.plugin.PluginSerializerUtil;

public class JarConfigurationModel
implements LibraryItem {
    private static final Logger LOG = Logger.getLogger(JarConfigurationModel.class);
    private String hash;
    private String jarData;
    private String name;
    private List<PluginClass> pluginClasses = new ArrayList<PluginClass>();
    private List<Class<? extends SystemPlugin>> systemPlugins = new ArrayList<Class<? extends SystemPlugin>>();
    private PluginClassLoader classLoader;

    protected JarConfigurationModel() {
    }

    public JarConfigurationModel(File jarFile) {
        this.name = jarFile.getName();
        try {
            this.setJarData(PluginSerializerUtil.serializeJarFile(jarFile));
            this.classLoader = new PluginClassLoader(jarFile);
            this.installPluginClasses(jarFile);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not install jar file", e);
        }
    }

    public JarConfigurationModel(String base64JarData, String name) {
        this.setJarData(base64JarData);
        this.name = name;
        try {
            File jarFile = PluginSerializerUtil.deserializeJarFile(base64JarData, this.getHash());
            this.classLoader = new PluginClassLoader(jarFile);
            this.installPluginClasses(jarFile);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not install jar file", e);
        }
    }

    private void installPluginClasses(File jarFile) {
        try {
            JarFile jarFileHandle = new JarFile(jarFile);
            Enumeration<JarEntry> list = jarFileHandle.entries();
            while (list.hasMoreElements()) {
                JarEntry f = list.nextElement();
                String name = f.getName();
                if (!name.endsWith(".class")) continue;
                try {
                    Class<?> aClass = this.loadClassDef(name.substring(0, name.length() - ".class".length()).replaceAll("/", "."));
                    if (SystemPlugin.class.isAssignableFrom(aClass)) {
                        this.systemPlugins.add(aClass);
                        continue;
                    }
                    if (!Plugin.class.isAssignableFrom(aClass)) continue;
                    this.pluginClasses.add(new PluginClass(aClass));
                }
                catch (RuntimeException aClass) {
                }
                catch (NoClassDefFoundError e) {
                    LOG.info("Error loading class '" + name + "'. Will be skipped");
                }
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public String getName() {
        return this.name;
    }

    private Class<?> loadClassDef(String classname) {
        Class<?> c;
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Loading plugin class: %s", classname));
        }
        try {
            c = this.classLoader.verifySandboxAndLoadClass(classname);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(String.format("Error encountered while reading plugin definition (%s). It will be skipped", e.getMessage()));
        }
        catch (UnsupportedClassVersionError e) {
            String version = System.getProperty("java.version");
            String message = String.format("Could not load class: '%s'. SEAMCAT is running java version %s and the plugin is most likely built with a newer java version", classname, version);
            throw new RuntimeException(message);
        }
        return c;
    }

    public PluginClass getPluginClass(String classname) {
        for (PluginClass pc : this.pluginClasses) {
            if (!pc.getClassName().equals(classname)) continue;
            return pc;
        }
        throw new RuntimeException("no such class in jar file " + classname);
    }

    public Class<? extends SystemPlugin> getSystemPluginClass(String classname) {
        for (Class<? extends SystemPlugin> sc : this.systemPlugins) {
            if (!sc.getName().equals(classname)) continue;
            return sc;
        }
        throw new RuntimeException("no such class in jar file " + classname);
    }

    public Class<?> loadClass(String classname) {
        return this.loadClassDef(classname);
    }

    public String getJarData() {
        return this.jarData;
    }

    private void setJarData(String jarData) {
        this.jarData = jarData;
        this.hash = DigestUtils.md5Hex(jarData);
    }

    void setHash(String hash) {
        this.hash = hash;
    }

    public boolean hasPlugins() {
        return !this.pluginClasses.isEmpty() || !this.systemPlugins.isEmpty();
    }

    public List<PluginClass> getPluginClasses() {
        return this.pluginClasses;
    }

    public List<Class<? extends SystemPlugin>> getSystemPlugins() {
        return this.systemPlugins;
    }

    public String getHash() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof JarConfigurationModel)) {
            return false;
        }
        JarConfigurationModel other = (JarConfigurationModel)obj;
        return this.hash.equals(other.hash);
    }

    @Override
    public Description description() {
        return new DescriptionImpl(this.name, "");
    }
}

