/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.plugin;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.seamcat.model.factory.ProxyHelper;
import org.seamcat.model.plugin.system.SystemPlugin;
import org.seamcat.model.types.Configuration;
import org.seamcat.model.types.SystemPluginConfiguration;
import org.seamcat.plugin.JarConfigurationModel;
import org.seamcat.plugin.PluginClass;

public class JarFiles {
    private static final Map<String, JarConfigurationModel> pluginJarFiles = new LinkedHashMap<String, JarConfigurationModel>();
    private static final Map<Class, String> locations = new HashMap<Class, String>();

    public static void addJarConfiguration(JarConfigurationModel model) {
        if (!pluginJarFiles.values().contains(model)) {
            pluginJarFiles.put(model.getHash(), model);
            ProxyHelper.initialize(model);
            for (PluginClass pluginClass : model.getPluginClasses()) {
                locations.put(pluginClass.getPluginClass(), model.getHash());
            }
            for (Class clazz : model.getSystemPlugins()) {
                locations.put(clazz, model.getHash());
            }
        }
    }

    public static JarConfigurationModel getJarConfiguration(String id) {
        return pluginJarFiles.get(id);
    }

    public static boolean isBuiltIn(Configuration configuration) {
        return "BUILT-IN".equals(locations.get(configuration.getPluginClass()));
    }

    public static boolean isBuiltIn(SystemPlugin plugin) {
        return "BUILT-IN".equals(locations.get(plugin.getClass()));
    }

    public static String getJarId(Configuration configuration) {
        return locations.get(configuration.getPluginClass());
    }

    public static String getJarId(SystemPlugin plugin) {
        return locations.get(plugin.getClass());
    }

    public static JarConfigurationModel getJar(SystemPlugin plugin) {
        return JarFiles.getJarConfiguration(JarFiles.getJarId(plugin));
    }

    public static JarConfigurationModel getJar(Configuration configuration) {
        return JarFiles.getJarConfiguration(JarFiles.getJarId(configuration));
    }

    public static SystemPlugin instance(SystemPluginConfiguration configuration) {
        Class<? extends SystemPlugin> aClass = JarFiles.getClassForConfiguration(configuration);
        try {
            SystemPlugin plugin = aClass.newInstance();
            plugin.setUI(configuration.configuration());
            return ProxyHelper.cloneSystemPlugin(plugin);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Class<? extends SystemPlugin> getClassForConfiguration(SystemPluginConfiguration configuration) {
        JarConfigurationModel jar = JarFiles.getJarConfiguration(configuration.location());
        Class<? extends SystemPlugin> aClass = jar.getSystemPluginClass(configuration.classname());
        return aClass;
    }
}

