/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.plugin;

import java.lang.reflect.ParameterizedType;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.plugin.Plugin;
import org.seamcat.model.plugin.antenna.AntennaGainPlugin;
import org.seamcat.model.plugin.coverageradius.CoverageRadiusPlugin;
import org.seamcat.model.plugin.eventprocessing.EventProcessingPlugin;
import org.seamcat.model.plugin.propagation.PropagationModelPlugin;
import org.seamcat.model.types.Configuration;

public class PluginClass {
    private Class<? extends Plugin<?>> clazz;

    PluginClass(Class<?> clazz) {
        if (!(EventProcessingPlugin.class.isAssignableFrom(clazz) || PropagationModelPlugin.class.isAssignableFrom(clazz) || AntennaGainPlugin.class.isAssignableFrom(clazz) || CoverageRadiusPlugin.class.isAssignableFrom(clazz))) {
            throw new RuntimeException("Not a plugin type");
        }
        this.clazz = clazz;
    }

    public Configuration configuration() {
        if (EventProcessingPlugin.class.isAssignableFrom(this.clazz)) {
            return Factory.eventProcessors().getByClass(this.clazz);
        }
        if (PropagationModelPlugin.class.isAssignableFrom(this.clazz)) {
            return Factory.propagationModelFactory().getByClass(this.clazz);
        }
        if (AntennaGainPlugin.class.isAssignableFrom(this.clazz)) {
            return Factory.antennaGainFactory().getByClass(this.clazz);
        }
        if (CoverageRadiusPlugin.class.isAssignableFrom(this.clazz)) {
            return Factory.coverageRadii().getByClass(this.clazz);
        }
        throw new RuntimeException("Error: unknown type");
    }

    public String getClassName() {
        return this.clazz.getName();
    }

    public Class<? extends Plugin<?>> getPluginClass() {
        return this.clazz;
    }

    public Class<?> getModelClass() {
        try {
            Plugin<?> plugin = this.clazz.newInstance();
            return (Class)((ParameterizedType)plugin.getClass().getGenericInterfaces()[0]).getActualTypeArguments()[0];
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

