/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.plugin;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.bind.DatatypeConverter;
import org.apache.log4j.Logger;

public class PluginSerializerUtil {
    private static final Logger LOG = Logger.getLogger(PluginSerializerUtil.class);
    public static String jarFileSerializerDir;

    static String serializeJarFile(File jarFile) throws IOException {
        if (jarFile.exists()) {
            if (jarFile.canRead()) {
                BufferedInputStream iStream = new BufferedInputStream(new FileInputStream(jarFile));
                byte[] bytes = new byte[((InputStream)iStream).available()];
                ((InputStream)iStream).read(bytes);
                ((InputStream)iStream).close();
                return DatatypeConverter.printBase64Binary((byte[])bytes);
            }
            throw new IOException(String.format("Cannot read jar-file: %s", jarFile.getName()));
        }
        throw new FileNotFoundException(jarFile.getName());
    }

    static File deserializeJarFile(String jarData, String hash) throws IOException {
        File jarFile = new File(jarFileSerializerDir + File.separator + hash + ".jar");
        if (jarFile.exists()) {
            return jarFile;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("De-serialising  pluginfile: %s", jarFile.getPath()));
        }
        BufferedOutputStream oStream = new BufferedOutputStream(new FileOutputStream(jarFile, false));
        ((OutputStream)oStream).write(DatatypeConverter.parseBase64Binary((String)jarData));
        ((OutputStream)oStream).flush();
        ((OutputStream)oStream).close();
        if (LOG.isDebugEnabled()) {
            LOG.debug("JarFile de-serialised and installed in classpath");
        }
        return jarFile;
    }
}

