/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.plugin;

import java.io.FilePermission;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.util.PropertyPermission;
import org.apache.log4j.Logger;
import org.seamcat.plugin.PluginClassLoader;

class SandboxSecurityPolicy
extends Policy {
    private static final Logger logger = Logger.getLogger(SandboxSecurityPolicy.class);

    SandboxSecurityPolicy() {
    }

    @Override
    public PermissionCollection getPermissions(CodeSource codesource) {
        throw new UnsupportedOperationException();
    }

    @Override
    public PermissionCollection getPermissions(ProtectionDomain domain) {
        if (this.isPlugin(domain)) {
            logger.debug("Plugin permissions for: " + domain.getCodeSource());
            return this.pluginPermissions();
        }
        logger.debug("Application permissions for: " + domain.getCodeSource());
        return this.applicationPermissions();
    }

    private boolean isPlugin(ProtectionDomain domain) {
        return domain.getClassLoader() instanceof PluginClassLoader;
    }

    private PermissionCollection pluginPermissions() {
        Permissions permissions = new Permissions();
        permissions.add(new PropertyPermission("*", "read"));
        permissions.add(new FilePermission("<<ALL FILES>>", "read"));
        permissions.add(new RuntimePermission("preferences"));
        return permissions;
    }

    private PermissionCollection applicationPermissions() {
        Permissions permissions = new Permissions();
        permissions.add(new AllPermission());
        return permissions;
    }
}

