/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.seamcat.function.DiscreteFunction;
import org.seamcat.help.SeamcatHelpResolver;
import org.seamcat.model.functions.Function;
import org.seamcat.model.types.Description;
import org.seamcat.presentation.EscapeDialog;
import org.seamcat.presentation.MainWindow;
import org.seamcat.presentation.components.DiscreteFunctionPanel;
import org.seamcat.presentation.components.NavigateButtonPanel;
import org.seamcat.presentation.genericgui.panelbuilder.GenericPanelEditor;

public class DialogLibraryFunctionDefine
extends EscapeDialog {
    private JPanel idPanelContainer = new JPanel(new BorderLayout());
    private GenericPanelEditor<Description> idPanel;
    private DiscreteFunctionPanel userDefinitionPanel;

    public DialogLibraryFunctionDefine(JFrame parent, boolean modal, String xUnit, String yUnit) {
        super((Frame)parent, modal);
        this.userDefinitionPanel = new DiscreteFunctionPanel(xUnit, yUnit);
        this.init();
        this.setLocationRelativeTo(parent);
    }

    public boolean show(Function function, Description description, String windowtitle) {
        this.idPanel = new GenericPanelEditor<Description>(MainWindow.getInstance(), Description.class, description);
        this.idPanelContainer.add(this.idPanel, "Center");
        this.userDefinitionPanel.setModel((DiscreteFunction)function);
        this.setTitle(windowtitle);
        this.setAccept(false);
        this.setVisible(true);
        return this.isAccept();
    }

    public Function getFunction() {
        return this.userDefinitionPanel.getModel();
    }

    public Description getDescription() {
        return this.idPanel.getModel();
    }

    private void init() {
        this.setSize(new Dimension(700, 450));
        this.getContentPane().add((Component)this.idPanelContainer, "North");
        this.getContentPane().add((Component)this.userDefinitionPanel, "Center");
        this.getContentPane().add((Component)new NavigateButtonPanel(this), "South");
        this.registerHelp();
    }

    private void registerHelp() {
        KeyStroke stroke = KeyStroke.getKeyStroke(112, 0);
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SeamcatHelpResolver.showHelp(DialogLibraryFunctionDefine.this);
            }
        }, stroke, 2);
    }
}

