/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JDialog;
import javax.swing.KeyStroke;
import org.seamcat.function.MaskFunctionImpl;
import org.seamcat.help.SeamcatHelpResolver;
import org.seamcat.model.functions.MaskFunction;
import org.seamcat.presentation.EscapeDialog;
import org.seamcat.presentation.components.DiscreteFunction2Panel;
import org.seamcat.presentation.components.NavigateButtonPanel;

public class DialogMaskFunctionDefine
extends EscapeDialog {
    private DiscreteFunction2Panel userDefinitionPanel = new DiscreteFunction2Panel();

    public DialogMaskFunctionDefine(Frame parent, boolean modal) {
        super(parent, modal);
        this.init();
        this.setLocationRelativeTo(parent);
    }

    public DialogMaskFunctionDefine(JDialog parent, boolean modal) {
        super(parent, modal);
        this.init();
        this.setLocationRelativeTo(parent);
    }

    public MaskFunction getFunction() {
        return this.userDefinitionPanel.getFunctionable();
    }

    private void init() {
        this.setSize(new Dimension(700, 450));
        this.getContentPane().add((Component)this.userDefinitionPanel, "Center");
        this.getContentPane().add((Component)new NavigateButtonPanel(this), "South");
        this.registerHelp();
    }

    private void registerHelp() {
        KeyStroke stroke = KeyStroke.getKeyStroke(112, 0);
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SeamcatHelpResolver.showHelp(DialogMaskFunctionDefine.this);
            }
        }, stroke, 2);
    }

    public boolean show(MaskFunction function) {
        return this.show(function, "Function definition", "X", "Y");
    }

    public boolean show(MaskFunction function, String windowtitle, double victimBandwidth, double frequencyOffset, boolean showACLR, double interfererBandwidth, String xUnit, String yUnit) {
        this.userDefinitionPanel.setVictimCharacteristics(victimBandwidth, frequencyOffset, showACLR, interfererBandwidth);
        this.userDefinitionPanel.setFunctionable((MaskFunctionImpl)function, xUnit, yUnit);
        this.setTitle(windowtitle);
        this.setAccept(false);
        this.setVisible(true);
        this.userDefinitionPanel.stopEditing();
        return this.isAccept();
    }

    public boolean show(MaskFunction unwantedEmissionFloor, String string, String xUnit, String yUnit) {
        return this.show(unwantedEmissionFloor, string, -1.0, -1.0, false, 0.0, xUnit, yUnit);
    }
}

