/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.seamcat.Seamcat;
import org.seamcat.help.SeamcatHelpResolver;
import org.seamcat.model.factory.Model;
import org.seamcat.presentation.EscapeDialog;
import org.seamcat.presentation.LabeledPairLayout;
import org.seamcat.presentation.SeamcatJFileChooser;
import org.seamcat.presentation.components.NavigateButtonPanel;

public final class DialogOptions
extends EscapeDialog {
    private static final ResourceBundle STRINGLIST = ResourceBundle.getBundle("stringlist", Locale.ENGLISH);
    private static final Logger LOG = Logger.getLogger(DialogOptions.class);
    private static final Level[] logLevels = new Level[]{Level.DEBUG, Level.INFO, Level.WARN, Level.ERROR, Level.FATAL, Level.OFF};
    private JFileChooser fc;
    private JTextField filename = new JTextField(25);
    private JButton filenameButton = new JButton(STRINGLIST.getString("BTN_CAPTION_BROWSE"));
    private JPanel filenamePanel = new JPanel(new BorderLayout());
    private JComboBox formats = new JComboBox();
    private JLabel lblFilename = new JLabel(STRINGLIST.getString("DIALOG_OPTIONS_FILENAME"));
    private JLabel lblFormatString = new JLabel(STRINGLIST.getString("DIALOG_OPTIONS_FORMAT"));
    private JLabel lblLogLevel = new JLabel(STRINGLIST.getString("DIALOG_OPTIONS_LOGLEVEL"));
    private JComboBox loglevel = new JComboBox<Level>(logLevels);
    private JComboBox lookAndFeel = new JComboBox();
    private PatternLayout logTestLayout = new PatternLayout();
    private JCheckBox showWelcomeScreen = new JCheckBox(STRINGLIST.getString("DIALOG_OPTIONS_SHOW_WELCOME"));

    public DialogOptions(JFrame owner) {
        super(owner);
        this.fc = new SeamcatJFileChooser(true);
        this.filenamePanel.add((Component)this.filename, "Center");
        this.filenamePanel.add((Component)this.filenameButton, "East");
        this.filename.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                Model.setSeamcatBaseDir(DialogOptions.this.filename.getText());
            }
        });
        this.filenameButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogOptions.this.browseFileActionPerformed();
            }
        });
        DefaultComboBoxModel<String> m = new DefaultComboBoxModel<String>();
        for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
            if (info.getName().equals("Windows Classic") || info.getName().equals("GTK+")) continue;
            m.addElement(info.getName());
        }
        this.lookAndFeel.setModel(m);
        this.lookAndFeel.setSelectedItem(UIManager.getLookAndFeel().getName());
        this.lookAndFeel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UIManager.LookAndFeelInfo selected = null;
                String s = (String)DialogOptions.this.lookAndFeel.getSelectedItem();
                if (s != null) {
                    for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                        if (!s.equals(info.getName())) continue;
                        selected = info;
                        break;
                    }
                }
            }
        });
        this.getContentPane().setLayout(new BorderLayout());
        JPanel options = new JPanel(new LabeledPairLayout());
        options.add("label", this.lblFilename);
        options.add("field", this.filenamePanel);
        options.add("label", new JLabel(""));
        options.add("field", new JLabel("Notice: you need to restart SEAMCAT for a new SEAMCAT home to take effect"));
        options.add("label", this.lblLogLevel);
        options.add("field", this.loglevel);
        options.add("label", this.lblFormatString);
        options.add("field", this.formats);
        options.add("label", new JLabel("Select the Application Look And Feel"));
        options.add("field", this.lookAndFeel);
        options.add("label", new JLabel(""));
        options.add("field", this.showWelcomeScreen);
        options.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)options, "Center");
        this.getContentPane().add((Component)new NavigateButtonPanel(this){

            @Override
            public void btnOkActionPerformed() {
                DialogOptions.this.okButtonActionPerformed();
            }
        }, "South");
        this.setTitle(STRINGLIST.getString("DIALOG_OPTIONS_TITLE"));
        this.loglevel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogOptions.this.logLevelActionPerformed();
            }
        });
        this.formats.setModel(new DefaultComboBoxModel<String>(Model.getInstance().getLogPatterns()));
        this.formats.setEditable(true);
        this.formats.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogOptions.this.formatStringActionPerformed();
            }
        });
        this.setSize(800, 500);
        this.setLocationRelativeTo(owner);
        this.registerHelp();
    }

    private void registerHelp() {
        KeyStroke stroke = KeyStroke.getKeyStroke(112, 0);
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SeamcatHelpResolver.showHelp(this);
            }
        }, stroke, 2);
    }

    private void browseFileActionPerformed() {
        this.fc.setSelectedFile(new File(Model.getSeamcatHomeBaseDir()));
        int returnVal = this.fc.showOpenDialog(this);
        if (returnVal == 0) {
            this.filename.setText(this.fc.getSelectedFile().getAbsolutePath());
            Model.setSeamcatBaseDir(this.fc.getSelectedFile().getAbsolutePath());
        }
    }

    private void formatStringActionPerformed() {
        this.logTestLayout.setConversionPattern(this.formats.getSelectedItem().toString());
    }

    private void logLevelActionPerformed() {
        Logger.getRootLogger().setLevel(Level.INFO);
        Logger.getRootLogger().info("Setting logging level to: " + logLevels[this.loglevel.getSelectedIndex()]);
        Logger.getRootLogger().setLevel(logLevels[this.loglevel.getSelectedIndex()]);
    }

    private void okButtonActionPerformed() {
        Model.getInstance().setShowWelcome(this.showWelcomeScreen.isSelected());
        Preferences pref = Preferences.userNodeForPackage(Seamcat.class);
        pref.put("SEAMCAT_WELCOME", Boolean.toString(this.showWelcomeScreen.isSelected()));
        String s = (String)this.lookAndFeel.getSelectedItem();
        if (s != null) {
            UIManager.LookAndFeelInfo selected = null;
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!s.equals(info.getName())) continue;
                selected = info;
            }
            if (selected != null && !selected.getClassName().equals(UIManager.getLookAndFeel().getClass().getName())) {
                pref.put("SEAMCAT_LF", selected.getClassName());
                JOptionPane.showMessageDialog(this, "Changes to SEAMCAT's look and feel will not be activated\nuntil the application is restarted.");
            }
        }
        super.setVisible(false);
    }

    @Override
    public void setVisible(boolean value) {
        this.filename.setText(Model.getSeamcatHomeBaseDir());
        this.loglevel.setSelectedItem(Logger.getRootLogger().getLevel());
        this.formats.setSelectedItem(Model.getInstance().getLogFilePattern().getConversionPattern());
        this.logTestLayout.setConversionPattern(this.formats.getSelectedItem().toString());
        this.showWelcomeScreen.setSelected(Model.getInstance().showWelcomeScreen());
        super.setVisible(value);
    }
}

