/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.seamcat.function.DiscreteFunction;
import org.seamcat.function.MaskFunctionImpl;
import org.seamcat.model.geometry.Point2D;

public class DialogTableToDataSet {
    private static boolean pointXExistsInList(List<? extends Point2D> data, double x) {
        boolean exists = false;
        for (Point2D point2D : data) {
            if (point2D.getX() != x) continue;
            exists = true;
        }
        return exists;
    }

    public static void symmetrize(List<Point2D> data, double symmetryPoint) {
        ArrayList<Point2D> newPoints = new ArrayList<Point2D>();
        for (Point2D point : data) {
            double x = symmetryPoint + symmetryPoint - point.getX();
            if (DialogTableToDataSet.pointXExistsInList(data, x)) continue;
            newPoints.add(new Point2D(x, point.getY()));
        }
        if (newPoints.size() > 0) {
            data.addAll(newPoints);
        }
    }

    public static void symmetrizeFunction(DiscreteFunction function, double symmetryPoint) {
        List<Point2D> points = function.points();
        ArrayList<Point2D> symmetryPoints = new ArrayList<Point2D>();
        HashMap<Point2D, Double> mask = new HashMap<Point2D, Double>();
        for (Point2D point : points) {
            double x = symmetryPoint + symmetryPoint - point.getX();
            if (DialogTableToDataSet.pointXExistsInList(function.points(), x)) continue;
            Point2D sym = new Point2D(x, point.getY());
            symmetryPoints.add(sym);
            if (!(function instanceof MaskFunctionImpl)) continue;
            mask.put(sym, ((MaskFunctionImpl)function).getMask(point));
        }
        for (Point2D point : symmetryPoints) {
            function.addPoint(point);
            if (!(function instanceof MaskFunctionImpl)) continue;
            ((MaskFunctionImpl)function).setMask(point, (Double)mask.get(point));
        }
    }
}

