/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.border.TitledBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;
import org.seamcat.calculator.CalculatorInputField;
import org.seamcat.function.DiscreteFunction;
import org.seamcat.function.WithPoints;
import org.seamcat.help.SeamcatHelpResolver;
import org.seamcat.model.distributions.AbstractDistribution;
import org.seamcat.model.distributions.ConstantDistributionImpl;
import org.seamcat.model.distributions.DiscreteUniformDistributionImpl;
import org.seamcat.model.distributions.GaussianDistributionImpl;
import org.seamcat.model.distributions.LimitedGaussianDistribution;
import org.seamcat.model.distributions.LimitedGaussianDistributionImpl;
import org.seamcat.model.distributions.LimitedRayleighDistribution;
import org.seamcat.model.distributions.LimitedRayleighDistributionImpl;
import org.seamcat.model.distributions.LogNormalDistribution;
import org.seamcat.model.distributions.LogNormalDistributionImpl;
import org.seamcat.model.distributions.RayleighDistributionImpl;
import org.seamcat.model.distributions.StairDistributionImpl;
import org.seamcat.model.distributions.UniformDistributionImpl;
import org.seamcat.model.distributions.UniformPolarAngleDistributionImpl;
import org.seamcat.model.distributions.UniformPolarDistanceDistributionImpl;
import org.seamcat.model.distributions.UserDefinedDistributionImpl;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.presentation.DialogTableToDataSet;
import org.seamcat.presentation.EscapeDialog;
import org.seamcat.presentation.LabeledPairLayout;
import org.seamcat.presentation.components.FunctionButtonPanel;
import org.seamcat.presentation.components.NavigateButtonPanel;
import org.seamcat.presentation.components.SeamcatTable;
import org.seamcat.presentation.components.StairDistributionGraph;
import org.seamcat.presentation.components.StairDistributionTableModelAdapter;
import org.seamcat.presentation.components.UserDefinedFunctionPanel;

public class DistributionDialog
extends EscapeDialog {
    private static final int CONSTANT = 0;
    private static final int DISCRETEUNIFORM = 8;
    private static final int GAUSSIAN = 3;
    private static final String[] LAYOUTS = new String[]{"NON_USERDEFINED_LAYOUT", "USERDEFINED_LAYOUT", "USERDEFINED_STAIR_LAYOUT"};
    private static final Logger LOG = Logger.getLogger(DistributionDialog.class);
    private static final int NON_USERDEFINED_LAYOUT = 0;
    private static final int RAYLEIGH = 4;
    private static final ResourceBundle STRINGLIST = ResourceBundle.getBundle("stringlist", Locale.ENGLISH);
    private static final int UNIFORM = 2;
    private static final int UNIFORMPOLARANGLE = 6;
    private static final int UNIFORMPOLARDISTANCE = 5;
    private static final int USERDEFINED = 1;
    private static final int USERDEFINED_LAYOUT = 1;
    private static final int USERDEFINED_STAIR_LAYOUT = 2;
    private static final int USERDEFINEDSTAIR = 7;
    private static final int LOGNORMAL = 9;
    private static final int GAUSSIAN_LIMITED = 10;
    private static final int RAYLEIGH_LIMITED = 11;
    private final String[] enabledDistributions;
    private DistributionCheck check;
    private final CardLayout contentPanelLayout = new CardLayout();
    private final JPanel contentPanel = new JPanel(this.contentPanelLayout);
    private final DistributionState CONSTANT_STATE = new ConstantDistributionState();
    private final DistributionState DISCRETEUNIFORM_STATE = new DiscreteUniformDistributionState();
    private final DistributionState GAUSSIAN_STATE = new GaussianDistributionState();
    private final DistributionState RAYLEIGH_STATE = new RayleighDistributionState();
    private final DistributionState UNIFORM_STATE = new UniformDistributionState();
    private final DistributionState UNIFORMPOLARANGLE_STATE = new UniformPolarAngleDistributionState();
    private final DistributionState UNIFORMPOLARDISTANCE_STATE = new UniformPolarDistanceDistributionState();
    private final DistributionState USERDEFINED_STATE = new UserDefinedDistributionState();
    private final DistributionState LOGNORMAL_STATE = new LogNormalDistributionState();
    private final DistributionState GAUSSIAN_LIMITED_STATE = new GaussianLimitedDistributionState();
    private final DistributionState RAYLEIGH_LIMITED_STATE = new RayleighLimitedDistributionState();
    private ParametersPanel parametersPanel = new ParametersPanel();
    private StairDistributionPanel stairDistributionPanel = new StairDistributionPanel();
    private DistributionState state;
    private TypePanel typePanel = new TypePanel();
    private final DistributionCheck userDefinedCheck = new UserDefinedDistributionCheck();
    private UserDefinedFunctionPanel userDefinedFunctionPanel = new UserDefinedFunctionPanel("User defined distribution", "Value", "Probability");
    private final DistributionState USERDEFINEDSTAIR_STATE = new UserDefinedStairDistributionState();

    public DistributionDialog(Frame parent, boolean modal, String[] enabledDistributions) {
        super(parent, modal);
        this.enabledDistributions = enabledDistributions;
        this.create();
        this.setLocationRelativeTo(parent);
    }

    private void create() {
        this.typePanel.handleEnablement();
        this.setSize(new Dimension(700, 450));
        this.userDefinedFunctionPanel.getModel().addTableModelListener(new FunctionPointsVerifier());
        this.userDefinedFunctionPanel.setUsePropabilitySymmetrizeFunction(true);
        this.contentPanel.add((Component)this.parametersPanel, LAYOUTS[0]);
        this.contentPanel.add((Component)this.userDefinedFunctionPanel, LAYOUTS[1]);
        this.contentPanel.add((Component)this.stairDistributionPanel, LAYOUTS[2]);
        this.getContentPane().add((Component)this.typePanel, "West");
        this.getContentPane().add((Component)new NavigateButtonPanel(this){

            @Override
            public void btnOkActionPerformed() {
                if (DistributionDialog.this.check != null && !DistributionDialog.this.check.validate(DistributionDialog.this.state.getDistribution())) {
                    JOptionPane.showMessageDialog(DistributionDialog.this, DistributionDialog.this.check.getErrorString(), "Distribution not valid", 2);
                    return;
                }
                if (DistributionDialog.this.state == DistributionDialog.this.USERDEFINED_STATE) {
                    DistributionDialog.this.userDefinedFunctionPanel.stopEditing();
                } else if (DistributionDialog.this.state == DistributionDialog.this.USERDEFINEDSTAIR_STATE) {
                    StairDistributionImpl stair = (StairDistributionImpl)DistributionDialog.this.state.getDistribution();
                    if (!stair.validate()) {
                        JOptionPane.showMessageDialog(DistributionDialog.this, "Cumulative Probability MUST be between 0 and 1. It also need to include the value 1", "CDF Warning", 2);
                        return;
                    }
                    DistributionDialog.this.stairDistributionPanel.stopEditing();
                }
                super.btnOkActionPerformed();
            }
        }, "South");
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.registerHelp();
    }

    private void registerHelp() {
        KeyStroke stroke = KeyStroke.getKeyStroke(112, 0);
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SeamcatHelpResolver.showHelp(DistributionDialog.this);
            }
        }, stroke, 2);
    }

    public AbstractDistribution getDistribution() {
        if (this.state != null) {
            return this.state.getDistribution();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("There's no active distribution state. Cannot return Distribution object");
        }
        throw new IllegalStateException("No distribution entered");
    }

    protected void setState(DistributionState s) {
        if (this.state != null) {
            this.state.leaveState();
        }
        this.state = s;
        if (this.state != null) {
            this.state.enterState();
        }
    }

    public boolean showDistributionDialog(AbstractDistribution d, String windowtitle) {
        return this.showDistributionDialog(d, windowtitle, null);
    }

    public boolean showDistributionDialog(AbstractDistribution d, String windowtitle, DistributionCheck _check) {
        DistributionCheck distributionCheck = this.check = _check != null ? _check : this.userDefinedCheck;
        if (d == null) {
            d = new ConstantDistributionImpl(33.0);
            if (LOG.isDebugEnabled()) {
                LOG.debug("showDistributionDialog() was called with <null>. Defaulting to ConstantDistribution");
            }
        }
        if (d instanceof ConstantDistributionImpl) {
            this.setState(this.CONSTANT_STATE);
        } else if (d instanceof UniformDistributionImpl) {
            this.setState(this.UNIFORM_STATE);
        } else if (d instanceof GaussianDistributionImpl) {
            this.setState(this.GAUSSIAN_STATE);
        } else if (d instanceof RayleighDistributionImpl) {
            this.setState(this.RAYLEIGH_STATE);
        } else if (d instanceof UniformPolarAngleDistributionImpl) {
            this.setState(this.UNIFORMPOLARANGLE_STATE);
        } else if (d instanceof UniformPolarDistanceDistributionImpl) {
            this.setState(this.UNIFORMPOLARDISTANCE_STATE);
        } else if (d instanceof DiscreteUniformDistributionImpl) {
            this.setState(this.DISCRETEUNIFORM_STATE);
        } else if (d instanceof UserDefinedDistributionImpl) {
            this.setState(this.USERDEFINED_STATE);
        } else if (d instanceof StairDistributionImpl) {
            this.setState(this.USERDEFINEDSTAIR_STATE);
        } else if (d instanceof LogNormalDistributionImpl) {
            this.setState(this.LOGNORMAL_STATE);
        } else if (d instanceof LimitedGaussianDistributionImpl) {
            this.setState(this.GAUSSIAN_LIMITED_STATE);
        } else if (d instanceof LimitedRayleighDistributionImpl) {
            this.setState(this.RAYLEIGH_LIMITED_STATE);
        } else {
            throw new IllegalArgumentException("Unknown distribution type <" + d.getClass() + ">");
        }
        this.state.setDistribution(d);
        this.setTitle(windowtitle);
        this.setAccept(false);
        super.setVisible(true);
        this.check = null;
        return this.isAccept();
    }

    public boolean showDistributionDialog(String title) {
        return this.showDistributionDialog(null, title);
    }

    private class RayleighLimitedDistributionState
    extends DistributionState {
        private RayleighLimitedDistributionState() {
        }

        @Override
        public AbstractDistribution getDistribution() {
            return new LimitedRayleighDistributionImpl(DistributionDialog.this.parametersPanel.getComponentValue(3), DistributionDialog.this.parametersPanel.getComponentValue(4), DistributionDialog.this.parametersPanel.getComponentValue(2));
        }

        @Override
        protected void setComponentState(boolean enabled) {
            if (enabled) {
                DistributionDialog.this.typePanel.setSelectedButton(11);
            }
            DistributionDialog.this.parametersPanel.setComponentState(3, enabled);
            DistributionDialog.this.parametersPanel.setComponentState(4, enabled);
            DistributionDialog.this.parametersPanel.setComponentState(2, enabled);
        }

        @Override
        public void setDistribution(AbstractDistribution d) throws IllegalArgumentException {
            if (!(d instanceof LimitedRayleighDistribution)) {
                throw new IllegalArgumentException("Instance should be of class RayleighDistribution limited");
            }
            DistributionDialog.this.parametersPanel.setComponentValue(3, new Double(d.getMin()));
            DistributionDialog.this.parametersPanel.setComponentValue(4, new Double(d.getMax()));
            DistributionDialog.this.parametersPanel.setComponentValue(2, new Double(d.getStdDev()));
        }
    }

    private class GaussianLimitedDistributionState
    extends DistributionState {
        private GaussianLimitedDistributionState() {
        }

        @Override
        public AbstractDistribution getDistribution() {
            return new LimitedGaussianDistributionImpl(DistributionDialog.this.parametersPanel.getComponentValue(3), DistributionDialog.this.parametersPanel.getComponentValue(4), DistributionDialog.this.parametersPanel.getComponentValue(2));
        }

        @Override
        protected void setComponentState(boolean enabled) {
            if (enabled) {
                DistributionDialog.this.typePanel.setSelectedButton(10);
            }
            DistributionDialog.this.parametersPanel.setComponentState(3, enabled);
            DistributionDialog.this.parametersPanel.setComponentState(4, enabled);
            DistributionDialog.this.parametersPanel.setComponentState(2, enabled);
        }

        @Override
        public void setDistribution(AbstractDistribution d) throws IllegalArgumentException {
            if (!(d instanceof LimitedGaussianDistribution)) {
                throw new IllegalArgumentException("Instance should be of class GaussianDistribution limited");
            }
            DistributionDialog.this.parametersPanel.setComponentValue(3, new Double(d.getMin()));
            DistributionDialog.this.parametersPanel.setComponentValue(4, new Double(d.getMax()));
            DistributionDialog.this.parametersPanel.setComponentValue(2, new Double(d.getStdDev()));
        }
    }

    private static class UserDefinedDistributionCheck
    implements DistributionCheck {
        private String errorMsg;

        private UserDefinedDistributionCheck() {
        }

        @Override
        public String getErrorString() {
            return this.errorMsg;
        }

        @Override
        public boolean validate(AbstractDistribution d) {
            this.errorMsg = null;
            if (d instanceof UserDefinedDistributionImpl) {
                UserDefinedDistributionImpl dist = (UserDefinedDistributionImpl)d;
                DiscreteFunction f = (DiscreteFunction)dist.getCdf();
                int zeroYCount = 0;
                int oneYCount = 0;
                int illegalValueCount = 0;
                for (Point2D p : f.points()) {
                    double y = p.getY();
                    if (y == 0.0) {
                        ++zeroYCount;
                    }
                    if (y == 1.0) {
                        ++oneYCount;
                    }
                    if (!(y < 0.0) && !(y > 1.0)) continue;
                    ++illegalValueCount;
                }
                if (zeroYCount == 0) {
                    this.errorMsg = "User-defined distribution doesn't include 0";
                } else if (oneYCount == 0) {
                    this.errorMsg = "User-defined distribution doesn't include 1";
                } else if (zeroYCount > 1) {
                    this.errorMsg = "User-defined distribution has 0 more than once";
                } else if (oneYCount > 1) {
                    this.errorMsg = "User-defined distribution has 1 more than once";
                } else if (illegalValueCount > 0) {
                    this.errorMsg = "User-defined distribution values outside the allowed range (0.0 - 1.0)";
                }
            }
            return this.errorMsg == null;
        }
    }

    private class UserDefinedStairDistributionState
    extends UserDefinedDistributionState {
        private UserDefinedStairDistributionState() {
        }

        @Override
        public void enterState() {
            super.enterState();
            DistributionDialog.this.contentPanelLayout.show(DistributionDialog.this.contentPanel, LAYOUTS[2]);
        }

        @Override
        public AbstractDistribution getDistribution() {
            return new StairDistributionImpl(new DiscreteFunction(DistributionDialog.this.stairDistributionPanel.getPoints()));
        }

        @Override
        protected void setComponentState(boolean enabled) {
            if (enabled) {
                DistributionDialog.this.typePanel.setSelectedButton(7);
            }
        }

        @Override
        public void setDistribution(AbstractDistribution d) throws IllegalArgumentException {
            DistributionDialog.this.stairDistributionPanel.setStairDistribution((StairDistributionImpl)d);
        }
    }

    private class UserDefinedDistributionState
    extends DistributionState {
        private UserDefinedDistributionState() {
        }

        @Override
        public void enterState() {
            super.enterState();
            DistributionDialog.this.userDefinedFunctionPanel.clear();
            DistributionDialog.this.contentPanelLayout.show(DistributionDialog.this.contentPanel, LAYOUTS[1]);
        }

        @Override
        public AbstractDistribution getDistribution() {
            return new UserDefinedDistributionImpl(DistributionDialog.this.userDefinedFunctionPanel.getDiscreteFunction());
        }

        @Override
        protected void setComponentState(boolean enabled) {
            if (enabled) {
                DistributionDialog.this.typePanel.setSelectedButton(1);
            }
        }

        @Override
        public void setDistribution(AbstractDistribution d) throws IllegalArgumentException {
            DistributionDialog.this.userDefinedFunctionPanel.setDiscreteFunction((DiscreteFunction)((UserDefinedDistributionImpl)d).getCdf());
        }
    }

    private class UniformPolarDistanceDistributionState
    extends NonUserDefinedDistributionState {
        private UniformPolarDistanceDistributionState() {
        }

        @Override
        public AbstractDistribution getDistribution() {
            return new UniformPolarDistanceDistributionImpl(DistributionDialog.this.parametersPanel.getComponentValue(5));
        }

        @Override
        protected void setComponentState(boolean enabled) {
            if (enabled) {
                DistributionDialog.this.typePanel.setSelectedButton(5);
            }
            DistributionDialog.this.parametersPanel.setComponentState(5, enabled);
        }

        @Override
        public void setDistribution(AbstractDistribution d) throws IllegalArgumentException {
            if (!(d instanceof UniformPolarDistanceDistributionImpl)) {
                throw new IllegalArgumentException("Instance should be of class UniformPolarDistanceDistribution");
            }
            DistributionDialog.this.parametersPanel.setComponentValue(5, d.getMaxDistance());
        }
    }

    private class UniformPolarAngleDistributionState
    extends NonUserDefinedDistributionState {
        private UniformPolarAngleDistributionState() {
        }

        @Override
        public AbstractDistribution getDistribution() {
            return new UniformPolarAngleDistributionImpl(DistributionDialog.this.parametersPanel.getComponentValue(6));
        }

        @Override
        protected void setComponentState(boolean enabled) {
            if (enabled) {
                DistributionDialog.this.typePanel.setSelectedButton(6);
            }
            DistributionDialog.this.parametersPanel.setComponentState(6, enabled);
        }

        @Override
        public void setDistribution(AbstractDistribution d) throws IllegalArgumentException {
            if (!(d instanceof UniformPolarAngleDistributionImpl)) {
                throw new IllegalArgumentException("Instance should be of class UniformPolarAngelDistribution (is " + d.getClass() + ")");
            }
            DistributionDialog.this.parametersPanel.setComponentValue(6, d.getMaxAngle());
        }
    }

    private class UniformDistributionState
    extends NonUserDefinedDistributionState {
        private UniformDistributionState() {
        }

        @Override
        public AbstractDistribution getDistribution() {
            return new UniformDistributionImpl(DistributionDialog.this.parametersPanel.getComponentValue(3), DistributionDialog.this.parametersPanel.getComponentValue(4));
        }

        @Override
        protected void setComponentState(boolean enabled) {
            if (enabled) {
                DistributionDialog.this.typePanel.setSelectedButton(2);
            }
            DistributionDialog.this.parametersPanel.setComponentState(3, enabled);
            DistributionDialog.this.parametersPanel.setComponentState(4, enabled);
        }

        @Override
        public void setDistribution(AbstractDistribution d) throws IllegalArgumentException {
            if (!(d instanceof UniformDistributionImpl)) {
                throw new IllegalArgumentException("Instance should be of class UniformDistribution");
            }
            DistributionDialog.this.parametersPanel.setComponentValue(3, d.getMin());
            DistributionDialog.this.parametersPanel.setComponentValue(4, d.getMax());
        }
    }

    private class TypePanel
    extends JPanel {
        private JRadioButton btnConstant = new JRadioButton(DistributionDialog.access$2800().getString("DISTRIBUTION_CONSTANT"));
        private JRadioButton btnDiscreteUniform = new JRadioButton(DistributionDialog.access$2800().getString("DISTRIBUTION_DISCRETE_UNIFORM"));
        private JRadioButton btnGaussian = new JRadioButton(DistributionDialog.access$2800().getString("DISTRIBUTION_GAUSSIAN"));
        private JRadioButton btnRayleigh = new JRadioButton(DistributionDialog.access$2800().getString("DISTRIBUTION_RAYLEIGH"));
        private JRadioButton btnUniform = new JRadioButton(DistributionDialog.access$2800().getString("DISTRIBUTION_UNIFORM"));
        private JRadioButton btnUniformPolarAngle = new JRadioButton(DistributionDialog.access$2800().getString("DISTRIBUTION_UNIFORM_POLAR_ANGLE"));
        private JRadioButton btnUniformPolarDist = new JRadioButton(DistributionDialog.access$2800().getString("DISTRIBUTION_UNIFORM_POLAR_DIST"));
        private JRadioButton btnUserDefined = new JRadioButton(DistributionDialog.access$2800().getString("DISTRIBUTION_USERDEFINED"));
        private JRadioButton btnUserDefinedStair = new JRadioButton(DistributionDialog.access$2800().getString("DISTRIBUTION_USERDEFINED_STAIR"));
        private JRadioButton btnLogNormal = new JRadioButton(DistributionDialog.access$2800().getString("DISTRIBUTION_LOG_NORMAL"));
        private JRadioButton btnGaussianLimited = new JRadioButton(DistributionDialog.access$2800().getString("DISTRIBUTION_GAUSSIAN_LIMITED"));
        private JRadioButton btnRayleighLimited = new JRadioButton(DistributionDialog.access$2800().getString("DISTRIBUTION_RAYLEIGH_LIMITED"));

        private Set<Integer> all() {
            LinkedHashSet<Integer> all = new LinkedHashSet<Integer>();
            all.add(0);
            all.add(8);
            all.add(3);
            all.add(4);
            all.add(2);
            all.add(6);
            all.add(5);
            all.add(1);
            all.add(7);
            all.add(9);
            all.add(10);
            all.add(11);
            return all;
        }

        public void handleEnablement() {
            this.btnConstant.setEnabled(true);
            this.btnDiscreteUniform.setEnabled(true);
            this.btnGaussian.setEnabled(true);
            this.btnRayleigh.setEnabled(true);
            this.btnUniform.setEnabled(true);
            this.btnUniformPolarAngle.setEnabled(true);
            this.btnUniformPolarDist.setEnabled(true);
            this.btnUserDefined.setEnabled(true);
            this.btnUserDefinedStair.setEnabled(true);
            this.btnLogNormal.setEnabled(true);
            this.btnGaussianLimited.setEnabled(true);
            this.btnRayleighLimited.setEnabled(true);
            Set<Integer> disable = this.all();
            String[] stringArray = DistributionDialog.this.enabledDistributions;
            int n = stringArray.length;
            block42: for (int i = 0; i < n; ++i) {
                String enabledDistribution;
                switch (enabledDistribution = stringArray[i]) {
                    case "CONSTANT": {
                        disable.remove(0);
                        continue block42;
                    }
                    case "DISCRETE_UNIFORM": {
                        disable.remove(8);
                        continue block42;
                    }
                    case "GAUSSIAN": {
                        disable.remove(3);
                        continue block42;
                    }
                    case "RAYLEIGH": {
                        disable.remove(4);
                        continue block42;
                    }
                    case "UNIFORM": {
                        disable.remove(2);
                        continue block42;
                    }
                    case "UNIFORM_POLAR_ANGLE": {
                        disable.remove(6);
                        continue block42;
                    }
                    case "UNIFORM_POLAR_DISTANCE": {
                        disable.remove(5);
                        continue block42;
                    }
                    case "USER_DEFINED": {
                        disable.remove(1);
                        continue block42;
                    }
                    case "STAIR": {
                        disable.remove(7);
                        continue block42;
                    }
                    case "LOG_NORMAL_LIMITED": {
                        disable.remove(9);
                        continue block42;
                    }
                    case "GAUSSIAN_LIMITED": {
                        disable.remove(10);
                        continue block42;
                    }
                    case "RAYLEIGH_LIMITED": {
                        disable.remove(11);
                    }
                }
            }
            for (Integer type : disable) {
                switch (type) {
                    case 0: {
                        this.btnConstant.setEnabled(false);
                        break;
                    }
                    case 8: {
                        this.btnDiscreteUniform.setEnabled(false);
                        break;
                    }
                    case 3: {
                        this.btnGaussian.setEnabled(false);
                        break;
                    }
                    case 4: {
                        this.btnRayleigh.setEnabled(false);
                        break;
                    }
                    case 2: {
                        this.btnUniform.setEnabled(false);
                        break;
                    }
                    case 6: {
                        this.btnUniformPolarAngle.setEnabled(false);
                        break;
                    }
                    case 5: {
                        this.btnUniformPolarDist.setEnabled(false);
                        break;
                    }
                    case 1: {
                        this.btnUserDefined.setEnabled(false);
                        break;
                    }
                    case 7: {
                        this.btnUserDefinedStair.setEnabled(false);
                        break;
                    }
                    case 9: {
                        this.btnLogNormal.setEnabled(false);
                        break;
                    }
                    case 10: {
                        this.btnGaussianLimited.setEnabled(false);
                        break;
                    }
                    case 11: {
                        this.btnRayleighLimited.setEnabled(false);
                    }
                }
            }
        }

        TypePanel() {
            ButtonGroup buttonGroupType = new ButtonGroup();
            buttonGroupType.add(this.btnConstant);
            buttonGroupType.add(this.btnDiscreteUniform);
            buttonGroupType.add(this.btnGaussian);
            buttonGroupType.add(this.btnRayleigh);
            buttonGroupType.add(this.btnUniform);
            buttonGroupType.add(this.btnUniformPolarAngle);
            buttonGroupType.add(this.btnUniformPolarDist);
            buttonGroupType.add(this.btnUserDefined);
            buttonGroupType.add(this.btnUserDefinedStair);
            buttonGroupType.add(this.btnLogNormal);
            buttonGroupType.add(this.btnGaussianLimited);
            buttonGroupType.add(this.btnRayleighLimited);
            this.btnConstant.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    TypePanel.this.btnConstantActionPerformed(evt);
                }
            });
            this.btnUserDefined.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    TypePanel.this.btnUserDefinedActionPerformed(evt);
                }
            });
            this.btnUniform.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    TypePanel.this.btnUniformActionPerformed(evt);
                }
            });
            this.btnGaussian.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    TypePanel.this.btnGaussianActionPerformed(evt);
                }
            });
            this.btnRayleigh.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    TypePanel.this.btnRayleighActionPerformed(evt);
                }
            });
            this.btnUniformPolarDist.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    TypePanel.this.btnUniformPolarDistActionPerformed(evt);
                }
            });
            this.btnUniformPolarAngle.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    TypePanel.this.btnUniformPolarAngleActionPerformed(evt);
                }
            });
            this.btnUserDefinedStair.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    TypePanel.this.btnUserDefinedStairActionPerformed(evt);
                }
            });
            this.btnDiscreteUniform.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    TypePanel.this.btnDiscreteUniformActionPerformed(evt);
                }
            });
            this.btnLogNormal.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    TypePanel.this.btnLogNormalActionPerformed(evt);
                }
            });
            this.btnGaussianLimited.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    TypePanel.this.btnGausianLimitedActionPerformed(evt);
                }
            });
            this.btnRayleighLimited.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TypePanel.this.btnRayleighLimitedActionPerformed(e);
                }
            });
            this.setLayout(new BoxLayout(this, 1));
            this.add(this.btnConstant);
            this.add(this.btnUserDefined);
            this.add(this.btnUniform);
            this.add(this.btnGaussian);
            this.add(this.btnRayleigh);
            this.add(this.btnUniformPolarDist);
            this.add(this.btnUniformPolarAngle);
            this.add(this.btnUserDefinedStair);
            this.add(this.btnDiscreteUniform);
            this.add(this.btnLogNormal);
            this.add(this.btnGaussianLimited);
            this.add(this.btnRayleighLimited);
            this.setBorder(new TitledBorder("Type"));
        }

        private void btnRayleighLimitedActionPerformed(ActionEvent e) {
            DistributionDialog.this.setState(DistributionDialog.this.RAYLEIGH_LIMITED_STATE);
        }

        private void btnGausianLimitedActionPerformed(ActionEvent evt) {
            DistributionDialog.this.setState(DistributionDialog.this.GAUSSIAN_LIMITED_STATE);
        }

        private void btnConstantActionPerformed(ActionEvent e) {
            DistributionDialog.this.setState(DistributionDialog.this.CONSTANT_STATE);
        }

        private void btnDiscreteUniformActionPerformed(ActionEvent e) {
            DistributionDialog.this.setState(DistributionDialog.this.DISCRETEUNIFORM_STATE);
        }

        private void btnGaussianActionPerformed(ActionEvent e) {
            DistributionDialog.this.setState(DistributionDialog.this.GAUSSIAN_STATE);
        }

        private void btnLogNormalActionPerformed(ActionEvent evt) {
            DistributionDialog.this.setState(DistributionDialog.this.LOGNORMAL_STATE);
        }

        private void btnRayleighActionPerformed(ActionEvent e) {
            DistributionDialog.this.setState(DistributionDialog.this.RAYLEIGH_STATE);
        }

        private void btnUniformActionPerformed(ActionEvent e) {
            DistributionDialog.this.setState(DistributionDialog.this.UNIFORM_STATE);
        }

        private void btnUniformPolarAngleActionPerformed(ActionEvent e) {
            DistributionDialog.this.setState(DistributionDialog.this.UNIFORMPOLARANGLE_STATE);
        }

        private void btnUniformPolarDistActionPerformed(ActionEvent e) {
            DistributionDialog.this.setState(DistributionDialog.this.UNIFORMPOLARDISTANCE_STATE);
        }

        private void btnUserDefinedActionPerformed(ActionEvent e) {
            DistributionDialog.this.setState(DistributionDialog.this.USERDEFINED_STATE);
        }

        private void btnUserDefinedStairActionPerformed(ActionEvent e) {
            DistributionDialog.this.setState(DistributionDialog.this.USERDEFINEDSTAIR_STATE);
        }

        public void setSelectedButton(int button) {
            switch (button) {
                case 0: {
                    this.btnConstant.setSelected(true);
                    this.btnConstant.requestFocus();
                    break;
                }
                case 1: {
                    this.btnUserDefined.setSelected(true);
                    this.btnUserDefined.requestFocus();
                    break;
                }
                case 2: {
                    this.btnUniform.setSelected(true);
                    this.btnUniform.requestFocus();
                    break;
                }
                case 3: {
                    this.btnGaussian.setSelected(true);
                    this.btnGaussian.requestFocus();
                    break;
                }
                case 4: {
                    this.btnRayleigh.setSelected(true);
                    this.btnRayleigh.requestFocus();
                    break;
                }
                case 5: {
                    this.btnUniformPolarDist.setSelected(true);
                    this.btnUniformPolarDist.requestFocus();
                    break;
                }
                case 6: {
                    this.btnUniformPolarAngle.setSelected(true);
                    this.btnUniformPolarAngle.requestFocus();
                    break;
                }
                case 7: {
                    this.btnUserDefinedStair.setSelected(true);
                    this.btnUserDefinedStair.requestFocus();
                    break;
                }
                case 8: {
                    this.btnDiscreteUniform.setSelected(true);
                    this.btnDiscreteUniform.requestFocus();
                    break;
                }
                case 9: {
                    this.btnLogNormal.setSelected(true);
                    this.btnLogNormal.requestFocus();
                    break;
                }
                case 10: {
                    this.btnGaussianLimited.setSelected(true);
                    this.btnGaussianLimited.requestFocus();
                    break;
                }
                case 11: {
                    this.btnRayleighLimited.setSelected(true);
                    this.btnRayleighLimited.requestFocus();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal button state");
                }
            }
        }
    }

    private static class StairDistributionPanel
    extends JPanel {
        private JTable dataTable;
        private StairDistributionGraph functionGraph;
        private StairDistributionTableModelAdapter model = new StairDistributionTableModelAdapter();

        public StairDistributionPanel() {
            this.dataTable = new SeamcatTable(this.model);
            this.dataTable.getColumnModel().getColumn(1).setCellRenderer(new DecimalFormatRenderer());
            JScrollPane dataTableScrollPane = new JScrollPane(this.dataTable);
            this.functionGraph = new StairDistributionGraph(this.model);
            this.setLayout(new BoxLayout(this, 0));
            this.add(dataTableScrollPane);
            this.add(new DialogFunctionButtonPanel());
            this.add(this.functionGraph);
            this.setBorder(new TitledBorder("Stair distribution"));
        }

        public List<Point2D> getPoints() {
            return this.model.getPointsList();
        }

        public void setStairDistribution(StairDistributionImpl d) {
            this.model.setPoints(d);
        }

        public void stopEditing() {
            if (this.dataTable.isEditing()) {
                this.dataTable.getCellEditor().stopCellEditing();
            }
        }

        static class DecimalFormatRenderer
        extends DefaultTableCellRenderer {
            private static final DecimalFormat formatter = new DecimalFormat("0.00000");

            DecimalFormatRenderer() {
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                value = formatter.format((Number)value);
                return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
        }

        private class DialogFunctionButtonPanel
        extends FunctionButtonPanel {
            public DialogFunctionButtonPanel() {
                super(null, "Value", "Cum. Prob.");
            }

            @Override
            public void saveChartImage() {
                StairDistributionPanel.this.functionGraph.saveChartImage();
            }

            @Override
            public void btnAddActionPerformed() {
                ((StairDistributionTableModelAdapter)StairDistributionPanel.this.dataTable.getModel()).addRow();
            }

            @Override
            public void btnClearActionPerformed() {
                ((StairDistributionTableModelAdapter)StairDistributionPanel.this.dataTable.getModel()).clear();
            }

            @Override
            public void btnDeleteActionPerformed() {
                StairDistributionPanel.this.model.deleteRow(StairDistributionPanel.this.dataTable.getSelectedRow());
            }

            @Override
            public void btnLoadActionPerformed() {
                if (this.fileChooser.showOpenDialog(this) == 0) {
                    this.fileio.setFile(this.fileChooser.getSelectedFile());
                    WithPoints function = (WithPoints)((Object)this.fileio.loadFunction());
                    StairDistributionPanel.this.model.setPoints(function.points());
                }
            }

            @Override
            public void btnSaveActionPerformed() {
                File selectedFile;
                if (this.fileChooser.showSaveDialog(this) == 0 && this.okToSave(selectedFile = this.alignSelectedFile())) {
                    this.fileio.setFile(this.fileChooser.getSelectedFile());
                    this.fileio.savePoints(StairDistributionPanel.this.model.getPointsList());
                }
            }

            @Override
            public void btnSymActionPerformed() {
                DialogTableToDataSet.symmetrize(StairDistributionPanel.this.model.getPointsList(), 0.0);
                StairDistributionPanel.this.model.sortPoints();
                StairDistributionPanel.this.model.fireChangeListeners();
            }
        }
    }

    private class RayleighDistributionState
    extends NonUserDefinedDistributionState {
        private RayleighDistributionState() {
        }

        @Override
        public AbstractDistribution getDistribution() {
            return new RayleighDistributionImpl(DistributionDialog.this.parametersPanel.getComponentValue(3), DistributionDialog.this.parametersPanel.getComponentValue(2));
        }

        @Override
        protected void setComponentState(boolean enabled) {
            if (enabled) {
                DistributionDialog.this.typePanel.setSelectedButton(4);
            }
            DistributionDialog.this.parametersPanel.setComponentState(3, enabled);
            DistributionDialog.this.parametersPanel.setComponentState(2, enabled);
        }

        @Override
        public void setDistribution(AbstractDistribution d) throws IllegalArgumentException {
            if (!(d instanceof RayleighDistributionImpl)) {
                throw new IllegalArgumentException("Instance should be of class RayleighDistribution");
            }
            DistributionDialog.this.parametersPanel.setComponentValue(3, d.getMin());
            DistributionDialog.this.parametersPanel.setComponentValue(2, d.getStdDev());
        }
    }

    private class ParametersPanel
    extends JPanel {
        public static final int CONSTANT = 0;
        public static final int MEAN = 1;
        public static final int STDDEV = 2;
        public static final int MIN = 3;
        public static final int MAX = 4;
        public static final int MAXDISTANCE = 5;
        public static final int MAXANGLE = 6;
        public static final int STEP = 7;
        public static final int STEPSHIFT = 8;
        private JLabel lblConstant;
        private JLabel lblMax;
        private JLabel lblMaxAngle;
        private JLabel lblMaxDistance;
        private JLabel lblMean;
        private JLabel lblMin;
        private JLabel lblStdDev;
        private JLabel lblStep;
        private JLabel lblStepShift;
        private JLabel shiftNote;
        private JFormattedTextField tfConstant;
        private JFormattedTextField tfMax;
        private JFormattedTextField tfMaxAngle;
        private JFormattedTextField tfMaxDistance;
        private JFormattedTextField tfMean;
        private JFormattedTextField tfMin;
        private JFormattedTextField tfStdDev;
        private JFormattedTextField tfStep;
        private JFormattedTextField tfStepShift;
        private NumberFormat nf;

        public void writeHelp() {
            boolean enabled = DistributionDialog.this.typePanel.btnDiscreteUniform.isSelected();
            if (enabled) {
                double min = DistributionDialog.this.parametersPanel.getComponentValue(3);
                double max = DistributionDialog.this.parametersPanel.getComponentValue(4);
                double step = DistributionDialog.this.parametersPanel.getComponentValue(7);
                double shift = DistributionDialog.this.parametersPanel.getComponentValue(8);
                double first = min + shift;
                double second = min + shift + step;
                double last = max - step + shift;
                if (Math.abs(shift) < 1.0E-6) {
                    DistributionDialog.this.parametersPanel.setShiftText("[" + this.nf.format(first) + ", " + this.nf.format(second) + ", ..., " + this.nf.format(max) + "]");
                } else {
                    DistributionDialog.this.parametersPanel.setShiftText("[" + this.nf.format(first) + ", " + this.nf.format(second) + ", ..., " + this.nf.format(last) + "]");
                }
            } else {
                DistributionDialog.this.parametersPanel.setShiftText("");
            }
        }

        public ParametersPanel() {
            super(new FlowLayout(0));
            this.lblConstant = new JLabel(STRINGLIST.getString("DISTRIBUTION_CONSTANT"));
            this.lblMax = new JLabel(STRINGLIST.getString("DISTRIBUTION_PARAM_MAX"));
            this.lblMaxAngle = new JLabel(STRINGLIST.getString("DISTRIBUTION_PARAM_MAXANGLE"));
            this.lblMaxDistance = new JLabel(STRINGLIST.getString("DISTRIBUTION_PARAM_MAXDIST"));
            this.lblMean = new JLabel(STRINGLIST.getString("DISTRIBUTION_PARAM_MEAN"));
            this.lblMin = new JLabel(STRINGLIST.getString("DISTRIBUTION_PARAM_MIN"));
            this.lblStdDev = new JLabel(STRINGLIST.getString("DISTRIBUTION_PARAM_STDDEV"));
            this.lblStep = new JLabel(STRINGLIST.getString("DISTRIBUTION_PARAM_STEP"));
            this.lblStepShift = new JLabel(STRINGLIST.getString("DISTRIBUTION_STEP_SHIFT"));
            this.shiftNote = new JLabel();
            this.tfConstant = new CalculatorInputField(30.0);
            this.tfMax = new CalculatorInputField(1.0);
            this.tfMaxAngle = new CalculatorInputField(360.0);
            this.tfMaxDistance = new CalculatorInputField(1.0);
            this.tfMean = new CalculatorInputField(0.0);
            this.tfMin = new CalculatorInputField(0.0);
            this.tfStdDev = new CalculatorInputField(0.0);
            this.tfStep = new CalculatorInputField(0.2);
            this.tfStepShift = new CalculatorInputField(0.0);
            this.nf = NumberFormat.getNumberInstance();
            FocusAdapter listener = new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    ParametersPanel.this.writeHelp();
                }
            };
            this.tfMin.addFocusListener(listener);
            this.tfMax.addFocusListener(listener);
            this.tfStep.addFocusListener(listener);
            this.tfStepShift.addFocusListener(listener);
            this.lblConstant.setLabelFor(this.tfConstant);
            this.lblMean.setLabelFor(this.tfMean);
            this.lblStdDev.setLabelFor(this.tfStdDev);
            this.lblMin.setLabelFor(this.tfMin);
            this.lblMax.setLabelFor(this.tfMax);
            this.lblMaxDistance.setLabelFor(this.tfMaxDistance);
            this.lblMaxAngle.setLabelFor(this.tfMaxAngle);
            this.lblStep.setLabelFor(this.tfMaxAngle);
            this.tfConstant.setEnabled(false);
            this.tfMean.setEnabled(false);
            this.tfStdDev.setEnabled(false);
            this.tfMin.setEnabled(false);
            this.tfMax.setEnabled(false);
            this.tfMaxDistance.setEnabled(false);
            this.tfMaxAngle.setEnabled(false);
            this.tfStep.setEnabled(false);
            this.tfStepShift.setEnabled(false);
            this.lblConstant.setEnabled(false);
            this.lblMean.setEnabled(false);
            this.lblStdDev.setEnabled(false);
            this.lblMin.setEnabled(false);
            this.lblMax.setEnabled(false);
            this.lblMaxDistance.setEnabled(false);
            this.lblMaxAngle.setEnabled(false);
            this.lblStep.setEnabled(false);
            this.lblStepShift.setEnabled(false);
            this.shiftNote.setEnabled(false);
            int columns = 12;
            this.tfConstant.setColumns(columns);
            this.tfMean.setColumns(columns);
            this.tfStdDev.setColumns(columns);
            this.tfMin.setColumns(columns);
            this.tfMax.setColumns(columns);
            this.tfMaxDistance.setColumns(columns);
            this.tfMaxAngle.setColumns(columns);
            this.tfStep.setColumns(columns);
            JPanel innerPanel = new JPanel(new LabeledPairLayout());
            innerPanel.add((Component)this.lblConstant, "label");
            innerPanel.add((Component)this.tfConstant, "field");
            innerPanel.add((Component)this.lblMean, "label");
            innerPanel.add((Component)this.tfMean, "field");
            innerPanel.add((Component)this.lblStdDev, "label");
            innerPanel.add((Component)this.tfStdDev, "field");
            innerPanel.add((Component)this.lblMin, "label");
            innerPanel.add((Component)this.tfMin, "field");
            innerPanel.add((Component)this.lblMax, "label");
            innerPanel.add((Component)this.tfMax, "field");
            innerPanel.add((Component)this.lblMaxDistance, "label");
            innerPanel.add((Component)this.tfMaxDistance, "field");
            innerPanel.add((Component)this.lblMaxAngle, "label");
            innerPanel.add((Component)this.tfMaxAngle, "field");
            innerPanel.add((Component)this.lblStep, "label");
            innerPanel.add((Component)this.tfStep, "field");
            innerPanel.add((Component)this.lblStepShift, "label");
            innerPanel.add((Component)this.tfStepShift, "field");
            innerPanel.add((Component)new JLabel(), "label");
            innerPanel.add((Component)this.shiftNote, "field");
            this.add(innerPanel);
            this.setBorder(new TitledBorder("Parameters"));
        }

        public double getComponentValue(int component) {
            switch (component) {
                case 0: {
                    return ((Number)this.tfConstant.getValue()).doubleValue();
                }
                case 1: {
                    return ((Number)this.tfMean.getValue()).doubleValue();
                }
                case 2: {
                    return ((Number)this.tfStdDev.getValue()).doubleValue();
                }
                case 3: {
                    return ((Number)this.tfMin.getValue()).doubleValue();
                }
                case 4: {
                    return ((Number)this.tfMax.getValue()).doubleValue();
                }
                case 5: {
                    return ((Number)this.tfMaxDistance.getValue()).doubleValue();
                }
                case 6: {
                    return ((Number)this.tfMaxAngle.getValue()).doubleValue();
                }
                case 7: {
                    return ((Number)this.tfStep.getValue()).doubleValue();
                }
                case 8: {
                    return ((Number)this.tfStepShift.getValue()).doubleValue();
                }
            }
            throw new IllegalArgumentException("Illegal componentvalue");
        }

        public void setShiftText(String text) {
            this.shiftNote.setText(text);
        }

        public void setComponentState(int component, boolean enabled) {
            switch (component) {
                case 0: {
                    this.lblConstant.setEnabled(enabled);
                    this.tfConstant.setEnabled(enabled);
                    break;
                }
                case 1: {
                    this.lblMean.setEnabled(enabled);
                    this.tfMean.setEnabled(enabled);
                    break;
                }
                case 2: {
                    this.lblStdDev.setEnabled(enabled);
                    this.tfStdDev.setEnabled(enabled);
                    break;
                }
                case 3: {
                    this.lblMin.setEnabled(enabled);
                    this.tfMin.setEnabled(enabled);
                    break;
                }
                case 4: {
                    this.lblMax.setEnabled(enabled);
                    this.tfMax.setEnabled(enabled);
                    break;
                }
                case 5: {
                    this.lblMaxDistance.setEnabled(enabled);
                    this.tfMaxDistance.setEnabled(enabled);
                    break;
                }
                case 6: {
                    this.lblMaxAngle.setEnabled(enabled);
                    this.tfMaxAngle.setEnabled(enabled);
                    break;
                }
                case 7: {
                    this.lblStep.setEnabled(enabled);
                    this.tfStep.setEnabled(enabled);
                    break;
                }
                case 8: {
                    this.lblStepShift.setEnabled(enabled);
                    this.tfStepShift.setEnabled(enabled);
                    this.shiftNote.setEnabled(enabled);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal componentvalue");
                }
            }
        }

        public void setComponentValue(int component, double value) {
            switch (component) {
                case 0: {
                    this.tfConstant.setValue(value);
                    break;
                }
                case 1: {
                    this.tfMean.setValue(value);
                    break;
                }
                case 2: {
                    this.tfStdDev.setValue(value);
                    break;
                }
                case 3: {
                    this.tfMin.setValue(value);
                    break;
                }
                case 4: {
                    this.tfMax.setValue(value);
                    break;
                }
                case 5: {
                    this.tfMaxDistance.setValue(value);
                    break;
                }
                case 6: {
                    this.tfMaxAngle.setValue(value);
                    break;
                }
                case 7: {
                    this.tfStep.setValue(value);
                    break;
                }
                case 8: {
                    this.tfStepShift.setValue(value);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal componentvalue");
                }
            }
        }
    }

    private abstract class NonUserDefinedDistributionState
    extends DistributionState {
        private NonUserDefinedDistributionState() {
        }

        @Override
        public void enterState() {
            super.enterState();
            DistributionDialog.this.contentPanelLayout.show(DistributionDialog.this.contentPanel, LAYOUTS[0]);
        }
    }

    private class LogNormalDistributionState
    extends NonUserDefinedDistributionState {
        private LogNormalDistributionState() {
        }

        @Override
        public AbstractDistribution getDistribution() {
            return new LogNormalDistributionImpl(DistributionDialog.this.parametersPanel.getComponentValue(4), DistributionDialog.this.parametersPanel.getComponentValue(1), DistributionDialog.this.parametersPanel.getComponentValue(2));
        }

        @Override
        protected void setComponentState(boolean enabled) {
            if (enabled) {
                DistributionDialog.this.typePanel.setSelectedButton(9);
            }
            DistributionDialog.this.parametersPanel.setComponentState(4, enabled);
            DistributionDialog.this.parametersPanel.setComponentState(1, enabled);
            DistributionDialog.this.parametersPanel.setComponentState(2, enabled);
        }

        @Override
        public void setDistribution(AbstractDistribution d) throws IllegalArgumentException {
            if (!(d instanceof LogNormalDistribution)) {
                throw new IllegalArgumentException("Instance should be of class LogNormalDistribution");
            }
            DistributionDialog.this.parametersPanel.setComponentValue(4, new Double(d.getMax()));
            DistributionDialog.this.parametersPanel.setComponentValue(1, new Double(d.getMean()));
            DistributionDialog.this.parametersPanel.setComponentValue(2, new Double(d.getStdDev()));
        }
    }

    private class GaussianDistributionState
    extends NonUserDefinedDistributionState {
        private GaussianDistributionState() {
        }

        @Override
        public AbstractDistribution getDistribution() {
            return new GaussianDistributionImpl(DistributionDialog.this.parametersPanel.getComponentValue(1), DistributionDialog.this.parametersPanel.getComponentValue(2));
        }

        @Override
        protected void setComponentState(boolean enabled) {
            if (enabled) {
                DistributionDialog.this.typePanel.setSelectedButton(3);
            }
            DistributionDialog.this.parametersPanel.setComponentState(1, enabled);
            DistributionDialog.this.parametersPanel.setComponentState(2, enabled);
        }

        @Override
        public void setDistribution(AbstractDistribution d) throws IllegalArgumentException {
            if (!(d instanceof GaussianDistributionImpl)) {
                throw new IllegalArgumentException("Instance should be of class GaussianDistribution");
            }
            DistributionDialog.this.parametersPanel.setComponentValue(1, new Double(d.getMean()));
            DistributionDialog.this.parametersPanel.setComponentValue(2, new Double(d.getStdDev()));
        }
    }

    private static class FunctionPointsVerifier
    implements TableModelListener {
        private FunctionPointsVerifier() {
        }

        @Override
        public void tableChanged(TableModelEvent t) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Change in column <" + t.getColumn() + "> first-row <" + t.getFirstRow() + "> last-row <" + t.getLastRow() + "> type <" + t.getType() + ">");
            }
            switch (t.getType()) {
                case -1: {
                    break;
                }
                case 0: {
                    double value;
                    if (t.getColumn() == 1 && ((value = ((Number)((TableModel)t.getSource()).getValueAt(t.getFirstRow(), t.getColumn())).doubleValue()) > 1.0 || value < 0.0)) {
                        JOptionPane.showMessageDialog(null, "Cumulated probability P(X < x) must be between 0 and 1", "Illegal value", 0);
                    }
                }
                case 1: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal TableModelEvent type. Must be INSERT/UPDATE or DELETE");
                }
            }
        }
    }

    private abstract class DistributionState {
        private DistributionState() {
        }

        public void enterState() {
            this.setComponentState(true);
            DistributionDialog.this.parametersPanel.writeHelp();
        }

        public abstract AbstractDistribution getDistribution();

        public void leaveState() {
            this.setComponentState(false);
        }

        protected abstract void setComponentState(boolean var1);

        public abstract void setDistribution(AbstractDistribution var1) throws IllegalArgumentException;
    }

    public static interface DistributionCheck {
        public String getErrorString();

        public boolean validate(AbstractDistribution var1);
    }

    private class DiscreteUniformDistributionState
    extends NonUserDefinedDistributionState {
        private DiscreteUniformDistributionState() {
        }

        @Override
        public AbstractDistribution getDistribution() {
            return new DiscreteUniformDistributionImpl(DistributionDialog.this.parametersPanel.getComponentValue(3), DistributionDialog.this.parametersPanel.getComponentValue(4), DistributionDialog.this.parametersPanel.getComponentValue(7), DistributionDialog.this.parametersPanel.getComponentValue(8));
        }

        @Override
        protected void setComponentState(boolean enabled) {
            if (enabled) {
                DistributionDialog.this.typePanel.setSelectedButton(8);
            }
            DistributionDialog.this.parametersPanel.setComponentState(3, enabled);
            DistributionDialog.this.parametersPanel.setComponentState(4, enabled);
            DistributionDialog.this.parametersPanel.setComponentState(7, enabled);
            DistributionDialog.this.parametersPanel.setComponentState(8, enabled);
        }

        @Override
        public void setDistribution(AbstractDistribution d) throws IllegalArgumentException {
            if (!(d instanceof DiscreteUniformDistributionImpl)) {
                throw new IllegalArgumentException("Instance should be of class DiscreteUniformDistribution");
            }
            DistributionDialog.this.parametersPanel.setComponentValue(3, d.getMin());
            DistributionDialog.this.parametersPanel.setComponentValue(4, d.getMax());
            DistributionDialog.this.parametersPanel.setComponentValue(7, d.getStep());
            DistributionDialog.this.parametersPanel.setComponentValue(8, d.getStepShift());
            DistributionDialog.this.parametersPanel.writeHelp();
        }
    }

    private class ConstantDistributionState
    extends NonUserDefinedDistributionState {
        private ConstantDistributionState() {
        }

        @Override
        public AbstractDistribution getDistribution() {
            return new ConstantDistributionImpl(DistributionDialog.this.parametersPanel.getComponentValue(0));
        }

        @Override
        protected void setComponentState(boolean enabled) {
            if (enabled) {
                DistributionDialog.this.typePanel.setSelectedButton(0);
            }
            DistributionDialog.this.parametersPanel.setComponentState(0, enabled);
        }

        @Override
        public void setDistribution(AbstractDistribution d) throws IllegalArgumentException {
            if (!(d instanceof ConstantDistributionImpl)) {
                throw new IllegalArgumentException("Instance should be of class ConstantDistribution");
            }
            DistributionDialog.this.parametersPanel.setComponentValue(0, d.getConstant());
        }
    }
}

