/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation;

import java.awt.Color;
import java.awt.Desktop;
import javax.swing.JEditorPane;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;

public class HtmlPanel
extends JEditorPane {
    public HtmlPanel(String message) {
        this.setContentType("text/html");
        this.setText(message);
        this.setColor(this.defaultColor(), null);
        this.setOpaque(false);
        this.setBorder(null);
        this.setEditable(false);
        this.setFocusable(false);
        this.addDefaultLinkListener();
    }

    public HtmlPanel(String message, String border) {
        this.setContentType("text/html");
        this.setText(message);
        this.setColor(this.defaultColor(), border);
        this.setOpaque(false);
        this.setBorder(null);
        this.setEditable(false);
        this.setFocusable(false);
        this.addDefaultLinkListener();
    }

    public HtmlPanel(String message, String border, String backgroundColor) {
        this.setContentType("text/html");
        this.setText(message);
        this.setColor(backgroundColor, border);
        this.setOpaque(false);
        this.setBorder(null);
        this.setEditable(false);
        this.setFocusable(false);
        this.addDefaultLinkListener();
    }

    private String defaultColor() {
        Color color = UIManager.getColor("Panel.background");
        return String.format("rgb(%d,%d,%d)", color.getRed(), color.getGreen(), color.getBlue());
    }

    private void setColor(String backgroundColor, String border) {
        String bodyRule = border == null ? "body { background-color: " + backgroundColor + "; } " : "body { background-color: " + backgroundColor + "; margin: " + border + ";} ";
        StyleSheet sheet = ((HTMLDocument)this.getDocument()).getStyleSheet();
        sheet.addRule(bodyRule);
    }

    public void setLinkColor(String linkColor) {
        String anchorRule = "a {color: " + linkColor + "}";
        StyleSheet sheet = ((HTMLDocument)this.getDocument()).getStyleSheet();
        sheet.addRule(anchorRule);
    }

    private void addDefaultLinkListener() {
        this.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED) && !e.getDescription().startsWith("#")) {
                    try {
                        Desktop.getDesktop().browse(e.getURL().toURI());
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
    }

    public static String image(String name, String url) {
        return "<a href='#" + name + "'><img src=\"" + url + "\"></a>";
    }

    public static String link(String url) {
        return "<a href=\"" + url + "\">" + url + "</a>";
    }

    public static String link(String url, String name) {
        return "<a href=\"" + url + "\">" + name + "</a>";
    }
}

