/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.presentation;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.seamcat.model.plugin.Plugin;
import org.seamcat.model.plugin.antenna.AntennaGainPlugin;
import org.seamcat.model.plugin.coverageradius.CoverageRadiusPlugin;
import org.seamcat.model.plugin.eventprocessing.EventProcessingPlugin;
import org.seamcat.model.plugin.propagation.PropagationModelPlugin;
import org.seamcat.model.plugin.system.SystemPlugin;
import org.seamcat.plugin.JarConfigurationModel;
import org.seamcat.plugin.PluginClass;
import org.seamcat.presentation.LabeledPairLayout;
import org.seamcat.presentation.genericgui.GenericPanel;
import org.seamcat.presentation.genericgui.item.ComponentWrapperItem;
import org.seamcat.presentation.genericgui.item.TextItem;

public class JarComponentPanel
extends JPanel {
    public JarComponentPanel(JarConfigurationModel model) {
        super(new BorderLayout());
        JPanel panel = new JPanel(new LabeledPairLayout());
        panel.add((Component)new JLabel(""), "field");
        this.add((Component)panel, "North");
        JPanel plugins = new JPanel(new BorderLayout());
        this.add((Component)plugins, "Center");
        if (model.hasPlugins()) {
            GenericPanel loaded = new GenericPanel();
            ComponentWrapperItem headline = new ComponentWrapperItem(new JLabel("The following classes have been loaded:"));
            loaded.addItem(headline);
            TextItem item = new TextItem().label("<html><b>Type</b></html>").readOnly();
            item.initialize();
            item.setValue("<html><b>Class</b></html>");
            loaded.addItem(item);
            for (Class<? extends SystemPlugin> clazz : model.getSystemPlugins()) {
                TextItem textItem = new TextItem();
                textItem.label("<html><i>SystemPlugin</i></html>").readOnly();
                textItem.initialize();
                textItem.setValue(clazz.getName());
                loaded.addItem(textItem);
            }
            for (PluginClass pluginClass : model.getPluginClasses()) {
                Class<? extends Plugin<?>> clazz = pluginClass.getPluginClass();
                String type = "";
                if (EventProcessingPlugin.class.isAssignableFrom(clazz)) {
                    type = "Event Processing";
                } else if (PropagationModelPlugin.class.isAssignableFrom(clazz)) {
                    type = "Propagation Model";
                } else if (AntennaGainPlugin.class.isAssignableFrom(clazz)) {
                    type = "Antenna Gain";
                } else if (CoverageRadiusPlugin.class.isAssignableFrom(clazz)) {
                    type = "Coverage Radius";
                }
                TextItem textItem = new TextItem();
                textItem.label("<html><i>" + type + "</i></html>").readOnly();
                textItem.initialize();
                textItem.setValue(pluginClass.getClassName());
                loaded.addItem(textItem);
            }
            loaded.initializeWidgets();
            plugins.add(loaded);
        } else {
            plugins.add((Component)new JLabel("<html><b color=\"red\"><i>Warning</i><br>No plugin classes found in jar file. This configuration will be deleted when closing the dialog</b></html>"), "North");
        }
        plugins.revalidate();
        plugins.repaint();
    }
}

